/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.mopub.common.AdReport;
import com.mopub.common.CloseableLayout;
import com.mopub.common.VisibleForTesting;
import com.mopub.mobileads.BaseBroadcastReceiver;
import com.mopub.mobileads.RewardedMraidCountdownRunnable;
import com.mopub.mobileads.VastVideoRadialCountdownWidget;
import com.mopub.mraid.MraidController;
import com.mopub.mraid.PlacementType;

public class RewardedMraidController
extends MraidController {
    @VisibleForTesting
    static final int DEFAULT_PLAYABLE_DURATION_FOR_CLOSE_BUTTON_MILLIS = 30000;
    public static final int DEFAULT_PLAYABLE_DURATION_FOR_CLOSE_BUTTON_SECONDS = 30;
    public static final boolean DEFAULT_PLAYABLE_SHOULD_REWARD_ON_CLICK = false;
    public static final int MILLIS_IN_SECOND = 1000;
    @VisibleForTesting
    static final long PLAYABLE_COUNTDOWN_UPDATE_INTERVAL_MILLIS = 250L;
    private final long mBroadcastIdentifier;
    private CloseableLayout mCloseableLayout;
    private RewardedMraidCountdownRunnable mCountdownRunnable;
    private int mCurrentElapsedTimeMillis;
    private boolean mIsCalibrationDone;
    private boolean mIsRewarded;
    private VastVideoRadialCountdownWidget mRadialCountdownWidget;
    private final int mShowCloseButtonDelay;
    private boolean mShowCloseButtonEventFired;

    @VisibleForTesting
    public RewardedMraidController(Context context, AdReport adReport, PlacementType placementType, int n2, long l3) {
        super(context, adReport, placementType);
        this.mShowCloseButtonDelay = (n2 *= 1000) >= 0 && n2 <= 30000 ? n2 : 30000;
        this.mBroadcastIdentifier = l3;
    }

    private void addRadialCountdownWidget(Context context, int n2) {
        context = new VastVideoRadialCountdownWidget(context);
        this.mRadialCountdownWidget = context;
        context.setVisibility(n2);
        context = (ViewGroup.MarginLayoutParams)this.mRadialCountdownWidget.getLayoutParams();
        context = new FrameLayout.LayoutParams(context.width + context.leftMargin + context.rightMargin, context.height + context.topMargin + context.bottomMargin);
        context.gravity = 53;
        this.mCloseableLayout.addView((View)this.mRadialCountdownWidget, (ViewGroup.LayoutParams)context);
    }

    private void startRunnables() {
        this.mCountdownRunnable.startRepeating(250L);
    }

    private void stopRunnables() {
        this.mCountdownRunnable.stop();
    }

    public boolean backButtonEnabled() {
        return this.mShowCloseButtonEventFired;
    }

    public void create(Context context, CloseableLayout closeableLayout) {
        this.mCloseableLayout = closeableLayout;
        closeableLayout.setCloseAlwaysInteractable(false);
        this.mCloseableLayout.setCloseVisible(false);
        this.addRadialCountdownWidget(context, 4);
        this.mRadialCountdownWidget.calibrateAndMakeVisible(this.mShowCloseButtonDelay);
        this.mIsCalibrationDone = true;
        this.mCountdownRunnable = new RewardedMraidCountdownRunnable(this, new Handler(Looper.getMainLooper()));
    }

    @Override
    public void destroy() {
        this.stopRunnables();
        super.destroy();
    }

    @Deprecated
    @VisibleForTesting
    public RewardedMraidCountdownRunnable getCountdownRunnable() {
        return this.mCountdownRunnable;
    }

    @Deprecated
    @VisibleForTesting
    public VastVideoRadialCountdownWidget getRadialCountdownWidget() {
        return this.mRadialCountdownWidget;
    }

    @Deprecated
    @VisibleForTesting
    public int getShowCloseButtonDelay() {
        return this.mShowCloseButtonDelay;
    }

    @Override
    protected void handleClose() {
        if (this.mShowCloseButtonEventFired) {
            super.handleClose();
        }
    }

    @Override
    protected void handleCustomClose(boolean bl) {
    }

    @Deprecated
    @VisibleForTesting
    public boolean isCalibrationDone() {
        return this.mIsCalibrationDone;
    }

    public boolean isPlayableCloseable() {
        boolean bl = !this.mShowCloseButtonEventFired && this.mCurrentElapsedTimeMillis >= this.mShowCloseButtonDelay;
        return bl;
    }

    @Deprecated
    @VisibleForTesting
    public boolean isRewarded() {
        return this.mIsRewarded;
    }

    @Deprecated
    @VisibleForTesting
    public boolean isShowCloseButtonEventFired() {
        return this.mShowCloseButtonEventFired;
    }

    public void pause() {
        this.stopRunnables();
        super.pause(false);
    }

    @Override
    public void resume() {
        super.resume();
        this.startRunnables();
    }

    public void showPlayableCloseButton() {
        this.mShowCloseButtonEventFired = true;
        this.mRadialCountdownWidget.setVisibility(8);
        this.mCloseableLayout.setCloseVisible(true);
        if (!this.mIsRewarded) {
            BaseBroadcastReceiver.broadcastAction(this.getContext(), this.mBroadcastIdentifier, "com.mopub.action.rewardedplayable.complete");
            this.mIsRewarded = true;
        }
    }

    public void updateCountdown(int n2) {
        this.mCurrentElapsedTimeMillis = n2;
        if (this.mIsCalibrationDone) {
            this.mRadialCountdownWidget.updateCountdownProgress(this.mShowCloseButtonDelay, n2);
        }
    }
}

