/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Drawables;
import com.mopub.mobileads.BaseVideoViewController;

public class MraidVideoViewController
extends BaseVideoViewController {
    private static final float CLOSE_BUTTON_PADDING = 8.0f;
    private static final float CLOSE_BUTTON_SIZE = 50.0f;
    private int mButtonPadding;
    private int mButtonSize;
    private ImageButton mCloseButton;
    private final VideoView mVideoView;

    public MraidVideoViewController(Context context, Bundle bundle, Bundle bundle2, BaseVideoViewController.BaseVideoViewControllerListener baseVideoViewControllerListener) {
        super(context, null, baseVideoViewControllerListener);
        context = new VideoView(context);
        this.mVideoView = context;
        context.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                mediaPlayer.setVideoScalingMode(1);
            }
        });
        this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                MraidVideoViewController.this.mCloseButton.setVisibility(0);
                MraidVideoViewController.this.videoCompleted(true);
            }
        });
        this.mVideoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                MraidVideoViewController.this.mCloseButton.setVisibility(0);
                MraidVideoViewController.this.videoError(false);
                return false;
            }
        });
        this.mVideoView.setVideoPath(bundle.getString("video_url"));
    }

    private void createInterstitialCloseButton() {
        this.mCloseButton = new ImageButton(this.getContext());
        StateListDrawable stateListDrawable = new StateListDrawable();
        Drawable drawable2 = Drawables.INTERSTITIAL_CLOSE_BUTTON_NORMAL.createDrawable(this.getContext());
        stateListDrawable.addState(new int[]{-16842919}, drawable2);
        drawable2 = Drawables.INTERSTITIAL_CLOSE_BUTTON_PRESSED.createDrawable(this.getContext());
        stateListDrawable.addState(new int[]{16842919}, drawable2);
        this.mCloseButton.setImageDrawable((Drawable)stateListDrawable);
        this.mCloseButton.setBackgroundDrawable(null);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MraidVideoViewController.this.getBaseVideoViewControllerListener().onFinish();
            }
        });
        int n2 = this.mButtonSize;
        stateListDrawable = new RelativeLayout.LayoutParams(n2, n2);
        stateListDrawable.addRule(11);
        n2 = this.mButtonPadding;
        stateListDrawable.setMargins(n2, 0, n2, 0);
        this.getLayout().addView((View)this.mCloseButton, (ViewGroup.LayoutParams)stateListDrawable);
    }

    protected VideoView getVideoView() {
        return this.mVideoView;
    }

    @Override
    protected void onBackPressed() {
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.mButtonSize = Dips.asIntPixels((float)50.0f, (Context)this.getContext());
        this.mButtonPadding = Dips.asIntPixels((float)8.0f, (Context)this.getContext());
        this.createInterstitialCloseButton();
        this.mCloseButton.setVisibility(8);
        this.mVideoView.start();
    }

    @Override
    protected void onDestroy() {
    }

    @Override
    protected void onPause() {
    }

    @Override
    protected void onResume() {
    }

    @Override
    protected void onSaveInstanceState(Bundle bundle) {
    }
}

