/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.content.Context;
import android.graphics.Rect;
import com.mopub.common.util.Dips;

class MraidScreenMetrics {
    private final Context mContext;
    private final Rect mCurrentAdRect;
    private final Rect mCurrentAdRectDips;
    private final Rect mDefaultAdRect;
    private final Rect mDefaultAdRectDips;
    private final float mDensity;
    private final Rect mRootViewRect;
    private final Rect mRootViewRectDips;
    private final Rect mScreenRect;
    private final Rect mScreenRectDips;

    MraidScreenMetrics(Context context, float f3) {
        this.mContext = context.getApplicationContext();
        this.mDensity = f3;
        this.mScreenRect = new Rect();
        this.mScreenRectDips = new Rect();
        this.mRootViewRect = new Rect();
        this.mRootViewRectDips = new Rect();
        this.mCurrentAdRect = new Rect();
        this.mCurrentAdRectDips = new Rect();
        this.mDefaultAdRect = new Rect();
        this.mDefaultAdRectDips = new Rect();
    }

    private void convertToDips(Rect rect, Rect rect2) {
        rect2.set(Dips.pixelsToIntDips((float)rect.left, (Context)this.mContext), Dips.pixelsToIntDips((float)rect.top, (Context)this.mContext), Dips.pixelsToIntDips((float)rect.right, (Context)this.mContext), Dips.pixelsToIntDips((float)rect.bottom, (Context)this.mContext));
    }

    Rect getCurrentAdRect() {
        return this.mCurrentAdRect;
    }

    Rect getCurrentAdRectDips() {
        return this.mCurrentAdRectDips;
    }

    Rect getDefaultAdRect() {
        return this.mDefaultAdRect;
    }

    Rect getDefaultAdRectDips() {
        return this.mDefaultAdRectDips;
    }

    public float getDensity() {
        return this.mDensity;
    }

    Rect getRootViewRect() {
        return this.mRootViewRect;
    }

    Rect getRootViewRectDips() {
        return this.mRootViewRectDips;
    }

    Rect getScreenRect() {
        return this.mScreenRect;
    }

    Rect getScreenRectDips() {
        return this.mScreenRectDips;
    }

    void setCurrentAdPosition(int n2, int n3, int n4, int n5) {
        this.mCurrentAdRect.set(n2, n3, n4 + n2, n5 + n3);
        this.convertToDips(this.mCurrentAdRect, this.mCurrentAdRectDips);
    }

    void setDefaultAdPosition(int n2, int n3, int n4, int n5) {
        this.mDefaultAdRect.set(n2, n3, n4 + n2, n5 + n3);
        this.convertToDips(this.mDefaultAdRect, this.mDefaultAdRectDips);
    }

    void setRootViewPosition(int n2, int n3, int n4, int n5) {
        this.mRootViewRect.set(n2, n3, n4 + n2, n5 + n3);
        this.convertToDips(this.mRootViewRect, this.mRootViewRectDips);
    }

    void setScreenSize(int n2, int n3) {
        this.mScreenRect.set(0, 0, n2, n3);
        this.convertToDips(this.mScreenRect, this.mScreenRectDips);
    }
}

