/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.app.Activity;
import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Environment;
import android.text.TextUtils;
import android.view.View;
import com.mopub.common.MoPubHttpUrlConnection;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.ResponseHeader;
import com.mopub.common.util.Streams;
import com.mopub.mraid.MraidCommandException;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MraidNativeCommandHandler {
    public static final String ANDROID_CALENDAR_CONTENT_TYPE = "vnd.android.cursor.item/event";
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ssZZZZZ", "yyyy-MM-dd'T'HH:mmZZZZZ"};
    private static final int MAX_NUMBER_DAYS_IN_MONTH = 31;

    private String dayNumberToDayOfMonthString(int n2) throws IllegalArgumentException {
        if (n2 != 0 && n2 >= -31 && n2 <= 31) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("");
            stringBuilder.append(n2);
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("invalid day of month ");
        stringBuilder.append(n2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private String dayNumberToDayOfWeekString(int n2) throws IllegalArgumentException {
        String string2;
        switch (n2) {
            default: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("invalid day of week ");
                stringBuilder.append(n2);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            case 6: {
                string2 = "SA";
                break;
            }
            case 5: {
                string2 = "FR";
                break;
            }
            case 4: {
                string2 = "TH";
                break;
            }
            case 3: {
                string2 = "WE";
                break;
            }
            case 2: {
                string2 = "TU";
                break;
            }
            case 1: {
                string2 = "MO";
                break;
            }
            case 0: {
                string2 = "SU";
            }
        }
        return string2;
    }

    static boolean isCalendarAvailable(Context context) {
        return false;
    }

    public static boolean isStorePictureSupported(Context context) {
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Date parseDate(String string2) {
        String[] stringArray = DATE_FORMATS;
        int n2 = stringArray.length;
        Date date = null;
        int n3 = 0;
        while (true) {
            void var6_10;
            Date date2 = date;
            if (n3 >= n2) return var6_10;
            String string3 = stringArray[n3];
            try {
                Date date3;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3, Locale.US);
                date = date3 = simpleDateFormat.parse(string2);
                if (date3 != null) {
                    return var6_10;
                }
            }
            catch (ParseException parseException) {}
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseRecurrenceRule(Map<String, String> object) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        if (!object.containsKey("frequency")) return stringBuilder.toString();
        CharSequence charSequence = (String)object.get("frequency");
        int n2 = object.containsKey("interval") ? Integer.parseInt((String)object.get("interval")) : -1;
        if ("daily".equals(charSequence)) {
            stringBuilder.append("FREQ=DAILY;");
            if (n2 == -1) return stringBuilder.toString();
            object = new StringBuilder();
            ((StringBuilder)object).append("INTERVAL=");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(";");
            stringBuilder.append(((StringBuilder)object).toString());
            return stringBuilder.toString();
        } else if ("weekly".equals(charSequence)) {
            stringBuilder.append("FREQ=WEEKLY;");
            if (n2 != -1) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("INTERVAL=");
                ((StringBuilder)charSequence).append(n2);
                ((StringBuilder)charSequence).append(";");
                stringBuilder.append(((StringBuilder)charSequence).toString());
            }
            if (!object.containsKey("daysInWeek")) return stringBuilder.toString();
            if ((object = this.translateWeekIntegersToDays((String)object.get("daysInWeek"))) == null) throw new IllegalArgumentException("invalid ");
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("BYDAY=");
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append(";");
            stringBuilder.append(((StringBuilder)charSequence).toString());
            return stringBuilder.toString();
        } else {
            if (!"monthly".equals(charSequence)) throw new IllegalArgumentException("frequency is only supported for daily, weekly, and monthly.");
            stringBuilder.append("FREQ=MONTHLY;");
            if (n2 != -1) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("INTERVAL=");
                ((StringBuilder)charSequence).append(n2);
                ((StringBuilder)charSequence).append(";");
                stringBuilder.append(((StringBuilder)charSequence).toString());
            }
            if (!object.containsKey("daysInMonth")) return stringBuilder.toString();
            charSequence = this.translateMonthIntegersToDays((String)object.get("daysInMonth"));
            if (charSequence == null) throw new IllegalArgumentException();
            object = new StringBuilder();
            ((StringBuilder)object).append("BYMONTHDAY=");
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append(";");
            stringBuilder.append(((StringBuilder)object).toString());
        }
        return stringBuilder.toString();
    }

    private Map<String, Object> translateJSParamsToAndroidCalendarEventMapping(Map<String, String> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (map.containsKey("description") && map.containsKey("start")) {
            hashMap.put("title", map.get("description"));
            if (map.containsKey("start") && map.get("start") != null) {
                Date date = this.parseDate(map.get("start"));
                if (date != null) {
                    hashMap.put("beginTime", date.getTime());
                    if (map.containsKey("end") && map.get("end") != null) {
                        date = this.parseDate(map.get("end"));
                        if (date != null) {
                            hashMap.put("endTime", date.getTime());
                        } else {
                            throw new IllegalArgumentException("Invalid calendar event: end time is malformed. Date format expecting (yyyy-MM-DDTHH:MM:SS-xx:xx) or (yyyy-MM-DDTHH:MM-xx:xx) i.e. 2013-08-14T09:00:01-08:00");
                        }
                    }
                    if (map.containsKey("location")) {
                        hashMap.put("eventLocation", map.get("location"));
                    }
                    if (map.containsKey("summary")) {
                        hashMap.put("description", map.get("summary"));
                    }
                    if (map.containsKey("transparency")) {
                        hashMap.put("availability", map.get("transparency").equals("transparent") ? 1 : 0);
                    }
                    hashMap.put("rrule", this.parseRecurrenceRule(map));
                    return hashMap;
                }
                throw new IllegalArgumentException("Invalid calendar event: start time is malformed. Date format expecting (yyyy-MM-DDTHH:MM:SS-xx:xx) or (yyyy-MM-DDTHH:MM-xx:xx) i.e. 2013-08-14T09:00:01-08:00");
            }
            throw new IllegalArgumentException("Invalid calendar event: start is null.");
        }
        throw new IllegalArgumentException("Missing start and description fields");
    }

    private String translateMonthIntegersToDays(String object) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean[] blArray = new boolean[63];
        String[] stringArray = ((String)object).split(",");
        int n2 = stringArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3 = Integer.parseInt(stringArray[i3]);
            int n4 = n3 + 31;
            if (blArray[n4]) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append(this.dayNumberToDayOfMonthString(n3));
            ((StringBuilder)object).append(",");
            stringBuilder.append(((StringBuilder)object).toString());
            blArray[n4] = true;
        }
        if (stringArray.length != 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        object = new IllegalArgumentException("must have at least 1 day of the month if specifying repeating weekly");
        throw object;
    }

    private String translateWeekIntegersToDays(String object) throws IllegalArgumentException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean[] blArray = new boolean[7];
        String[] stringArray = ((String)object).split(",");
        int n2 = stringArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3;
            int n4 = n3 = Integer.parseInt(stringArray[i3]);
            if (n3 == 7) {
                n4 = 0;
            }
            if (blArray[n4]) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append(this.dayNumberToDayOfWeekString(n4));
            ((StringBuilder)object).append(",");
            stringBuilder.append(((StringBuilder)object).toString());
            blArray[n4] = true;
        }
        if (stringArray.length != 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
        object = new IllegalArgumentException("must have at least 1 day of the week if specifying repeating weekly");
        throw object;
    }

    boolean isInlineVideoAvailable(Activity activity, View view) {
        view = activity.getWindow();
        boolean bl = false;
        if (view == null) {
            return false;
        }
        if ((activity.getWindow().getAttributes().flags & 0x1000000) != 0) {
            bl = true;
        }
        return bl;
    }

    boolean isSmsAvailable(Context context) {
        return false;
    }

    boolean isTelAvailable(Context context) {
        return false;
    }

    @VisibleForTesting
    static class DownloadImageAsyncTask
    extends AsyncTask<String, Void, Boolean> {
        private final Context mContext;
        private final DownloadImageAsyncTaskListener mListener;

        public DownloadImageAsyncTask(Context context, DownloadImageAsyncTaskListener downloadImageAsyncTaskListener) {
            this.mContext = context.getApplicationContext();
            this.mListener = downloadImageAsyncTaskListener;
        }

        private String getFileNameForUriAndHeaders(URI object, Map<String, List<String>> object2) {
            Preconditions.checkNotNull((Object)object);
            object = ((URI)object).getPath();
            if (object != null && object2 != null) {
                String string2 = new File((String)object).getName();
                object2 = object2.get(ResponseHeader.CONTENT_TYPE.getKey());
                object = string2;
                if (object2 != null) {
                    object = string2;
                    if (!object2.isEmpty()) {
                        int n2 = 0;
                        if (object2.get(0) == null) {
                            object = string2;
                        } else {
                            object2 = ((String)object2.get(0)).split(";");
                            int n3 = ((String[])object2).length;
                            while (true) {
                                object = string2;
                                if (n2 >= n3) break;
                                object = object2[n2];
                                if (((String)object).contains("image/")) {
                                    object2 = new StringBuilder();
                                    ((StringBuilder)object2).append(".");
                                    ((StringBuilder)object2).append(((String)object).split("/")[1]);
                                    object2 = ((StringBuilder)object2).toString();
                                    object = string2;
                                    if (string2.endsWith((String)object2)) break;
                                    object = new StringBuilder();
                                    ((StringBuilder)object).append(string2);
                                    ((StringBuilder)object).append((String)object2);
                                    object = ((StringBuilder)object).toString();
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                }
                return object;
            }
            return null;
        }

        private File getPictureStoragePath() {
            return new File(Environment.getExternalStorageDirectory(), "Pictures");
        }

        private void loadPictureIntoGalleryApp(String object) {
            object = new MoPubMediaScannerConnectionClient((String)object, null);
            MediaScannerConnection mediaScannerConnection = new MediaScannerConnection(this.mContext, (MediaScannerConnection.MediaScannerConnectionClient)object);
            ((MoPubMediaScannerConnectionClient)object).setMediaScannerConnection(mediaScannerConnection);
            mediaScannerConnection.connect();
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Boolean doInBackground(String[] object) {
            void var5_19;
            Boolean bl;
            block12: {
                void var5_20;
                Object object2;
                block11: {
                    void var5_10;
                    bl = false;
                    if (object == null) return bl;
                    if (((Object)object).length == 0) return bl;
                    if (object[0] == null) {
                        return bl;
                    }
                    File file = this.getPictureStoragePath();
                    file.mkdirs();
                    object = object[0];
                    URI uRI = URI.create((String)object);
                    Object var5_7 = null;
                    object2 = null;
                    HttpURLConnection httpURLConnection = MoPubHttpUrlConnection.getHttpUrlConnection((String)object);
                    object = new BufferedInputStream(httpURLConnection.getInputStream());
                    object2 = httpURLConnection.getHeaderField(ResponseHeader.LOCATION.getKey());
                    URI uRI2 = uRI;
                    if (!TextUtils.isEmpty((CharSequence)object2)) {
                        URI uRI3 = URI.create((String)object2);
                    }
                    String string2 = this.getFileNameForUriAndHeaders((URI)var5_10, httpURLConnection.getHeaderFields());
                    object2 = new File(file, string2);
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
                    try {
                        Streams.copyContent((InputStream)object, (OutputStream)fileOutputStream);
                        this.loadPictureIntoGalleryApp(((File)object2).toString());
                    }
                    catch (Throwable throwable) {
                        object2 = object;
                        object = fileOutputStream;
                        Object object3 = object2;
                        object2 = throwable;
                        break block11;
                    }
                    Streams.closeStream((Closeable)object);
                    Streams.closeStream((Closeable)fileOutputStream);
                    return true;
                    catch (Throwable throwable) {
                        uRI = null;
                        Object object4 = object;
                        object = uRI;
                        break block11;
                    }
                    catch (Exception exception) {
                        Object var5_16 = null;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        object = null;
                    }
                    catch (Exception exception) {
                        Object var5_18 = null;
                        object = object2;
                        break block12;
                    }
                }
                Streams.closeStream((Closeable)var5_20);
                Streams.closeStream((Closeable)object);
                throw object2;
                catch (Exception exception) {}
            }
            Streams.closeStream((Closeable)object);
            Streams.closeStream((Closeable)var5_19);
            return bl;
        }

        @Deprecated
        @VisibleForTesting
        DownloadImageAsyncTaskListener getListener() {
            return this.mListener;
        }

        protected void onPostExecute(Boolean bl) {
            if (bl != null && bl.booleanValue()) {
                this.mListener.onSuccess();
            } else {
                this.mListener.onFailure();
            }
        }

        static interface DownloadImageAsyncTaskListener {
            public void onFailure();

            public void onSuccess();
        }
    }

    private static class MoPubMediaScannerConnectionClient
    implements MediaScannerConnection.MediaScannerConnectionClient {
        private final String mFilename;
        private MediaScannerConnection mMediaScannerConnection;
        private final String mMimeType;

        private MoPubMediaScannerConnectionClient(String string2, String string3) {
            this.mFilename = string2;
            this.mMimeType = string3;
        }

        private void setMediaScannerConnection(MediaScannerConnection mediaScannerConnection) {
            this.mMediaScannerConnection = mediaScannerConnection;
        }

        public void onMediaScannerConnected() {
            MediaScannerConnection mediaScannerConnection = this.mMediaScannerConnection;
            if (mediaScannerConnection != null) {
                mediaScannerConnection.scanFile(this.mFilename, this.mMimeType);
            }
        }

        public void onScanCompleted(String string2, Uri uri) {
            string2 = this.mMediaScannerConnection;
            if (string2 != null) {
                string2.disconnect();
            }
        }
    }

    static interface MraidCommandFailureListener {
        public void onFailure(MraidCommandException var1);
    }
}

