/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.JsResult;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.mopub.common.AdReport;
import com.mopub.common.CloseableLayout;
import com.mopub.common.ExternalViewabilitySessionManager;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.DeviceUtils;
import com.mopub.common.util.Dips;
import com.mopub.common.util.ManifestUtils;
import com.mopub.common.util.Utils;
import com.mopub.common.util.Views;
import com.mopub.mobileads.BaseVideoPlayerActivity;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.util.WebViews;
import com.mopub.mraid.MraidBridge;
import com.mopub.mraid.MraidCommandException;
import com.mopub.mraid.MraidNativeCommandHandler;
import com.mopub.mraid.MraidOrientation;
import com.mopub.mraid.MraidScreenMetrics;
import com.mopub.mraid.MraidWebViewDebugListener;
import com.mopub.mraid.PlacementType;
import com.mopub.mraid.ViewState;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.AbstractCollection;
import java.util.EnumSet;

public class MraidController {
    private final AdReport mAdReport;
    private boolean mAllowOrientationChange = true;
    private final CloseableLayout mCloseableAdContainer;
    private final Context mContext;
    private MraidWebViewDebugListener mDebugListener;
    private UrlHandler.MoPubSchemeListener mDebugSchemeListener;
    private final FrameLayout mDefaultAdContainer;
    private MraidOrientation mForceOrientation;
    private boolean mIsPaused = true;
    private final MraidBridge mMraidBridge;
    private final MraidBridge.MraidBridgeListener mMraidBridgeListener;
    private MraidListener mMraidListener;
    private final MraidNativeCommandHandler mMraidNativeCommandHandler;
    private MraidBridge.MraidWebView mMraidWebView;
    private UseCustomCloseListener mOnCloseButtonListener;
    private OrientationBroadcastReceiver mOrientationBroadcastReceiver;
    private Integer mOriginalActivityOrientation;
    private final PlacementType mPlacementType;
    private ViewGroup mRootView;
    private final MraidScreenMetrics mScreenMetrics;
    private final ScreenMetricsWaiter mScreenMetricsWaiter;
    private final MraidBridge mTwoPartBridge;
    private final MraidBridge.MraidBridgeListener mTwoPartBridgeListener;
    private MraidBridge.MraidWebView mTwoPartWebView;
    private ViewState mViewState = ViewState.LOADING;
    private WeakReference<Activity> mWeakActivity;

    public MraidController(Context context, AdReport adReport, PlacementType placementType) {
        this(context, adReport, placementType, new MraidBridge(adReport, placementType), new MraidBridge(adReport, PlacementType.INTERSTITIAL), new ScreenMetricsWaiter());
    }

    @VisibleForTesting
    MraidController(Context context, AdReport adReport, PlacementType placementType, MraidBridge mraidBridge, MraidBridge mraidBridge2, ScreenMetricsWaiter screenMetricsWaiter) {
        Context context2;
        this.mOrientationBroadcastReceiver = new OrientationBroadcastReceiver();
        this.mDebugSchemeListener = new UrlHandler.MoPubSchemeListener(){

            public void onClose() {
            }

            public void onCrash() {
                if (MraidController.this.mMraidWebView != null) {
                    MraidController.this.mMraidWebView.loadUrl("chrome://crash");
                }
            }

            public void onFailLoad() {
            }

            public void onFinishLoad() {
            }
        };
        this.mForceOrientation = MraidOrientation.NONE;
        this.mMraidBridgeListener = new MraidBridge.MraidBridgeListener(){

            @Override
            public void onClose() {
                MraidController.this.handleClose();
            }

            @Override
            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                return MraidController.this.handleConsoleMessage(consoleMessage);
            }

            @Override
            public void onExpand(URI uRI, boolean bl) throws MraidCommandException {
                MraidController.this.handleExpand(uRI, bl);
            }

            @Override
            public boolean onJsAlert(String string2, JsResult jsResult) {
                return MraidController.this.handleJsAlert(string2, jsResult);
            }

            @Override
            public void onOpen(URI uRI) {
                MraidController.this.handleOpen(uRI.toString());
            }

            @Override
            public void onPageFailedToLoad() {
                if (MraidController.this.mMraidListener != null) {
                    MraidController.this.mMraidListener.onFailedToLoad();
                }
            }

            @Override
            public void onPageLoaded() {
                MraidController.this.handlePageLoad();
                if (MraidController.this.mMraidListener != null) {
                    MraidController.this.mMraidListener.onLoaded((View)MraidController.this.mDefaultAdContainer);
                }
            }

            @Override
            public void onPlayVideo(URI uRI) {
                MraidController.this.handleShowVideo(uRI.toString());
            }

            @Override
            public void onRenderProcessGone(MoPubErrorCode moPubErrorCode) {
                MraidController.this.handleRenderProcessGone(moPubErrorCode);
            }

            @Override
            public void onResize(int n2, int n3, int n4, int n5, CloseableLayout.ClosePosition closePosition, boolean bl) throws MraidCommandException {
                MraidController.this.handleResize(n2, n3, n4, n5, closePosition, bl);
            }

            @Override
            public void onSetOrientationProperties(boolean bl, MraidOrientation mraidOrientation) throws MraidCommandException {
                MraidController.this.handleSetOrientationProperties(bl, mraidOrientation);
            }

            @Override
            public void onUseCustomClose(boolean bl) {
                MraidController.this.handleCustomClose(bl);
            }

            @Override
            public void onVisibilityChanged(boolean bl) {
                if (!MraidController.this.mTwoPartBridge.isAttached()) {
                    MraidController.this.mMraidBridge.notifyViewability(bl);
                }
            }
        };
        this.mTwoPartBridgeListener = new MraidBridge.MraidBridgeListener(){

            @Override
            public void onClose() {
                MraidController.this.handleClose();
            }

            @Override
            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                return MraidController.this.handleConsoleMessage(consoleMessage);
            }

            @Override
            public void onExpand(URI uRI, boolean bl) {
            }

            @Override
            public boolean onJsAlert(String string2, JsResult jsResult) {
                return MraidController.this.handleJsAlert(string2, jsResult);
            }

            @Override
            public void onOpen(URI uRI) {
                MraidController.this.handleOpen(uRI.toString());
            }

            @Override
            public void onPageFailedToLoad() {
            }

            @Override
            public void onPageLoaded() {
                MraidController.this.handleTwoPartPageLoad();
            }

            @Override
            public void onPlayVideo(URI uRI) {
                MraidController.this.handleShowVideo(uRI.toString());
            }

            @Override
            public void onRenderProcessGone(MoPubErrorCode moPubErrorCode) {
                MraidController.this.handleRenderProcessGone(moPubErrorCode);
            }

            @Override
            public void onResize(int n2, int n3, int n4, int n5, CloseableLayout.ClosePosition closePosition, boolean bl) throws MraidCommandException {
                throw new MraidCommandException("Not allowed to resize from an expanded state");
            }

            @Override
            public void onSetOrientationProperties(boolean bl, MraidOrientation mraidOrientation) throws MraidCommandException {
                MraidController.this.handleSetOrientationProperties(bl, mraidOrientation);
            }

            @Override
            public void onUseCustomClose(boolean bl) {
                MraidController.this.handleCustomClose(bl);
            }

            @Override
            public void onVisibilityChanged(boolean bl) {
                MraidController.this.mMraidBridge.notifyViewability(bl);
                MraidController.this.mTwoPartBridge.notifyViewability(bl);
            }
        };
        this.mContext = context2 = context.getApplicationContext();
        Preconditions.checkNotNull((Object)context2);
        this.mAdReport = adReport;
        this.mWeakActivity = context instanceof Activity ? new WeakReference<Activity>((Activity)context) : new WeakReference<Object>(null);
        this.mPlacementType = placementType;
        this.mMraidBridge = mraidBridge;
        this.mTwoPartBridge = mraidBridge2;
        this.mScreenMetricsWaiter = screenMetricsWaiter;
        this.mViewState = ViewState.LOADING;
        context = this.mContext.getResources().getDisplayMetrics();
        this.mScreenMetrics = new MraidScreenMetrics(this.mContext, context.density);
        this.mDefaultAdContainer = new FrameLayout(this.mContext);
        context = new CloseableLayout(this.mContext);
        this.mCloseableAdContainer = context;
        context.setOnCloseListener(new CloseableLayout.OnCloseListener(){

            public void onClose() {
                MraidController.this.handleClose();
            }
        });
        context = new View(this.mContext);
        context.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        this.mCloseableAdContainer.addView((View)context, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mOrientationBroadcastReceiver.register(this.mContext);
        this.mMraidBridge.setMraidBridgeListener(this.mMraidBridgeListener);
        this.mTwoPartBridge.setMraidBridgeListener(this.mTwoPartBridgeListener);
        this.mMraidNativeCommandHandler = new MraidNativeCommandHandler();
    }

    @VisibleForTesting
    static void callMraidListenerCallbacks(MraidListener mraidListener, ViewState viewState, ViewState viewState2) {
        Preconditions.checkNotNull((Object)mraidListener);
        Preconditions.checkNotNull((Object)((Object)viewState));
        Preconditions.checkNotNull((Object)((Object)viewState2));
        ViewState viewState3 = ViewState.EXPANDED;
        if (viewState2 == viewState3) {
            mraidListener.onExpand();
        } else if (viewState == viewState3 && viewState2 == ViewState.DEFAULT) {
            mraidListener.onClose();
        } else if (viewState2 == ViewState.HIDDEN) {
            mraidListener.onClose();
        } else if (viewState == ViewState.RESIZED && viewState2 == ViewState.DEFAULT) {
            mraidListener.onResize(true);
        } else if (viewState2 == ViewState.RESIZED) {
            mraidListener.onResize(false);
        }
    }

    private void detachMraidWebView() {
        this.mMraidBridge.detach();
        this.mMraidWebView = null;
    }

    private void detachTwoPartWebView() {
        this.mTwoPartBridge.detach();
        this.mTwoPartWebView = null;
    }

    private ViewGroup getAndMemoizeRootView() {
        if (this.mRootView == null) {
            this.mRootView = this.getRootView();
        }
        return this.mRootView;
    }

    private int getDisplayRotation() {
        return ((WindowManager)this.mContext.getSystemService("window")).getDefaultDisplay().getRotation();
    }

    private ViewGroup getRootView() {
        ViewGroup viewGroup = this.mRootView;
        if (viewGroup != null) {
            return viewGroup;
        }
        viewGroup = Views.getTopmostView((Context)((Context)this.mWeakActivity.get()), (View)this.mDefaultAdContainer);
        if (!(viewGroup instanceof ViewGroup)) {
            viewGroup = this.mDefaultAdContainer;
        }
        return viewGroup;
    }

    private boolean isUsingCustomClose() {
        return this.mCloseableAdContainer.isCloseVisible() ^ true;
    }

    private void setViewState(ViewState viewState) {
        Object object = MoPubLog.SdkLogEvent.CUSTOM;
        Object object2 = new StringBuilder();
        object2.append("MRAID state set to ");
        object2.append((Object)viewState);
        MoPubLog.log((MoPubLog.MPLogEventType)object, (Object[])new Object[]{object2.toString()});
        object2 = this.mViewState;
        this.mViewState = viewState;
        this.mMraidBridge.notifyViewState(viewState);
        if (this.mTwoPartBridge.isLoaded()) {
            this.mTwoPartBridge.notifyViewState(viewState);
        }
        if ((object = this.mMraidListener) != null) {
            MraidController.callMraidListenerCallbacks((MraidListener)object, (ViewState)((Object)object2), viewState);
        }
        this.updateScreenMetricsAsync(null);
    }

    private void updateScreenMetricsAsync(Runnable runnable) {
        this.mScreenMetricsWaiter.cancelLastRequest();
        MraidBridge.MraidWebView mraidWebView = this.getCurrentWebView();
        if (mraidWebView == null) {
            return;
        }
        this.mScreenMetricsWaiter.waitFor(new View[]{this.mDefaultAdContainer, mraidWebView}).start(new Runnable((View)mraidWebView, runnable){
            final /* synthetic */ View val$currentWebView;
            final /* synthetic */ Runnable val$successRunnable;
            {
                this.val$currentWebView = view;
                this.val$successRunnable = runnable;
            }

            @Override
            public void run() {
                Object object = MraidController.this.mContext.getResources().getDisplayMetrics();
                MraidController.this.mScreenMetrics.setScreenSize(((DisplayMetrics)object).widthPixels, ((DisplayMetrics)object).heightPixels);
                object = new int[2];
                ViewGroup viewGroup = MraidController.this.getRootView();
                viewGroup.getLocationOnScreen((int[])object);
                MraidController.this.mScreenMetrics.setRootViewPosition((int)object[0], (int)object[1], viewGroup.getWidth(), viewGroup.getHeight());
                MraidController.this.mDefaultAdContainer.getLocationOnScreen((int[])object);
                MraidController.this.mScreenMetrics.setDefaultAdPosition((int)object[0], (int)object[1], MraidController.this.mDefaultAdContainer.getWidth(), MraidController.this.mDefaultAdContainer.getHeight());
                this.val$currentWebView.getLocationOnScreen((int[])object);
                MraidController.this.mScreenMetrics.setCurrentAdPosition((int)object[0], (int)object[1], this.val$currentWebView.getWidth(), this.val$currentWebView.getHeight());
                MraidController.this.mMraidBridge.notifyScreenMetrics(MraidController.this.mScreenMetrics);
                if (MraidController.this.mTwoPartBridge.isAttached()) {
                    MraidController.this.mTwoPartBridge.notifyScreenMetrics(MraidController.this.mScreenMetrics);
                }
                if ((object = this.val$successRunnable) != null) {
                    object.run();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    void applyOrientation() throws MraidCommandException {
        MraidOrientation mraidOrientation = this.mForceOrientation;
        if (mraidOrientation == MraidOrientation.NONE) {
            if (this.mAllowOrientationChange) {
                this.unApplyOrientation();
                return;
            } else {
                mraidOrientation = (Activity)this.mWeakActivity.get();
                if (mraidOrientation == null) throw new MraidCommandException("Unable to set MRAID expand orientation to 'none'; expected passed in Activity Context.");
                this.lockOrientation(DeviceUtils.getScreenOrientation((Activity)mraidOrientation));
            }
            return;
        } else {
            this.lockOrientation(mraidOrientation.getActivityInfoOrientation());
        }
    }

    int clampInt(int n2, int n3, int n4) {
        return Math.max(n2, Math.min(n3, n4));
    }

    public void destroy() {
        IllegalArgumentException illegalArgumentException2;
        block3: {
            this.mScreenMetricsWaiter.cancelLastRequest();
            try {
                this.mOrientationBroadcastReceiver.unregister();
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                if (!illegalArgumentException2.getMessage().contains("Receiver not registered")) break block3;
            }
            if (!this.mIsPaused) {
                this.pause(true);
            }
            Views.removeFromParent((View)this.mCloseableAdContainer);
            this.detachMraidWebView();
            this.detachTwoPartWebView();
            this.unApplyOrientation();
            return;
        }
        throw illegalArgumentException2;
    }

    public void fillContent(String string2, MraidWebViewCacheListener mraidWebViewCacheListener) {
        MraidBridge.MraidWebView mraidWebView;
        Preconditions.checkNotNull((Object)string2, (String)"htmlData cannot be null");
        this.mMraidWebView = mraidWebView = new MraidBridge.MraidWebView(this.mContext);
        if (mraidWebViewCacheListener != null) {
            mraidWebViewCacheListener.onReady(mraidWebView, null);
        }
        this.mMraidBridge.attachView(this.mMraidWebView);
        this.mDefaultAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mMraidBridge.setContentHtml(string2);
    }

    public FrameLayout getAdContainer() {
        return this.mDefaultAdContainer;
    }

    @Deprecated
    @VisibleForTesting
    boolean getAllowOrientationChange() {
        return this.mAllowOrientationChange;
    }

    public Context getContext() {
        return this.mContext;
    }

    public MraidBridge.MraidWebView getCurrentWebView() {
        MraidBridge.MraidWebView mraidWebView = this.mTwoPartBridge.isAttached() ? this.mTwoPartWebView : this.mMraidWebView;
        return mraidWebView;
    }

    @Deprecated
    @VisibleForTesting
    CloseableLayout getExpandedAdContainer() {
        return this.mCloseableAdContainer;
    }

    @Deprecated
    @VisibleForTesting
    MraidOrientation getForceOrientation() {
        return this.mForceOrientation;
    }

    @Deprecated
    @VisibleForTesting
    MraidBridge.MraidWebView getMraidWebView() {
        return this.mMraidWebView;
    }

    @Deprecated
    @VisibleForTesting
    Integer getOriginalActivityOrientation() {
        return this.mOriginalActivityOrientation;
    }

    @Deprecated
    @VisibleForTesting
    MraidBridge.MraidWebView getTwoPartWebView() {
        return this.mTwoPartWebView;
    }

    @Deprecated
    @VisibleForTesting
    ViewState getViewState() {
        return this.mViewState;
    }

    WeakReference<Activity> getWeakActivity() {
        return this.mWeakActivity;
    }

    @VisibleForTesting
    protected void handleClose() {
        if (this.mMraidWebView == null) {
            return;
        }
        Object object = this.mViewState;
        if (object != ViewState.LOADING && object != ViewState.HIDDEN) {
            if (object == ViewState.EXPANDED || this.mPlacementType == PlacementType.INTERSTITIAL) {
                this.unApplyOrientation();
            }
            if ((object = this.mViewState) != ViewState.RESIZED && object != ViewState.EXPANDED) {
                if (object == ViewState.DEFAULT) {
                    this.mDefaultAdContainer.setVisibility(4);
                    this.setViewState(ViewState.HIDDEN);
                }
            } else {
                if (this.mTwoPartBridge.isAttached() && (object = this.mTwoPartWebView) != null) {
                    this.detachTwoPartWebView();
                    this.mCloseableAdContainer.removeView((View)object);
                } else {
                    this.mCloseableAdContainer.removeView((View)this.mMraidWebView);
                    this.mDefaultAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                    this.mDefaultAdContainer.setVisibility(0);
                }
                Views.removeFromParent((View)this.mCloseableAdContainer);
                this.setViewState(ViewState.DEFAULT);
            }
        }
    }

    @VisibleForTesting
    boolean handleConsoleMessage(ConsoleMessage consoleMessage) {
        MraidWebViewDebugListener mraidWebViewDebugListener = this.mDebugListener;
        if (mraidWebViewDebugListener != null) {
            return mraidWebViewDebugListener.onConsoleMessage(consoleMessage);
        }
        return true;
    }

    @VisibleForTesting
    protected void handleCustomClose(boolean bl) {
        if (bl == this.isUsingCustomClose()) {
            return;
        }
        this.mCloseableAdContainer.setCloseVisible(bl ^ true);
        UseCustomCloseListener useCustomCloseListener = this.mOnCloseButtonListener;
        if (useCustomCloseListener != null) {
            useCustomCloseListener.useCustomCloseChanged(bl);
        }
    }

    void handleExpand(URI uRI, boolean bl) throws MraidCommandException {
        if (this.mMraidWebView != null) {
            if (this.mPlacementType == PlacementType.INTERSTITIAL) {
                return;
            }
            Object object = this.mViewState;
            if (object != ViewState.DEFAULT && object != ViewState.RESIZED) {
                return;
            }
            this.applyOrientation();
            boolean bl2 = uRI != null;
            if (bl2) {
                object = new MraidBridge.MraidWebView(this.mContext);
                this.mTwoPartWebView = object;
                this.mTwoPartBridge.attachView((MraidBridge.MraidWebView)((Object)object));
                this.mTwoPartBridge.setContentUrl(uRI.toString());
            }
            uRI = new FrameLayout.LayoutParams(-1, -1);
            object = this.mViewState;
            if (object == ViewState.DEFAULT) {
                if (bl2) {
                    this.mCloseableAdContainer.addView((View)this.mTwoPartWebView, (ViewGroup.LayoutParams)uRI);
                } else {
                    this.mDefaultAdContainer.removeView((View)this.mMraidWebView);
                    this.mDefaultAdContainer.setVisibility(4);
                    this.mCloseableAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)uRI);
                }
                this.getAndMemoizeRootView().addView((View)this.mCloseableAdContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            } else if (object == ViewState.RESIZED && bl2) {
                this.mCloseableAdContainer.removeView((View)this.mMraidWebView);
                this.mDefaultAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)uRI);
                this.mDefaultAdContainer.setVisibility(4);
                this.mCloseableAdContainer.addView((View)this.mTwoPartWebView, (ViewGroup.LayoutParams)uRI);
            }
            this.mCloseableAdContainer.setLayoutParams((ViewGroup.LayoutParams)uRI);
            this.handleCustomClose(bl);
            this.setViewState(ViewState.EXPANDED);
            return;
        }
        throw new MraidCommandException("Unable to expand after the WebView is destroyed");
    }

    @VisibleForTesting
    boolean handleJsAlert(String string2, JsResult jsResult) {
        MraidWebViewDebugListener mraidWebViewDebugListener = this.mDebugListener;
        if (mraidWebViewDebugListener != null) {
            return mraidWebViewDebugListener.onJsAlert(string2, jsResult);
        }
        jsResult.confirm();
        return true;
    }

    @VisibleForTesting
    void handleOpen(String string2) {
        MraidListener mraidListener = this.mMraidListener;
        if (mraidListener != null) {
            mraidListener.onOpen();
        }
        if (UrlAction.HANDLE_PHONE_SCHEME.shouldTryHandlingUrl((Uri)(mraidListener = Uri.parse((String)string2)))) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM_WITH_THROWABLE, (Object[])new Object[]{String.format("Uri scheme %s is not allowed.", mraidListener.getScheme()), new MraidCommandException("Unsupported MRAID Javascript command")});
            return;
        }
        mraidListener = new UrlHandler.Builder();
        Object object = this.mAdReport;
        if (object != null) {
            mraidListener.withDspCreativeId(object.getDspCreativeId());
        }
        object = EnumSet.of(UrlAction.IGNORE_ABOUT_SCHEME, new UrlAction[]{UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK});
        if (ManifestUtils.isDebuggable((Context)this.mContext)) {
            ((AbstractCollection)object).add(UrlAction.HANDLE_MOPUB_SCHEME);
            mraidListener.withMoPubSchemeListener(this.mDebugSchemeListener);
        }
        mraidListener.withSupportedUrlActions((EnumSet)object).build().handleUrl(this.mContext, string2);
    }

    void handleOrientationChange(int n2) {
        this.updateScreenMetricsAsync(null);
    }

    @VisibleForTesting
    void handlePageLoad() {
        this.mMraidBridge.notifySupports(this.mMraidNativeCommandHandler.isSmsAvailable(this.mContext), this.mMraidNativeCommandHandler.isTelAvailable(this.mContext), MraidNativeCommandHandler.isCalendarAvailable(this.mContext), MraidNativeCommandHandler.isStorePictureSupported(this.mContext), this.isInlineVideoAvailable());
        this.mMraidBridge.notifyPlacementType(this.mPlacementType);
        MraidBridge mraidBridge = this.mMraidBridge;
        mraidBridge.notifyViewability(mraidBridge.isViewable());
        this.mMraidBridge.notifyScreenMetrics(this.mScreenMetrics);
        this.setViewState(ViewState.DEFAULT);
        this.mMraidBridge.notifyReady();
    }

    @VisibleForTesting
    void handleRenderProcessGone(MoPubErrorCode moPubErrorCode) {
        MraidListener mraidListener = this.mMraidListener;
        if (mraidListener != null) {
            mraidListener.onRenderProcessGone(moPubErrorCode);
        }
    }

    @VisibleForTesting
    void handleResize(int n2, int n3, int n4, int n5, CloseableLayout.ClosePosition object, boolean bl) throws MraidCommandException {
        if (this.mMraidWebView != null) {
            ViewState viewState = this.mViewState;
            if (viewState != ViewState.LOADING && viewState != ViewState.HIDDEN) {
                if (viewState != ViewState.EXPANDED) {
                    if (this.mPlacementType != PlacementType.INTERSTITIAL) {
                        Rect rect;
                        int n6 = Dips.dipsToIntPixels((float)n2, (Context)this.mContext);
                        int n7 = Dips.dipsToIntPixels((float)n3, (Context)this.mContext);
                        int n8 = Dips.dipsToIntPixels((float)n4, (Context)this.mContext);
                        int n9 = Dips.dipsToIntPixels((float)n5, (Context)this.mContext);
                        n8 = this.mScreenMetrics.getDefaultAdRect().left + n8;
                        n9 = this.mScreenMetrics.getDefaultAdRect().top + n9;
                        viewState = new Rect(n8, n9, n6 + n8, n9 + n7);
                        if (!bl) {
                            rect = this.mScreenMetrics.getRootViewRect();
                            if (viewState.width() <= rect.width() && viewState.height() <= rect.height()) {
                                viewState.offsetTo(this.clampInt(rect.left, ((Rect)viewState).left, rect.right - viewState.width()), this.clampInt(rect.top, ((Rect)viewState).top, rect.bottom - viewState.height()));
                            } else {
                                object = new StringBuilder();
                                ((StringBuilder)object).append("resizeProperties specified a size (");
                                ((StringBuilder)object).append(n2);
                                ((StringBuilder)object).append(", ");
                                ((StringBuilder)object).append(n3);
                                ((StringBuilder)object).append(") and offset (");
                                ((StringBuilder)object).append(n4);
                                ((StringBuilder)object).append(", ");
                                ((StringBuilder)object).append(n5);
                                ((StringBuilder)object).append(") that doesn't allow the ad to appear within the max allowed size (");
                                ((StringBuilder)object).append(this.mScreenMetrics.getRootViewRectDips().width());
                                ((StringBuilder)object).append(", ");
                                ((StringBuilder)object).append(this.mScreenMetrics.getRootViewRectDips().height());
                                ((StringBuilder)object).append(")");
                                throw new MraidCommandException(((StringBuilder)object).toString());
                            }
                        }
                        rect = new Rect();
                        this.mCloseableAdContainer.applyCloseRegionBounds((CloseableLayout.ClosePosition)object, (Rect)viewState, rect);
                        if (this.mScreenMetrics.getRootViewRect().contains(rect)) {
                            if (viewState.contains(rect)) {
                                this.mCloseableAdContainer.setClosePosition((CloseableLayout.ClosePosition)object);
                                rect = new FrameLayout.LayoutParams(viewState.width(), viewState.height());
                                rect.leftMargin = ((Rect)viewState).left - this.mScreenMetrics.getRootViewRect().left;
                                rect.topMargin = ((Rect)viewState).top - this.mScreenMetrics.getRootViewRect().top;
                                viewState = this.mViewState;
                                if (viewState == ViewState.DEFAULT) {
                                    this.mDefaultAdContainer.removeView((View)this.mMraidWebView);
                                    this.mDefaultAdContainer.setVisibility(4);
                                    this.mCloseableAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                                    this.getAndMemoizeRootView().addView((View)this.mCloseableAdContainer, (ViewGroup.LayoutParams)rect);
                                } else if (viewState == ViewState.RESIZED) {
                                    this.mCloseableAdContainer.setLayoutParams((ViewGroup.LayoutParams)rect);
                                }
                                this.mCloseableAdContainer.setClosePosition((CloseableLayout.ClosePosition)object);
                                this.setViewState(ViewState.RESIZED);
                                return;
                            }
                            object = new StringBuilder();
                            ((StringBuilder)object).append("resizeProperties specified a size (");
                            ((StringBuilder)object).append(n2);
                            ((StringBuilder)object).append(", ");
                            ((StringBuilder)object).append(n7);
                            ((StringBuilder)object).append(") and offset (");
                            ((StringBuilder)object).append(n4);
                            ((StringBuilder)object).append(", ");
                            ((StringBuilder)object).append(n5);
                            ((StringBuilder)object).append(") that don't allow the close region to appear within the resized ad.");
                            throw new MraidCommandException(((StringBuilder)object).toString());
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("resizeProperties specified a size (");
                        ((StringBuilder)object).append(n2);
                        ((StringBuilder)object).append(", ");
                        ((StringBuilder)object).append(n3);
                        ((StringBuilder)object).append(") and offset (");
                        ((StringBuilder)object).append(n4);
                        ((StringBuilder)object).append(", ");
                        ((StringBuilder)object).append(n5);
                        ((StringBuilder)object).append(") that doesn't allow the close region to appear within the max allowed size (");
                        ((StringBuilder)object).append(this.mScreenMetrics.getRootViewRectDips().width());
                        ((StringBuilder)object).append(", ");
                        ((StringBuilder)object).append(this.mScreenMetrics.getRootViewRectDips().height());
                        ((StringBuilder)object).append(")");
                        throw new MraidCommandException(((StringBuilder)object).toString());
                    }
                    throw new MraidCommandException("Not allowed to resize from an interstitial ad");
                }
                throw new MraidCommandException("Not allowed to resize from an already expanded ad");
            }
            return;
        }
        throw new MraidCommandException("Unable to resize after the WebView is destroyed");
    }

    @VisibleForTesting
    void handleSetOrientationProperties(boolean bl, MraidOrientation mraidOrientation) throws MraidCommandException {
        if (this.shouldAllowForceOrientation(mraidOrientation)) {
            this.mAllowOrientationChange = bl;
            this.mForceOrientation = mraidOrientation;
            if (this.mViewState == ViewState.EXPANDED || this.mPlacementType == PlacementType.INTERSTITIAL && !this.mIsPaused) {
                this.applyOrientation();
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Unable to force orientation to ");
        stringBuilder.append((Object)mraidOrientation);
        throw new MraidCommandException(stringBuilder.toString());
    }

    @VisibleForTesting
    void handleShowVideo(String string2) {
        BaseVideoPlayerActivity.startMraid((Context)this.mContext, (String)string2);
    }

    @VisibleForTesting
    void handleTwoPartPageLoad() {
        this.updateScreenMetricsAsync(new Runnable(){

            @Override
            public void run() {
                MraidBridge mraidBridge = MraidController.this.mTwoPartBridge;
                boolean bl = MraidController.this.mMraidNativeCommandHandler.isSmsAvailable(MraidController.this.mContext);
                boolean bl2 = MraidController.this.mMraidNativeCommandHandler.isTelAvailable(MraidController.this.mContext);
                MraidController.this.mMraidNativeCommandHandler;
                boolean bl3 = MraidNativeCommandHandler.isCalendarAvailable(MraidController.this.mContext);
                MraidController.this.mMraidNativeCommandHandler;
                mraidBridge.notifySupports(bl, bl2, bl3, MraidNativeCommandHandler.isStorePictureSupported(MraidController.this.mContext), MraidController.this.isInlineVideoAvailable());
                MraidController.this.mTwoPartBridge.notifyViewState(MraidController.this.mViewState);
                MraidController.this.mTwoPartBridge.notifyPlacementType(MraidController.this.mPlacementType);
                MraidController.this.mTwoPartBridge.notifyViewability(MraidController.this.mTwoPartBridge.isViewable());
                MraidController.this.mTwoPartBridge.notifyReady();
            }
        });
    }

    @VisibleForTesting
    boolean isInlineVideoAvailable() {
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity != null && this.getCurrentWebView() != null) {
            if (this.mPlacementType != PlacementType.INLINE) {
                return true;
            }
            return this.mMraidNativeCommandHandler.isInlineVideoAvailable(activity, (View)this.getCurrentWebView());
        }
        return false;
    }

    public void loadJavascript(String string2) {
        this.mMraidBridge.injectJavaScript(string2);
    }

    @VisibleForTesting
    void lockOrientation(int n2) throws MraidCommandException {
        Object object = (Activity)this.mWeakActivity.get();
        if (object != null && this.shouldAllowForceOrientation(this.mForceOrientation)) {
            if (this.mOriginalActivityOrientation == null) {
                this.mOriginalActivityOrientation = object.getRequestedOrientation();
            }
            object.setRequestedOrientation(n2);
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Attempted to lock orientation to unsupported value: ");
        ((StringBuilder)object).append(this.mForceOrientation.name());
        throw new MraidCommandException(((StringBuilder)object).toString());
    }

    public void onPreloadFinished(BaseWebView baseWebView) {
        baseWebView = (MraidBridge.MraidWebView)baseWebView;
        this.mMraidWebView = baseWebView;
        this.mMraidBridge.attachView((MraidBridge.MraidWebView)baseWebView);
        this.mDefaultAdContainer.addView((View)this.mMraidWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.handlePageLoad();
    }

    public void onShow(Activity object) {
        this.mWeakActivity = new WeakReference<Activity>((Activity)object);
        object = this.mOnCloseButtonListener;
        if (object != null) {
            object.useCustomCloseChanged(this.isUsingCustomClose());
        }
        try {
            this.applyOrientation();
        }
        catch (MraidCommandException mraidCommandException) {
            MoPubLog.d((String)"Failed to apply orientation.");
        }
    }

    public void pause(boolean bl) {
        this.mIsPaused = true;
        MraidBridge.MraidWebView mraidWebView = this.mMraidWebView;
        if (mraidWebView != null) {
            WebViews.onPause((WebView)mraidWebView, (boolean)bl);
        }
        if ((mraidWebView = this.mTwoPartWebView) != null) {
            WebViews.onPause((WebView)mraidWebView, (boolean)bl);
        }
    }

    public void resume() {
        this.mIsPaused = false;
        MraidBridge.MraidWebView mraidWebView = this.mMraidWebView;
        if (mraidWebView != null) {
            mraidWebView.onResume();
        }
        if ((mraidWebView = this.mTwoPartWebView) != null) {
            mraidWebView.onResume();
        }
    }

    public void setDebugListener(MraidWebViewDebugListener mraidWebViewDebugListener) {
        this.mDebugListener = mraidWebViewDebugListener;
    }

    public void setMraidListener(MraidListener mraidListener) {
        this.mMraidListener = mraidListener;
    }

    @Deprecated
    @VisibleForTesting
    void setOrientationBroadcastReceiver(OrientationBroadcastReceiver orientationBroadcastReceiver) {
        this.mOrientationBroadcastReceiver = orientationBroadcastReceiver;
    }

    @Deprecated
    @VisibleForTesting
    void setRootView(FrameLayout frameLayout) {
        this.mRootView = frameLayout;
    }

    @Deprecated
    @VisibleForTesting
    void setRootViewSize(int n2, int n3) {
        this.mScreenMetrics.setRootViewPosition(0, 0, n2, n3);
    }

    public void setUseCustomCloseListener(UseCustomCloseListener useCustomCloseListener) {
        this.mOnCloseButtonListener = useCustomCloseListener;
    }

    @Deprecated
    @VisibleForTesting
    void setViewStateForTesting(ViewState viewState) {
        this.mViewState = viewState;
    }

    @VisibleForTesting
    boolean shouldAllowForceOrientation(MraidOrientation mraidOrientation) {
        boolean bl;
        boolean bl2;
        MraidOrientation mraidOrientation2;
        block5: {
            mraidOrientation2 = MraidOrientation.NONE;
            bl2 = true;
            bl = true;
            if (mraidOrientation == mraidOrientation2) {
                return true;
            }
            mraidOrientation2 = (Activity)this.mWeakActivity.get();
            if (mraidOrientation2 == null) {
                return false;
            }
            try {
                PackageManager packageManager = mraidOrientation2.getPackageManager();
                ComponentName componentName = new ComponentName((Context)mraidOrientation2, ((Object)((Object)mraidOrientation2)).getClass());
                mraidOrientation2 = packageManager.getActivityInfo(componentName, 0);
                int n2 = ((ActivityInfo)mraidOrientation2).screenOrientation;
                if (n2 == -1) break block5;
                if (n2 != mraidOrientation.getActivityInfoOrientation()) {
                    bl = false;
                }
                return bl;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
        }
        bl = Utils.bitMaskContainsFlag((int)((ActivityInfo)mraidOrientation2).configChanges, (int)128) && Utils.bitMaskContainsFlag((int)((ActivityInfo)mraidOrientation2).configChanges, (int)1024) ? bl2 : false;
        return bl;
    }

    @VisibleForTesting
    void unApplyOrientation() {
        Integer n2;
        Activity activity = (Activity)this.mWeakActivity.get();
        if (activity != null && (n2 = this.mOriginalActivityOrientation) != null) {
            activity.setRequestedOrientation(n2.intValue());
        }
        this.mOriginalActivityOrientation = null;
    }

    public static interface MraidListener {
        public void onClose();

        public void onExpand();

        public void onFailedToLoad();

        public void onLoaded(View var1);

        public void onOpen();

        public void onRenderProcessGone(MoPubErrorCode var1);

        public void onResize(boolean var1);
    }

    public static interface MraidWebViewCacheListener {
        public void onReady(MraidBridge.MraidWebView var1, ExternalViewabilitySessionManager var2);
    }

    @VisibleForTesting
    class OrientationBroadcastReceiver
    extends BroadcastReceiver {
        private Context mContext;
        private int mLastRotation = -1;

        OrientationBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int n2;
            if (this.mContext == null) {
                return;
            }
            if ("android.intent.action.CONFIGURATION_CHANGED".equals(intent.getAction()) && (n2 = MraidController.this.getDisplayRotation()) != this.mLastRotation) {
                this.mLastRotation = n2;
                MraidController.this.handleOrientationChange(n2);
            }
        }

        public void register(Context context) {
            Preconditions.checkNotNull((Object)context);
            this.mContext = context = context.getApplicationContext();
            if (context != null) {
                context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
            }
        }

        public void unregister() {
            Context context = this.mContext;
            if (context != null) {
                context.unregisterReceiver((BroadcastReceiver)this);
                this.mContext = null;
            }
        }
    }

    @VisibleForTesting
    static class ScreenMetricsWaiter {
        private final Handler mHandler = new Handler();
        private WaitRequest mLastWaitRequest;

        ScreenMetricsWaiter() {
        }

        void cancelLastRequest() {
            WaitRequest waitRequest = this.mLastWaitRequest;
            if (waitRequest != null) {
                waitRequest.cancel();
                this.mLastWaitRequest = null;
            }
        }

        WaitRequest waitFor(View ... object) {
            this.mLastWaitRequest = object = new WaitRequest(this.mHandler, (View[])object);
            return object;
        }

        static class WaitRequest {
            private final Handler mHandler;
            private Runnable mSuccessRunnable;
            private final View[] mViews;
            int mWaitCount;
            private final Runnable mWaitingRunnable = new Runnable(){

                @Override
                public void run() {
                    for (final View view : WaitRequest.this.mViews) {
                        if (view.getHeight() <= 0 && view.getWidth() <= 0) {
                            view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                                public boolean onPreDraw() {
                                    view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                                    WaitRequest.this.countDown();
                                    return true;
                                }
                            });
                            continue;
                        }
                        WaitRequest.this.countDown();
                    }
                }
            };

            private WaitRequest(Handler handler, View[] viewArray) {
                this.mHandler = handler;
                this.mViews = viewArray;
            }

            private void countDown() {
                Runnable runnable;
                int n2;
                this.mWaitCount = n2 = this.mWaitCount - 1;
                if (n2 == 0 && (runnable = this.mSuccessRunnable) != null) {
                    runnable.run();
                    this.mSuccessRunnable = null;
                }
            }

            void cancel() {
                this.mHandler.removeCallbacks(this.mWaitingRunnable);
                this.mSuccessRunnable = null;
            }

            void start(Runnable runnable) {
                this.mSuccessRunnable = runnable;
                this.mWaitCount = this.mViews.length;
                this.mHandler.post(this.mWaitingRunnable);
            }
        }
    }

    public static interface UseCustomCloseListener {
        public void useCustomCloseChanged(boolean var1);
    }
}

