/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mraid;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.JsResult;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.mopub.common.AdReport;
import com.mopub.common.CloseableLayout;
import com.mopub.common.Constants;
import com.mopub.common.Preconditions;
import com.mopub.common.VisibilityTracker;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseWebView;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.ViewGestureDetector;
import com.mopub.mraid.MraidCommandException;
import com.mopub.mraid.MraidJavascriptCommand;
import com.mopub.mraid.MraidNativeCommandHandler;
import com.mopub.mraid.MraidOrientation;
import com.mopub.mraid.MraidScreenMetrics;
import com.mopub.mraid.MraidWebViewClient;
import com.mopub.mraid.PlacementType;
import com.mopub.mraid.ViewState;
import com.mopub.network.MoPubRequestUtils;
import com.mopub.network.Networking;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class MraidBridge {
    static final String MRAID_OPEN = "mraid://open?url=";
    private final AdReport mAdReport;
    private ViewGestureDetector mGestureDetector;
    private boolean mHasLoaded;
    private MraidBridgeListener mMraidBridgeListener;
    private final MraidNativeCommandHandler mMraidNativeCommandHandler;
    private MraidWebView mMraidWebView;
    private final WebViewClient mMraidWebViewClient = new MraidWebViewClient(){

        public void onPageFinished(WebView webView, String string2) {
            MraidBridge.this.handlePageFinished();
        }

        public void onReceivedError(WebView webView, int n2, String string2, String string3) {
            MoPubLog.SdkLogEvent sdkLogEvent = MoPubLog.SdkLogEvent.CUSTOM;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error: ");
            stringBuilder.append(string2);
            MoPubLog.log((MoPubLog.MPLogEventType)sdkLogEvent, (Object[])new Object[]{stringBuilder.toString()});
            super.onReceivedError(webView, n2, string2, string3);
        }

        public boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
            MraidBridge.this.handleRenderProcessGone(renderProcessGoneDetail);
            return true;
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            return MraidBridge.this.handleShouldOverrideUrl(string2);
        }
    };
    private final PlacementType mPlacementType;

    MraidBridge(AdReport adReport, PlacementType placementType) {
        this(adReport, placementType, new MraidNativeCommandHandler());
    }

    @VisibleForTesting
    MraidBridge(AdReport adReport, PlacementType placementType, MraidNativeCommandHandler mraidNativeCommandHandler) {
        this.mAdReport = adReport;
        this.mPlacementType = placementType;
        this.mMraidNativeCommandHandler = mraidNativeCommandHandler;
    }

    private int checkRange(int n2, int n3, int n4) throws MraidCommandException {
        if (n2 >= n3 && n2 <= n4) {
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Integer parameter out of range: ");
        stringBuilder.append(n2);
        throw new MraidCommandException(stringBuilder.toString());
    }

    private void fireErrorEvent(MraidJavascriptCommand mraidJavascriptCommand, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("window.mraidbridge.notifyErrorEvent(");
        stringBuilder.append(JSONObject.quote((String)mraidJavascriptCommand.toJavascriptString()));
        stringBuilder.append(", ");
        stringBuilder.append(JSONObject.quote((String)string2));
        stringBuilder.append(")");
        this.injectJavaScript(stringBuilder.toString());
    }

    private void fireNativeCommandCompleteEvent(MraidJavascriptCommand mraidJavascriptCommand) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("window.mraidbridge.nativeCallComplete(");
        stringBuilder.append(JSONObject.quote((String)mraidJavascriptCommand.toJavascriptString()));
        stringBuilder.append(")");
        this.injectJavaScript(stringBuilder.toString());
    }

    @VisibleForTesting
    private void handlePageFinished() {
        if (this.mHasLoaded) {
            return;
        }
        this.mHasLoaded = true;
        MraidBridgeListener mraidBridgeListener = this.mMraidBridgeListener;
        if (mraidBridgeListener != null) {
            mraidBridgeListener.onPageLoaded();
        }
    }

    private static boolean parseAllowCustomClose(Map<String, String> object, AdReport adReport) throws MraidCommandException {
        object = object.get("shouldUseCustomClose");
        boolean bl = false;
        boolean bl2 = MraidBridge.parseBoolean((String)object, false);
        boolean bl3 = bl;
        if (adReport != null) {
            bl3 = bl;
            if (adReport.shouldAllowCustomClose()) {
                bl3 = true;
            }
        }
        return bl2 & bl3;
    }

    private static boolean parseBoolean(String string2) throws MraidCommandException {
        if ("true".equals(string2)) {
            return true;
        }
        if ("false".equals(string2)) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid boolean parameter: ");
        stringBuilder.append(string2);
        throw new MraidCommandException(stringBuilder.toString());
    }

    private static boolean parseBoolean(String string2, boolean bl) throws MraidCommandException {
        if (string2 == null) {
            return bl;
        }
        return MraidBridge.parseBoolean(string2);
    }

    private CloseableLayout.ClosePosition parseClosePosition(String string2, CloseableLayout.ClosePosition object) throws MraidCommandException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return object;
        }
        if (string2.equals("top-left")) {
            return CloseableLayout.ClosePosition.TOP_LEFT;
        }
        if (string2.equals("top-right")) {
            return CloseableLayout.ClosePosition.TOP_RIGHT;
        }
        if (string2.equals("center")) {
            return CloseableLayout.ClosePosition.CENTER;
        }
        if (string2.equals("bottom-left")) {
            return CloseableLayout.ClosePosition.BOTTOM_LEFT;
        }
        if (string2.equals("bottom-right")) {
            return CloseableLayout.ClosePosition.BOTTOM_RIGHT;
        }
        if (string2.equals("top-center")) {
            return CloseableLayout.ClosePosition.TOP_CENTER;
        }
        if (string2.equals("bottom-center")) {
            return CloseableLayout.ClosePosition.BOTTOM_CENTER;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Invalid close position: ");
        ((StringBuilder)object).append(string2);
        throw new MraidCommandException(((StringBuilder)object).toString());
    }

    private MraidOrientation parseOrientation(String string2) throws MraidCommandException {
        if ("portrait".equals(string2)) {
            return MraidOrientation.PORTRAIT;
        }
        if ("landscape".equals(string2)) {
            return MraidOrientation.LANDSCAPE;
        }
        if ("none".equals(string2)) {
            return MraidOrientation.NONE;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid orientation: ");
        stringBuilder.append(string2);
        throw new MraidCommandException(stringBuilder.toString());
    }

    private int parseSize(String string2) throws MraidCommandException {
        try {
            int n2 = Integer.parseInt(string2, 10);
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid numeric parameter: ");
            stringBuilder.append(string2);
            throw new MraidCommandException(stringBuilder.toString());
        }
    }

    private URI parseURI(String string2) throws MraidCommandException {
        if (string2 != null) {
            try {
                URI uRI = new URI(string2);
                return uRI;
            }
            catch (URISyntaxException uRISyntaxException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Invalid URL parameter: ");
                stringBuilder.append(string2);
                throw new MraidCommandException(stringBuilder.toString());
            }
        }
        throw new MraidCommandException("Parameter cannot be null");
    }

    private URI parseURI(String string2, URI uRI) throws MraidCommandException {
        if (string2 == null) {
            return uRI;
        }
        return this.parseURI(string2);
    }

    private String stringifyRect(Rect rect) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(rect.left);
        stringBuilder.append(",");
        stringBuilder.append(rect.top);
        stringBuilder.append(",");
        stringBuilder.append(rect.width());
        stringBuilder.append(",");
        stringBuilder.append(rect.height());
        return stringBuilder.toString();
    }

    private String stringifySize(Rect rect) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(rect.width());
        stringBuilder.append(",");
        stringBuilder.append(rect.height());
        return stringBuilder.toString();
    }

    void attachView(MraidWebView mraidWebView) {
        this.mMraidWebView = mraidWebView;
        mraidWebView.getSettings().setJavaScriptEnabled(true);
        if (this.mPlacementType == PlacementType.INTERSTITIAL) {
            mraidWebView.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.mMraidWebView.setScrollContainer(false);
        this.mMraidWebView.setVerticalScrollBarEnabled(false);
        this.mMraidWebView.setHorizontalScrollBarEnabled(false);
        this.mMraidWebView.setBackgroundColor(0);
        this.mMraidWebView.setWebViewClient(this.mMraidWebViewClient);
        this.mMraidWebView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                if (MraidBridge.this.mMraidBridgeListener != null) {
                    return MraidBridge.this.mMraidBridgeListener.onConsoleMessage(consoleMessage);
                }
                return super.onConsoleMessage(consoleMessage);
            }

            public boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
                if (MraidBridge.this.mMraidBridgeListener != null) {
                    return MraidBridge.this.mMraidBridgeListener.onJsAlert(string3, jsResult);
                }
                return super.onJsAlert(webView, string2, string3, jsResult);
            }

            public void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
                super.onShowCustomView(view, customViewCallback);
            }
        });
        this.mGestureDetector = new ViewGestureDetector(this.mMraidWebView.getContext());
        this.mMraidWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                MraidBridge.this.mGestureDetector.onTouchEvent(motionEvent);
                int n2 = motionEvent.getAction();
                if (!(n2 != 0 && n2 != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mMraidWebView.setVisibilityChangedListener(new MraidWebView.OnVisibilityChangedListener(){

            @Override
            public void onVisibilityChanged(boolean bl) {
                if (MraidBridge.this.mMraidBridgeListener != null) {
                    MraidBridge.this.mMraidBridgeListener.onVisibilityChanged(bl);
                }
            }
        });
    }

    void detach() {
        MraidWebView mraidWebView = this.mMraidWebView;
        if (mraidWebView != null) {
            mraidWebView.destroy();
            this.mMraidWebView = null;
        }
    }

    @VisibleForTesting
    MraidWebView getMraidWebView() {
        return this.mMraidWebView;
    }

    @TargetApi(value=26)
    @VisibleForTesting
    void handleRenderProcessGone(RenderProcessGoneDetail renderProcessGoneDetail) {
        renderProcessGoneDetail = renderProcessGoneDetail != null && renderProcessGoneDetail.didCrash() ? MoPubErrorCode.RENDER_PROCESS_GONE_WITH_CRASH : MoPubErrorCode.RENDER_PROCESS_GONE_UNSPECIFIED;
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{renderProcessGoneDetail});
        this.detach();
        MraidBridgeListener mraidBridgeListener = this.mMraidBridgeListener;
        if (mraidBridgeListener != null) {
            mraidBridgeListener.onRenderProcessGone((MoPubErrorCode)renderProcessGoneDetail);
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    boolean handleShouldOverrideUrl(String object) {
        try {
            new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            MoPubLog.SdkLogEvent sdkLogEvent = MoPubLog.SdkLogEvent.CUSTOM;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid MRAID URL: ");
            stringBuilder.append((String)object);
            MoPubLog.log((MoPubLog.MPLogEventType)sdkLogEvent, (Object[])new Object[]{stringBuilder.toString()});
            this.fireErrorEvent(MraidJavascriptCommand.UNSPECIFIED, "Mraid command sent an invalid URL");
            return true;
        }
        Uri uri = Uri.parse((String)object);
        String string2 = uri.getScheme();
        String string3 = uri.getHost();
        if ("mopub".equals(string2)) {
            if ("failLoad".equals(string3) && this.mPlacementType == PlacementType.INLINE && (object = this.mMraidBridgeListener) != null) {
                object.onPageFailedToLoad();
            }
            return true;
        }
        Object object2 = uri;
        Object object3 = string2;
        String string4 = string3;
        if (this.isClicked()) {
            object2 = uri;
            object3 = string2;
            string4 = string3;
            if (!"mraid".equals(string2)) {
                try {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(MRAID_OPEN);
                    ((StringBuilder)object2).append(URLEncoder.encode((String)object, "UTF-8"));
                    object2 = Uri.parse((String)((StringBuilder)object2).toString());
                    string4 = object2.getHost();
                    object3 = object2.getScheme();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    MoPubLog.SdkLogEvent sdkLogEvent = MoPubLog.SdkLogEvent.CUSTOM;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("Invalid MRAID URL encoding: ");
                    ((StringBuilder)object3).append((String)object);
                    MoPubLog.log((MoPubLog.MPLogEventType)sdkLogEvent, (Object[])new Object[]{((StringBuilder)object3).toString()});
                    this.fireErrorEvent(MraidJavascriptCommand.OPEN, "Non-mraid URL is invalid");
                    return false;
                }
            }
        }
        if ("mraid".equals(object3)) {
            block12: {
                void var1_4;
                object3 = MraidJavascriptCommand.fromJavascriptString(string4);
                try {
                    this.runCommand((MraidJavascriptCommand)((Object)object3), MoPubRequestUtils.getQueryParamMap((Uri)object2));
                    break block12;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (MraidCommandException mraidCommandException) {
                    // empty catch block
                }
                this.fireErrorEvent((MraidJavascriptCommand)((Object)object3), var1_4.getMessage());
            }
            this.fireNativeCommandCompleteEvent((MraidJavascriptCommand)((Object)object3));
            return true;
        }
        return false;
    }

    void injectJavaScript(String string2) {
        if (this.mMraidWebView == null) {
            MoPubLog.SdkLogEvent sdkLogEvent = MoPubLog.SdkLogEvent.CUSTOM;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Attempted to inject Javascript into MRAID WebView while was not attached:\n\t");
            stringBuilder.append(string2);
            MoPubLog.log((MoPubLog.MPLogEventType)sdkLogEvent, (Object[])new Object[]{stringBuilder.toString()});
            return;
        }
        Object object = MoPubLog.SdkLogEvent.CUSTOM;
        Object object2 = new StringBuilder();
        object2.append("Injecting Javascript into MRAID WebView:\n\t");
        object2.append(string2);
        MoPubLog.log((MoPubLog.MPLogEventType)object, (Object[])new Object[]{object2.toString()});
        object2 = this.mMraidWebView;
        object = new StringBuilder();
        ((StringBuilder)object).append("javascript:");
        ((StringBuilder)object).append(string2);
        object2.loadUrl(((StringBuilder)object).toString());
    }

    boolean isAttached() {
        boolean bl = this.mMraidWebView != null;
        return bl;
    }

    boolean isClicked() {
        ViewGestureDetector viewGestureDetector = this.mGestureDetector;
        boolean bl = viewGestureDetector != null && viewGestureDetector.isClicked();
        return bl;
    }

    boolean isLoaded() {
        return this.mHasLoaded;
    }

    boolean isViewable() {
        MraidWebView mraidWebView = this.mMraidWebView;
        boolean bl = mraidWebView != null && mraidWebView.isMraidViewable();
        return bl;
    }

    void notifyPlacementType(PlacementType placementType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mraidbridge.setPlacementType(");
        stringBuilder.append(JSONObject.quote((String)placementType.toJavascriptString()));
        stringBuilder.append(")");
        this.injectJavaScript(stringBuilder.toString());
    }

    void notifyReady() {
        this.injectJavaScript("mraidbridge.notifyReadyEvent();");
    }

    public void notifyScreenMetrics(MraidScreenMetrics mraidScreenMetrics) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mraidbridge.setScreenSize(");
        stringBuilder.append(this.stringifySize(mraidScreenMetrics.getScreenRectDips()));
        stringBuilder.append(");mraidbridge.setMaxSize(");
        stringBuilder.append(this.stringifySize(mraidScreenMetrics.getRootViewRectDips()));
        stringBuilder.append(");mraidbridge.setCurrentPosition(");
        stringBuilder.append(this.stringifyRect(mraidScreenMetrics.getCurrentAdRectDips()));
        stringBuilder.append(");mraidbridge.setDefaultPosition(");
        stringBuilder.append(this.stringifyRect(mraidScreenMetrics.getDefaultAdRectDips()));
        stringBuilder.append(")");
        this.injectJavaScript(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("mraidbridge.notifySizeChangeEvent(");
        stringBuilder.append(this.stringifySize(mraidScreenMetrics.getCurrentAdRectDips()));
        stringBuilder.append(")");
        this.injectJavaScript(stringBuilder.toString());
    }

    void notifySupports(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mraidbridge.setSupports(");
        stringBuilder.append(bl);
        stringBuilder.append(",");
        stringBuilder.append(bl2);
        stringBuilder.append(",");
        stringBuilder.append(bl3);
        stringBuilder.append(",");
        stringBuilder.append(bl4);
        stringBuilder.append(",");
        stringBuilder.append(bl5);
        stringBuilder.append(")");
        this.injectJavaScript(stringBuilder.toString());
    }

    void notifyViewState(ViewState viewState) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mraidbridge.setState(");
        stringBuilder.append(JSONObject.quote((String)viewState.toJavascriptString()));
        stringBuilder.append(")");
        this.injectJavaScript(stringBuilder.toString());
    }

    void notifyViewability(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("mraidbridge.setIsViewable(");
        stringBuilder.append(bl);
        stringBuilder.append(")");
        this.injectJavaScript(stringBuilder.toString());
    }

    @VisibleForTesting
    void runCommand(MraidJavascriptCommand object, Map<String, String> map) throws MraidCommandException {
        if (object.requiresClick(this.mPlacementType) && !this.isClicked()) {
            throw new MraidCommandException("Cannot execute this command unless the user clicks");
        }
        if (this.mMraidBridgeListener != null) {
            if (this.mMraidWebView != null) {
                switch (5.$SwitchMap$com$mopub$mraid$MraidJavascriptCommand[object.ordinal()]) {
                    default: {
                        break;
                    }
                    case 10: {
                        throw new MraidCommandException("Unspecified MRAID Javascript command");
                    }
                    case 8: 
                    case 9: {
                        throw new MraidCommandException("Unsupported MRAID Javascript command");
                    }
                    case 7: {
                        object = this.parseURI(map.get("uri"));
                        this.mMraidBridgeListener.onPlayVideo((URI)object);
                        break;
                    }
                    case 6: {
                        boolean bl = MraidBridge.parseBoolean(map.get("allowOrientationChange"));
                        object = this.parseOrientation(map.get("forceOrientation"));
                        this.mMraidBridgeListener.onSetOrientationProperties(bl, (MraidOrientation)((Object)object));
                        break;
                    }
                    case 5: {
                        object = this.parseURI(map.get("url"));
                        this.mMraidBridgeListener.onOpen((URI)object);
                        break;
                    }
                    case 4: {
                        boolean bl = MraidBridge.parseAllowCustomClose(map, this.mAdReport);
                        this.mMraidBridgeListener.onUseCustomClose(bl);
                        break;
                    }
                    case 3: {
                        object = this.parseURI(map.get("url"), null);
                        boolean bl = MraidBridge.parseAllowCustomClose(map, this.mAdReport);
                        this.mMraidBridgeListener.onExpand((URI)object, bl);
                        break;
                    }
                    case 2: {
                        int n2 = this.parseSize(map.get("width"));
                        boolean bl = false;
                        n2 = this.checkRange(n2, 0, 100000);
                        int n3 = this.checkRange(this.parseSize(map.get("height")), 0, 100000);
                        int n4 = this.checkRange(this.parseSize(map.get("offsetX")), -100000, 100000);
                        int n5 = this.checkRange(this.parseSize(map.get("offsetY")), -100000, 100000);
                        object = this.parseClosePosition(map.get("customClosePosition"), CloseableLayout.ClosePosition.TOP_RIGHT);
                        boolean bl2 = MraidBridge.parseBoolean(map.get("allowOffscreen"), true);
                        this.mMraidBridgeListener.onResize(n2, n3, n4, n5, (CloseableLayout.ClosePosition)object, bl2);
                        object = this.mAdReport;
                        bl2 = bl;
                        if (object != null) {
                            bl2 = bl;
                            if (object.shouldAllowCustomClose()) {
                                bl2 = true;
                            }
                        }
                        this.mMraidBridgeListener.onUseCustomClose(bl2);
                        break;
                    }
                    case 1: {
                        this.mMraidBridgeListener.onClose();
                    }
                }
                return;
            }
            throw new MraidCommandException("The current WebView is being destroyed");
        }
        throw new MraidCommandException("Invalid state to execute this command");
    }

    @VisibleForTesting
    void setClicked(boolean bl) {
        ViewGestureDetector viewGestureDetector = this.mGestureDetector;
        if (viewGestureDetector != null) {
            viewGestureDetector.setClicked(bl);
        }
    }

    public void setContentHtml(String string2) {
        MraidWebView mraidWebView = this.mMraidWebView;
        if (mraidWebView == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"MRAID bridge called setContentHtml before WebView was attached"});
            return;
        }
        this.mHasLoaded = false;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Networking.getBaseUrlScheme());
        stringBuilder.append("://");
        stringBuilder.append(Constants.HOST);
        stringBuilder.append("/");
        mraidWebView.loadDataWithBaseURL(stringBuilder.toString(), string2, "text/html", "UTF-8", null);
    }

    public void setContentUrl(String string2) {
        MraidWebView mraidWebView = this.mMraidWebView;
        if (mraidWebView == null) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"MRAID bridge called setContentHtml while WebView was not attached"});
            return;
        }
        this.mHasLoaded = false;
        mraidWebView.loadUrl(string2);
    }

    void setMraidBridgeListener(MraidBridgeListener mraidBridgeListener) {
        this.mMraidBridgeListener = mraidBridgeListener;
    }

    public static interface MraidBridgeListener {
        public void onClose();

        public boolean onConsoleMessage(ConsoleMessage var1);

        public void onExpand(URI var1, boolean var2) throws MraidCommandException;

        public boolean onJsAlert(String var1, JsResult var2);

        public void onOpen(URI var1);

        public void onPageFailedToLoad();

        public void onPageLoaded();

        public void onPlayVideo(URI var1);

        public void onRenderProcessGone(MoPubErrorCode var1);

        public void onResize(int var1, int var2, int var3, int var4, CloseableLayout.ClosePosition var5, boolean var6) throws MraidCommandException;

        public void onSetOrientationProperties(boolean var1, MraidOrientation var2) throws MraidCommandException;

        public void onUseCustomClose(boolean var1);

        public void onVisibilityChanged(boolean var1);
    }

    public static class MraidWebView
    extends BaseWebView {
        private static final int DEFAULT_MIN_VISIBLE_PX = 1;
        private boolean mMraidViewable;
        private OnVisibilityChangedListener mOnVisibilityChangedListener;
        private VisibilityTracker mVisibilityTracker;

        public MraidWebView(Context object) {
            super((Context)object);
            if (Build.VERSION.SDK_INT <= 22) {
                boolean bl = this.getVisibility() == 0;
                this.mMraidViewable = bl;
                return;
            }
            this.mVisibilityTracker = new VisibilityTracker(object);
            object = new VisibilityTracker.VisibilityTrackerListener(){

                public void onVisibilityChanged(List<View> list, List<View> object) {
                    Preconditions.checkNotNull(list);
                    Preconditions.checkNotNull(object);
                    object = MraidWebView.this;
                    ((MraidWebView)object).setMraidViewable(list.contains(object));
                }
            };
            this.mVisibilityTracker.setVisibilityTrackerListener((VisibilityTracker.VisibilityTrackerListener)object);
        }

        private void setMraidViewable(boolean bl) {
            if (this.mMraidViewable == bl) {
                return;
            }
            this.mMraidViewable = bl;
            OnVisibilityChangedListener onVisibilityChangedListener = this.mOnVisibilityChangedListener;
            if (onVisibilityChangedListener != null) {
                onVisibilityChangedListener.onVisibilityChanged(bl);
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            this.mVisibilityTracker = null;
            this.mOnVisibilityChangedListener = null;
        }

        public boolean isMraidViewable() {
            return this.mMraidViewable;
        }

        protected void onVisibilityChanged(View view, int n2) {
            super.onVisibilityChanged(view, n2);
            VisibilityTracker visibilityTracker = this.mVisibilityTracker;
            boolean bl = true;
            if (visibilityTracker == null) {
                if (n2 != 0) {
                    bl = false;
                }
                this.setMraidViewable(bl);
                return;
            }
            if (n2 == 0) {
                visibilityTracker.clear();
                this.mVisibilityTracker.addView(view, (View)this, 0, 0, Integer.valueOf(1));
            } else {
                visibilityTracker.removeView((View)this);
                this.setMraidViewable(false);
            }
        }

        void setVisibilityChangedListener(OnVisibilityChangedListener onVisibilityChangedListener) {
            this.mOnVisibilityChangedListener = onVisibilityChangedListener;
        }

        public static interface OnVisibilityChangedListener {
            public void onVisibilityChanged(boolean var1);
        }
    }
}

