/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.resource;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.common.util.Numbers;
import com.mopub.mobileads.resource.BaseWidgetDrawable;
import com.mopub.mobileads.resource.DrawableConstants;

public class RadialCountdownDrawable
extends BaseWidgetDrawable {
    private final Paint mArcPaint;
    private final Paint mCirclePaint;
    private int mInitialCountdownMilliseconds;
    private int mSecondsRemaining;
    private float mSweepAngle;
    private final Paint mTextPaint;
    private Rect mTextRect;

    public RadialCountdownDrawable(Context context) {
        int n2 = Dips.dipsToIntPixels((float)3.0f, (Context)context);
        float f3 = Dips.dipsToFloatPixels((float)18.0f, (Context)context);
        context = new Paint();
        this.mCirclePaint = context;
        context.setColor(-1);
        this.mCirclePaint.setAlpha(128);
        this.mCirclePaint.setStyle(DrawableConstants.RadialCountdown.BACKGROUND_STYLE);
        context = this.mCirclePaint;
        float f4 = n2;
        context.setStrokeWidth(f4);
        this.mCirclePaint.setAntiAlias(true);
        context = new Paint();
        this.mArcPaint = context;
        context.setColor(-1);
        this.mArcPaint.setAlpha(255);
        this.mArcPaint.setStyle(DrawableConstants.RadialCountdown.PROGRESS_STYLE);
        this.mArcPaint.setStrokeWidth(f4);
        this.mArcPaint.setAntiAlias(true);
        context = new Paint();
        this.mTextPaint = context;
        context.setColor(-1);
        this.mTextPaint.setTextAlign(DrawableConstants.RadialCountdown.TEXT_ALIGN);
        this.mTextPaint.setTextSize(f3);
        this.mTextPaint.setAntiAlias(true);
        this.mTextRect = new Rect();
    }

    public void draw(Canvas canvas) {
        int n2 = this.getBounds().centerX();
        int n3 = this.getBounds().centerY();
        int n4 = Math.min(n2, n3);
        canvas.drawCircle((float)n2, (float)n3, (float)n4, this.mCirclePaint);
        n4 = this.mSecondsRemaining;
        this.drawTextWithinBounds(canvas, this.mTextPaint, this.mTextRect, String.valueOf(n4));
        canvas.drawArc(new RectF(this.getBounds()), -90.0f, this.mSweepAngle, false, this.mArcPaint);
    }

    @Deprecated
    @VisibleForTesting
    public int getInitialCountdownMilliseconds() {
        return this.mInitialCountdownMilliseconds;
    }

    public void setInitialCountdown(int n2) {
        this.mInitialCountdownMilliseconds = n2;
    }

    public void updateCountdownProgress(int n2) {
        this.mSecondsRemaining = (int)Numbers.convertMillisecondsToSecondsRoundedUp((long)(this.mInitialCountdownMilliseconds - n2));
        this.mSweepAngle = (float)n2 * 360.0f / (float)this.mInitialCountdownMilliseconds;
        this.invalidateSelf();
    }
}

