/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.resource;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.resource.BaseWidgetDrawable;
import com.mopub.mobileads.resource.DrawableConstants;

public class ProgressBarDrawable
extends BaseWidgetDrawable {
    private final Paint mBackgroundPaint;
    private int mCurrentProgress;
    private int mDuration;
    private int mLastProgress;
    private final int mNuggetWidth;
    private final Paint mProgressPaint;
    private int mSkipOffset;
    private float mSkipRatio;

    public ProgressBarDrawable(Context context) {
        Paint paint;
        this.mBackgroundPaint = paint = new Paint();
        paint.setColor(-1);
        this.mBackgroundPaint.setAlpha(128);
        this.mBackgroundPaint.setStyle(DrawableConstants.ProgressBar.BACKGROUND_STYLE);
        this.mBackgroundPaint.setAntiAlias(true);
        this.mProgressPaint = paint = new Paint();
        paint.setColor(DrawableConstants.ProgressBar.PROGRESS_COLOR);
        this.mProgressPaint.setAlpha(255);
        this.mProgressPaint.setStyle(DrawableConstants.ProgressBar.PROGRESS_STYLE);
        this.mProgressPaint.setAntiAlias(true);
        this.mNuggetWidth = Dips.dipsToIntPixels((float)4.0f, (Context)context);
    }

    public void draw(Canvas canvas) {
        canvas.drawRect(this.getBounds(), this.mBackgroundPaint);
        float f3 = (float)this.mCurrentProgress / (float)this.mDuration;
        canvas.drawRect((float)this.getBounds().left, (float)this.getBounds().top, (float)this.getBounds().right * f3, (float)this.getBounds().bottom, this.mProgressPaint);
        int n2 = this.mSkipOffset;
        if (n2 > 0 && n2 < this.mDuration) {
            f3 = (float)this.getBounds().right * this.mSkipRatio;
            canvas.drawRect(f3, (float)this.getBounds().top, f3 + (float)this.mNuggetWidth, (float)this.getBounds().bottom, this.mProgressPaint);
        }
    }

    @VisibleForTesting
    public void forceCompletion() {
        this.mCurrentProgress = this.mDuration;
    }

    @Deprecated
    @VisibleForTesting
    public int getCurrentProgress() {
        return this.mCurrentProgress;
    }

    @Deprecated
    @VisibleForTesting
    public float getSkipRatio() {
        return this.mSkipRatio;
    }

    public void reset() {
        this.mLastProgress = 0;
    }

    public void setDurationAndSkipOffset(int n2, int n3) {
        this.mDuration = n2;
        this.mSkipOffset = n3;
        this.mSkipRatio = (float)n3 / (float)n2;
    }

    public void setProgress(int n2) {
        int n3 = this.mLastProgress;
        if (n2 >= n3) {
            this.mCurrentProgress = n2;
            this.mLastProgress = n2;
        } else if (n2 != 0) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format("Progress not monotonically increasing: last = %d, current = %d", n3, n2)});
            this.forceCompletion();
        }
        this.invalidateSelf();
    }
}

