/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.resource;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.resource.BaseWidgetDrawable;
import com.mopub.mobileads.resource.DrawableConstants;

public class CtaButtonDrawable
extends BaseWidgetDrawable {
    private final Paint mBackgroundPaint;
    private final int mButtonCornerRadius;
    private final RectF mButtonRect;
    private String mCtaText;
    private final Paint mOutlinePaint;
    private final Paint mTextPaint;
    private final Rect mTextRect;

    public CtaButtonDrawable(Context context) {
        Paint paint;
        int n2 = Dips.dipsToIntPixels((float)2.0f, (Context)context);
        float f3 = Dips.dipsToFloatPixels((float)15.0f, (Context)context);
        this.mBackgroundPaint = paint = new Paint();
        paint.setColor(-16777216);
        this.mBackgroundPaint.setAlpha(51);
        this.mBackgroundPaint.setStyle(DrawableConstants.CtaButton.BACKGROUND_STYLE);
        this.mBackgroundPaint.setAntiAlias(true);
        this.mOutlinePaint = paint = new Paint();
        paint.setColor(-1);
        this.mOutlinePaint.setAlpha(51);
        this.mOutlinePaint.setStyle(DrawableConstants.CtaButton.OUTLINE_STYLE);
        this.mOutlinePaint.setStrokeWidth((float)n2);
        this.mOutlinePaint.setAntiAlias(true);
        this.mTextPaint = paint = new Paint();
        paint.setColor(-1);
        this.mTextPaint.setTextAlign(DrawableConstants.CtaButton.TEXT_ALIGN);
        this.mTextPaint.setTypeface(DrawableConstants.CtaButton.TEXT_TYPEFACE);
        this.mTextPaint.setTextSize(f3);
        this.mTextPaint.setAntiAlias(true);
        this.mTextRect = new Rect();
        this.mCtaText = "Learn More";
        this.mButtonRect = new RectF();
        this.mButtonCornerRadius = Dips.dipsToIntPixels((float)6.0f, (Context)context);
    }

    public void draw(Canvas canvas) {
        this.mButtonRect.set(this.getBounds());
        RectF rectF = this.mButtonRect;
        int n2 = this.mButtonCornerRadius;
        canvas.drawRoundRect(rectF, (float)n2, (float)n2, this.mBackgroundPaint);
        rectF = this.mButtonRect;
        n2 = this.mButtonCornerRadius;
        canvas.drawRoundRect(rectF, (float)n2, (float)n2, this.mOutlinePaint);
        this.drawTextWithinBounds(canvas, this.mTextPaint, this.mTextRect, this.mCtaText);
    }

    @Deprecated
    @VisibleForTesting
    public String getCtaText() {
        return this.mCtaText;
    }

    public void setCtaText(String string2) {
        this.mCtaText = string2;
        this.invalidateSelf();
    }
}

