/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.dfp.adapters;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.mopub.common.MoPub;
import com.mopub.common.SdkConfiguration;
import com.mopub.common.SdkInitializationListener;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.MoPubInterstitial;
import com.mopub.mobileads.MoPubView;
import com.mopub.mobileads.dfp.adapters.DownloadDrawablesAsync;
import com.mopub.mobileads.dfp.adapters.DrawableDownloadListener;
import com.mopub.mobileads.dfp.adapters.MoPubNativeAppInstallAdMapper;
import com.mopub.nativeads.MoPubAdRenderer;
import com.mopub.nativeads.MoPubNative;
import com.mopub.nativeads.MoPubStaticNativeAdRenderer;
import com.mopub.nativeads.NativeAd;
import com.mopub.nativeads.NativeErrorCode;
import com.mopub.nativeads.RequestParameters;
import com.mopub.nativeads.StaticNativeAd;
import com.mopub.nativeads.ViewBinder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;

public class MoPubAdapter
implements MediationNativeAdapter,
MediationBannerAdapter,
MediationInterstitialAdapter {
    public static final double DEFAULT_MOPUB_IMAGE_SCALE = 1.0;
    private static final int DEFAULT_MOPUB_PRIVACY_ICON_SIZE_DP = 20;
    private static final int MAXIMUM_MOPUB_PRIVACY_ICON_SIZE_DP = 30;
    private static final int MINIMUM_MOPUB_PRIVACY_ICON_SIZE_DP = 10;
    private static final String MOPUB_AD_UNIT_KEY = "adUnitId";
    private static final String MOPUB_NATIVE_CEVENT_VERSION = "gmext";
    public static final String TAG = "MoPubAdapter";
    private AdSize mAdSize;
    private MoPubInterstitial mMoPubInterstitial;
    private NativeAd.MoPubNativeEventListener mMoPubNativeEventListener;
    private MoPubView mMoPubView;
    private int mPrivacyIconSize;
    private int privacyIconPlacement;

    private static int getAge(Date date) {
        int n2 = Integer.parseInt((String)DateFormat.format((CharSequence)"yyyy", (Date)date));
        return Calendar.getInstance().get(1) - n2;
    }

    /*
     * Unable to fully structure code
     */
    private String getKeywords(MediationAdRequest var1_1, boolean var2_2) {
        var3_3 = var1_1.getBirthday();
        var4_4 = "";
        if (var3_3 != null) {
            var5_5 = MoPubAdapter.getAge((Date)var3_3);
            var3_3 = new StringBuilder();
            var3_3.append("m_age:");
            var3_3.append(Integer.toString(var5_5));
            var6_6 = var3_3.toString();
        } else {
            var6_6 = "";
        }
        var5_5 = var1_1.getGender();
        if (var5_5 == -1) ** GOTO lbl-1000
        if (var5_5 == 2) {
            var3_3 = "m_gender:f";
        } else if (var5_5 == 1) {
            var3_3 = "m_gender:m";
        } else lbl-1000:
        // 2 sources

        {
            var3_3 = "";
        }
        var7_7 = new StringBuilder();
        var7_7.append("gmext");
        var7_7.append(",");
        var7_7.append(var6_6);
        var7_7.append(",");
        var7_7.append((String)var3_3);
        if (var2_2) {
            if (this.keywordsContainPII(var1_1)) {
                var4_4 = var7_7.toString();
            }
            return var4_4;
        }
        if (!this.keywordsContainPII(var1_1)) {
            var4_4 = var7_7.toString();
        }
        return var4_4;
    }

    private SdkInitializationListener initSdkListener() {
        return new SdkInitializationListener(){

            public void onInitializationFinished() {
                MoPubLog.d((String)"MoPub SDK initialized.");
            }
        };
    }

    private void initializeMoPub(Context context, String string2) {
        if (!MoPub.isSdkInitialized()) {
            MoPub.initializeSdk((Context)context, (SdkConfiguration)new SdkConfiguration.Builder(string2).build(), (SdkInitializationListener)this.initSdkListener());
        }
    }

    private boolean keywordsContainPII(MediationAdRequest mediationAdRequest) {
        boolean bl = mediationAdRequest.getBirthday() != null || mediationAdRequest.getGender() != -1 || mediationAdRequest.getLocation() != null;
        return bl;
    }

    public View getBannerView() {
        return this.mMoPubView;
    }

    public void onDestroy() {
        MoPubInterstitial moPubInterstitial = this.mMoPubInterstitial;
        if (moPubInterstitial != null) {
            moPubInterstitial.destroy();
            this.mMoPubInterstitial = null;
        }
        if ((moPubInterstitial = this.mMoPubView) != null) {
            moPubInterstitial.destroy();
            this.mMoPubView = null;
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void requestBannerAd(Context context, MediationBannerListener mediationBannerListener, Bundle object, AdSize adSize, MediationAdRequest mediationAdRequest, Bundle bundle) {
        object = object.getString(MOPUB_AD_UNIT_KEY);
        this.initializeMoPub(context, (String)object);
        this.mAdSize = adSize;
        context = new MoPubView(context);
        this.mMoPubView = context;
        context.setBannerAdListener((MoPubView.BannerAdListener)new MBannerListener(mediationBannerListener));
        this.mMoPubView.setAdUnitId((String)object);
        if (mediationAdRequest.isTesting()) {
            this.mMoPubView.setTesting(true);
        }
        if (mediationAdRequest.getLocation() != null) {
            this.mMoPubView.setLocation(mediationAdRequest.getLocation());
        }
        this.mMoPubView.setKeywords(this.getKeywords(mediationAdRequest, false));
        this.mMoPubView.setUserDataKeywords(this.getKeywords(mediationAdRequest, true));
        this.mMoPubView.loadAd();
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle object, MediationAdRequest mediationAdRequest, Bundle bundle) {
        object = object.getString(MOPUB_AD_UNIT_KEY);
        this.initializeMoPub(context, (String)object);
        context = new MoPubInterstitial((Activity)context, (String)object);
        this.mMoPubInterstitial = context;
        context.setInterstitialAdListener((MoPubInterstitial.InterstitialAdListener)new mMediationInterstitialListener(mediationInterstitialListener));
        if (mediationAdRequest.isTesting()) {
            this.mMoPubInterstitial.setTesting(true);
        }
        this.mMoPubInterstitial.setKeywords(this.getKeywords(mediationAdRequest, false));
        this.mMoPubInterstitial.setKeywords(this.getKeywords(mediationAdRequest, true));
        this.mMoPubInterstitial.load();
    }

    public void requestNativeAd(Context object, final MediationNativeListener mediationNativeListener, Bundle object2, NativeMediationAdRequest nativeMediationAdRequest, Bundle object3) {
        int n2;
        object2 = object2.getString(MOPUB_AD_UNIT_KEY);
        this.initializeMoPub((Context)object, (String)object2);
        NativeAdOptions nativeAdOptions = nativeMediationAdRequest.getNativeAdOptions();
        this.privacyIconPlacement = nativeAdOptions != null ? nativeAdOptions.getAdChoicesPlacement() : 1;
        if (!nativeMediationAdRequest.isAppInstallAdRequested() && nativeMediationAdRequest.isContentAdRequested()) {
            Log.d((String)TAG, (String)"Currently, MoPub only serves native app install ads. Apps requesting content ads alone will not receive ads from this adapter.");
            mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 1);
            return;
        }
        this.mPrivacyIconSize = object3 != null ? ((n2 = object3.getInt("privacy_icon_size_dp")) < 10 ? 10 : (n2 > 30 ? 30 : n2)) : 20;
        object3 = new MoPubNative.MoPubNativeNetworkListener((Context)object){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void onNativeFail(NativeErrorCode nativeErrorCode) {
                int n2 = 4.$SwitchMap$com$mopub$nativeads$NativeErrorCode[nativeErrorCode.ordinal()];
                if (n2 != 1) {
                    if (n2 != 2) {
                        if (n2 != 3) {
                            if (n2 != 4) {
                                mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)MoPubAdapter.this, 0);
                            } else {
                                mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)MoPubAdapter.this, 0);
                            }
                        } else {
                            mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)MoPubAdapter.this, 1);
                        }
                    } else {
                        mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)MoPubAdapter.this, 1);
                    }
                } else {
                    mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)MoPubAdapter.this, 3);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onNativeLoad(NativeAd object) {
                object.setMoPubNativeEventListener(MoPubAdapter.this.mMoPubNativeEventListener);
                object = object.getBaseNativeAd();
                if (!(object instanceof StaticNativeAd)) return;
                final StaticNativeAd staticNativeAd = (StaticNativeAd)object;
                try {
                    object = new HashMap();
                    try {
                        URL uRL = new URL(staticNativeAd.getIconImageUrl());
                        ((HashMap)object).put("icon_key", uRL);
                        URL uRL2 = new URL(staticNativeAd.getMainImageUrl());
                        ((HashMap)object).put("image_key", uRL2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Log.d((String)TAG, (String)"Invalid ad response received from MoPub. Image URLs are invalid");
                        mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)MoPubAdapter.this, 0);
                    }
                    DrawableDownloadListener drawableDownloadListener = new DrawableDownloadListener(){

                        @Override
                        public void onDownloadFailure() {
                            1 var1_1 = this;
                            var1_1.mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)var1_1.MoPubAdapter.this, 0);
                        }

                        @Override
                        public void onDownloadSuccess(HashMap<String, Drawable> hashMap) {
                            try {
                                MoPubNativeAppInstallAdMapper moPubNativeAppInstallAdMapper = new MoPubNativeAppInstallAdMapper(staticNativeAd, hashMap, MoPubAdapter.this.privacyIconPlacement, MoPubAdapter.this.mPrivacyIconSize);
                                ImageView imageView = new ImageView(val$context);
                                imageView.setImageDrawable(hashMap.get("image_key"));
                                moPubNativeAppInstallAdMapper.setMediaView((View)imageView);
                                mediationNativeListener.onAdLoaded((MediationNativeAdapter)MoPubAdapter.this, (NativeAdMapper)moPubNativeAppInstallAdMapper);
                            }
                            catch (Exception exception) {
                                Log.d((String)TAG, (String)"Exception trying to download native ad drawables");
                                1 var1_3 = this;
                                var1_3.mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)var1_3.MoPubAdapter.this, 0);
                            }
                        }
                    };
                    DownloadDrawablesAsync downloadDrawablesAsync = new DownloadDrawablesAsync(drawableDownloadListener);
                    downloadDrawablesAsync.execute(new Object[]{object});
                    return;
                }
                catch (Exception exception) {
                    Log.d((String)TAG, (String)"Exception constructing the native ad");
                    mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)MoPubAdapter.this, 0);
                }
            }
        };
        if (object2 == null) {
            Log.d((String)TAG, (String)"Ad unit id is invalid. So failing the request.");
            mediationNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 1);
            return;
        }
        object2 = new MoPubNative(object, (String)object2, (MoPubNative.MoPubNativeNetworkListener)object3);
        object2.registerAdRenderer((MoPubAdRenderer)new MoPubStaticNativeAdRenderer(new ViewBinder.Builder(0).build()));
        object = EnumSet.of(RequestParameters.NativeAdAsset.TITLE, RequestParameters.NativeAdAsset.TEXT, RequestParameters.NativeAdAsset.CALL_TO_ACTION_TEXT, RequestParameters.NativeAdAsset.MAIN_IMAGE, RequestParameters.NativeAdAsset.ICON_IMAGE);
        object2.makeRequest(new RequestParameters.Builder().keywords(this.getKeywords((MediationAdRequest)nativeMediationAdRequest, false)).userDataKeywords(this.getKeywords((MediationAdRequest)nativeMediationAdRequest, true)).location(nativeMediationAdRequest.getLocation()).desiredAssets((EnumSet)object).build());
        this.mMoPubNativeEventListener = new NativeAd.MoPubNativeEventListener(){

            public void onClick(View view) {
                mediationNativeListener.onAdClicked((MediationNativeAdapter)MoPubAdapter.this);
                mediationNativeListener.onAdOpened((MediationNativeAdapter)MoPubAdapter.this);
                mediationNativeListener.onAdLeftApplication((MediationNativeAdapter)MoPubAdapter.this);
                Log.d((String)TAG, (String)"onClick");
            }

            public void onImpression(View view) {
                mediationNativeListener.onAdImpression((MediationNativeAdapter)MoPubAdapter.this);
                Log.d((String)TAG, (String)"onImpression");
            }
        };
    }

    public void showInterstitial() {
        if (this.mMoPubInterstitial.isReady()) {
            this.mMoPubInterstitial.show();
        } else {
            MoPubLog.i((String)"Interstitial was not ready. Unable to load the interstitial");
        }
    }

    public static final class BundleBuilder {
        private static final String ARG_PRIVACY_ICON_SIZE_DP = "privacy_icon_size_dp";
        private int mPrivacyIconSizeDp;

        public Bundle build() {
            Bundle bundle = new Bundle();
            bundle.putInt(ARG_PRIVACY_ICON_SIZE_DP, this.mPrivacyIconSizeDp);
            return bundle;
        }

        public BundleBuilder setPrivacyIconSize(int n2) {
            this.mPrivacyIconSizeDp = n2;
            return this;
        }
    }

    private class MBannerListener
    implements MoPubView.BannerAdListener {
        private MediationBannerListener mMediationBannerListener;

        public MBannerListener(MediationBannerListener mediationBannerListener) {
            this.mMediationBannerListener = mediationBannerListener;
        }

        @Override
        public void onBannerClicked(MoPubView moPubView) {
            this.mMediationBannerListener.onAdClicked((MediationBannerAdapter)MoPubAdapter.this);
        }

        @Override
        public void onBannerCollapsed(MoPubView moPubView) {
            this.mMediationBannerListener.onAdClosed((MediationBannerAdapter)MoPubAdapter.this);
        }

        @Override
        public void onBannerExpanded(MoPubView moPubView) {
            this.mMediationBannerListener.onAdOpened((MediationBannerAdapter)MoPubAdapter.this);
        }

        @Override
        public void onBannerFailed(MoPubView moPubView, MoPubErrorCode moPubErrorCode) {
            int n2 = 4.$SwitchMap$com$mopub$mobileads$MoPubErrorCode[moPubErrorCode.ordinal()];
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        this.mMediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)MoPubAdapter.this, 0);
                    } else {
                        this.mMediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)MoPubAdapter.this, 1);
                    }
                } else {
                    this.mMediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)MoPubAdapter.this, 2);
                }
            } else {
                this.mMediationBannerListener.onAdFailedToLoad((MediationBannerAdapter)MoPubAdapter.this, 3);
            }
        }

        @Override
        public void onBannerLoaded(MoPubView moPubView) {
            if (MoPubAdapter.this.mAdSize.getWidth() != moPubView.getAdWidth() || MoPubAdapter.this.mAdSize.getHeight() != moPubView.getAdHeight()) {
                Log.w((String)TAG, (String)"The banner ad size loaded does not match the request size. Update the ad size on your MoPub UI to match the request size.");
            }
            this.mMediationBannerListener.onAdLoaded((MediationBannerAdapter)MoPubAdapter.this);
        }
    }

    private class mMediationInterstitialListener
    implements MoPubInterstitial.InterstitialAdListener {
        private MediationInterstitialListener mMediationInterstitialListener;

        public mMediationInterstitialListener(MediationInterstitialListener mediationInterstitialListener) {
            this.mMediationInterstitialListener = mediationInterstitialListener;
        }

        @Override
        public void onInterstitialClicked(MoPubInterstitial moPubInterstitial) {
            this.mMediationInterstitialListener.onAdClicked((MediationInterstitialAdapter)MoPubAdapter.this);
        }

        @Override
        public void onInterstitialDismissed(MoPubInterstitial moPubInterstitial) {
            this.mMediationInterstitialListener.onAdClosed((MediationInterstitialAdapter)MoPubAdapter.this);
        }

        @Override
        public void onInterstitialFailed(MoPubInterstitial moPubInterstitial, MoPubErrorCode moPubErrorCode) {
            int n2 = 4.$SwitchMap$com$mopub$mobileads$MoPubErrorCode[moPubErrorCode.ordinal()];
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        this.mMediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)MoPubAdapter.this, 0);
                    } else {
                        this.mMediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)MoPubAdapter.this, 1);
                    }
                } else {
                    this.mMediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)MoPubAdapter.this, 2);
                }
            } else {
                this.mMediationInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)MoPubAdapter.this, 3);
            }
        }

        @Override
        public void onInterstitialLoaded(MoPubInterstitial moPubInterstitial) {
            this.mMediationInterstitialListener.onAdLoaded((MediationInterstitialAdapter)MoPubAdapter.this);
        }

        @Override
        public void onInterstitialShown(MoPubInterstitial moPubInterstitial) {
            this.mMediationInterstitialListener.onAdOpened((MediationInterstitialAdapter)MoPubAdapter.this);
        }
    }
}

