/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads.dfp.adapters;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.util.Log;
import com.mopub.mobileads.dfp.adapters.DrawableDownloadListener;
import com.mopub.mobileads.dfp.adapters.MoPubAdapter;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DownloadDrawablesAsync
extends AsyncTask<Object, Void, HashMap<String, Drawable>> {
    private static final long DRAWABLE_FUTURE_TIMEOUT_SECONDS = 10L;
    public static final String KEY_ICON = "icon_key";
    public static final String KEY_IMAGE = "image_key";
    private DrawableDownloadListener mListener;

    public DownloadDrawablesAsync(DrawableDownloadListener drawableDownloadListener) {
        this.mListener = drawableDownloadListener;
    }

    private Future<Drawable> getDrawableFuture(final URL uRL, ExecutorService executorService) {
        return executorService.submit(new Callable<Drawable>(){

            @Override
            public Drawable call() throws Exception {
                Bitmap bitmap2 = BitmapFactory.decodeStream((InputStream)uRL.openStream());
                bitmap2.setDensity(160);
                return new BitmapDrawable(Resources.getSystem(), bitmap2);
            }
        });
    }

    protected HashMap<String, Drawable> doInBackground(Object ... object) {
        HashMap<String, Drawable> hashMap = (HashMap<String, Drawable>)object[0];
        Object object2 = Executors.newCachedThreadPool();
        object = this.getDrawableFuture((URL)hashMap.get(KEY_IMAGE), (ExecutorService)object2);
        object2 = this.getDrawableFuture((URL)hashMap.get(KEY_ICON), (ExecutorService)object2);
        try {
            object = (Drawable)object.get(10L, TimeUnit.SECONDS);
            object2 = (Drawable)object2.get(10L, TimeUnit.SECONDS);
            hashMap = new HashMap<String, Drawable>();
            hashMap.put(KEY_IMAGE, (Drawable)object);
            hashMap.put(KEY_ICON, (Drawable)object2);
            return hashMap;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            Log.d((String)MoPubAdapter.TAG, (String)"Native ad images failed to download");
            return null;
        }
    }

    protected void onPostExecute(HashMap<String, Drawable> hashMap) {
        super.onPostExecute(hashMap);
        if (hashMap != null) {
            this.mListener.onDownloadSuccess(hashMap);
        } else {
            this.mListener.onDownloadFailure();
        }
    }
}

