/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.text.TextUtils;
import com.mopub.common.Preconditions;
import com.mopub.mobileads.VastAdXmlManager;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.util.XmlUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class VastXmlManager {
    private static final String AD = "Ad";
    private static final String CUSTOM_CLOSE_ICON = "MoPubCloseIcon";
    private static final String CUSTOM_CTA_TEXT = "MoPubCtaText";
    private static final String CUSTOM_FORCE_ORIENTATION = "MoPubForceOrientation";
    private static final String CUSTOM_SKIP_TEXT = "MoPubSkipText";
    private static final String ERROR = "Error";
    private static final int MAX_CTA_TEXT_LENGTH = 15;
    private static final int MAX_SKIP_TEXT_LENGTH = 8;
    private static final String MP_IMPRESSION_TRACKER = "MP_TRACKING_URL";
    private static final String ROOT_TAG = "MPMoVideoXMLDocRoot";
    private static final String ROOT_TAG_CLOSE = "</MPMoVideoXMLDocRoot>";
    private static final String ROOT_TAG_OPEN = "<MPMoVideoXMLDocRoot>";
    private Document mVastDoc;

    VastXmlManager() {
    }

    List<VastAdXmlManager> getAdXmlManagers() {
        ArrayList<VastAdXmlManager> arrayList = new ArrayList<VastAdXmlManager>();
        Object object = this.mVastDoc;
        if (object == null) {
            return arrayList;
        }
        object = object.getElementsByTagName(AD);
        for (int i3 = 0; i3 < object.getLength(); ++i3) {
            arrayList.add(new VastAdXmlManager(object.item(i3)));
        }
        return arrayList;
    }

    String getCustomCloseIconUrl() {
        return XmlUtils.getFirstMatchingStringData((Document)this.mVastDoc, (String)CUSTOM_CLOSE_ICON);
    }

    String getCustomCtaText() {
        String string2 = XmlUtils.getFirstMatchingStringData((Document)this.mVastDoc, (String)CUSTOM_CTA_TEXT);
        if (string2 != null && string2.length() <= 15) {
            return string2;
        }
        return null;
    }

    String getCustomSkipText() {
        String string2 = XmlUtils.getFirstMatchingStringData((Document)this.mVastDoc, (String)CUSTOM_SKIP_TEXT);
        if (string2 != null && string2.length() <= 8) {
            return string2;
        }
        return null;
    }

    VastTracker getErrorTracker() {
        Object object = this.mVastDoc;
        if (object == null) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)(object = XmlUtils.getFirstMatchingStringData((Document)object, (String)ERROR)))) {
            return null;
        }
        return new VastTracker((String)object);
    }

    List<VastTracker> getMoPubImpressionTrackers() {
        Object object = XmlUtils.getStringDataAsList((Document)this.mVastDoc, (String)MP_IMPRESSION_TRACKER);
        ArrayList<VastTracker> arrayList = new ArrayList<VastTracker>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(new VastTracker((String)object.next()));
        }
        return arrayList;
    }

    void parseVastXml(String object) throws ParserConfigurationException, IOException, SAXException {
        Preconditions.checkNotNull((Object)object, (String)"xmlString cannot be null");
        String string2 = ((String)object).replaceFirst("<\\?.*\\?>", "");
        object = new StringBuilder();
        ((StringBuilder)object).append(ROOT_TAG_OPEN);
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(ROOT_TAG_CLOSE);
        string2 = ((StringBuilder)object).toString();
        object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setCoalescing(true);
        ((DocumentBuilderFactory)object).setExpandEntityReferences(false);
        this.mVastDoc = ((DocumentBuilderFactory)object).newDocumentBuilder().parse(new InputSource(new StringReader(string2)));
    }
}

