/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.text.TextUtils;
import com.mopub.common.CacheService;
import com.mopub.common.CreativeOrientation;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Json;
import com.mopub.mobileads.BaseVideoPlayerActivity;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.MoPubErrorCode;
import com.mopub.mobileads.ResponseBodyInterstitial;
import com.mopub.mobileads.VastManager;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.factories.VastManagerFactory;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class VastVideoInterstitial
extends ResponseBodyInterstitial
implements VastManager.VastManagerListener {
    public static final String ADAPTER_NAME = "VastVideoInterstitial";
    private CustomEventInterstitial.CustomEventInterstitialListener mCustomEventInterstitialListener;
    private Map<String, String> mExternalViewabilityTrackers;
    private CreativeOrientation mOrientation;
    private VastManager mVastManager;
    private String mVastResponse;
    private VastVideoConfig mVastVideoConfig;
    private JSONObject mVideoTrackers;

    VastVideoInterstitial() {
    }

    protected void extractExtras(Map<String, String> object) {
        MoPubLog.AdapterLogEvent adapterLogEvent;
        this.mVastResponse = object.get("html-response-body");
        this.mOrientation = CreativeOrientation.fromString((String)object.get("com_mopub_orientation"));
        CharSequence charSequence = object.get("external-video-viewability-trackers");
        try {
            this.mExternalViewabilityTrackers = Json.jsonStringToMap((String)charSequence);
        }
        catch (JSONException jSONException) {
            adapterLogEvent = MoPubLog.AdapterLogEvent.CUSTOM;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to parse video viewability trackers to JSON: ");
            stringBuilder.append((String)charSequence);
            MoPubLog.log((MoPubLog.MPLogEventType)adapterLogEvent, (Object[])new Object[]{stringBuilder.toString()});
        }
        object = object.get("video-trackers");
        if (TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        try {
            charSequence = new JSONObject((String)object);
            this.mVideoTrackers = charSequence;
        }
        catch (JSONException jSONException) {
            adapterLogEvent = MoPubLog.SdkLogEvent.ERROR_WITH_THROWABLE;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Failed to parse video trackers to JSON: ");
            ((StringBuilder)charSequence).append((String)object);
            MoPubLog.log((MoPubLog.MPLogEventType)adapterLogEvent, (Object[])new Object[]{((StringBuilder)charSequence).toString(), jSONException});
            this.mVideoTrackers = null;
        }
    }

    @Deprecated
    String getVastResponse() {
        return this.mVastResponse;
    }

    public void onInvalidate() {
        VastManager vastManager = this.mVastManager;
        if (vastManager != null) {
            vastManager.cancel();
        }
        super.onInvalidate();
    }

    public void onVastVideoConfigurationPrepared(VastVideoConfig vastVideoConfig) {
        if (vastVideoConfig == null) {
            this.mCustomEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.VIDEO_DOWNLOAD_ERROR);
            return;
        }
        this.mVastVideoConfig = vastVideoConfig;
        vastVideoConfig.addVideoTrackers(this.mVideoTrackers);
        this.mVastVideoConfig.addExternalViewabilityTrackers(this.mExternalViewabilityTrackers);
        this.mCustomEventInterstitialListener.onInterstitialLoaded();
    }

    protected void preRenderHtml(CustomEventInterstitial.CustomEventInterstitialListener customEventInterstitialListener) {
        this.mCustomEventInterstitialListener = customEventInterstitialListener;
        if (!CacheService.initializeDiskCache((Context)this.mContext)) {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_FAILED, (Object[])new Object[]{ADAPTER_NAME, MoPubErrorCode.VIDEO_CACHE_ERROR.getIntCode(), MoPubErrorCode.VIDEO_CACHE_ERROR});
            this.mCustomEventInterstitialListener.onInterstitialFailed(MoPubErrorCode.VIDEO_CACHE_ERROR);
            return;
        }
        customEventInterstitialListener = VastManagerFactory.create(this.mContext);
        this.mVastManager = customEventInterstitialListener;
        customEventInterstitialListener.prepareVastVideoConfiguration(this.mVastResponse, this, this.mAdReport.getDspCreativeId(), this.mContext);
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.LOAD_SUCCESS, (Object[])new Object[]{ADAPTER_NAME});
    }

    @Deprecated
    void setVastManager(VastManager vastManager) {
        this.mVastManager = vastManager;
    }

    public void showInterstitial() {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.SHOW_ATTEMPTED, (Object[])new Object[]{ADAPTER_NAME});
        BaseVideoPlayerActivity.startVast((Context)this.mContext, (VastVideoConfig)this.mVastVideoConfig, (long)this.mBroadcastIdentifier, (CreativeOrientation)this.mOrientation);
    }
}

