/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.resource.CtaButtonDrawable;

public class VastVideoCtaButtonWidget
extends ImageView {
    private CtaButtonDrawable mCtaButtonDrawable;
    private boolean mHasClickthroughUrl;
    private boolean mHasCompanionAd;
    private boolean mIsVideoComplete;
    private boolean mIsVideoSkippable;
    private final RelativeLayout.LayoutParams mLandscapeLayoutParams;
    private final RelativeLayout.LayoutParams mPortraitLayoutParams;

    public VastVideoCtaButtonWidget(Context object, int n2, boolean bl, boolean bl2) {
        super(object);
        this.mHasCompanionAd = bl;
        this.mHasClickthroughUrl = bl2;
        this.setId(View.generateViewId());
        int n3 = Dips.dipsToIntPixels((float)150.0f, (Context)object);
        int n4 = Dips.dipsToIntPixels((float)38.0f, (Context)object);
        int n5 = Dips.dipsToIntPixels((float)16.0f, (Context)object);
        object = new CtaButtonDrawable((Context)object);
        this.mCtaButtonDrawable = object;
        this.setImageDrawable((Drawable)object);
        object = new RelativeLayout.LayoutParams(n3, n4);
        this.mLandscapeLayoutParams = object;
        object.setMargins(n5, n5, n5, n5);
        this.mLandscapeLayoutParams.addRule(8, n2);
        this.mLandscapeLayoutParams.addRule(7, n2);
        object = new RelativeLayout.LayoutParams(n3, n4);
        this.mPortraitLayoutParams = object;
        object.setMargins(n5, n5, n5, n5);
        this.mPortraitLayoutParams.addRule(12);
        this.mPortraitLayoutParams.addRule(11);
        this.updateLayoutAndVisibility();
    }

    private void updateLayoutAndVisibility() {
        if (!this.mHasClickthroughUrl) {
            this.setVisibility(8);
            return;
        }
        if (!this.mIsVideoSkippable) {
            this.setVisibility(4);
            return;
        }
        if (this.mIsVideoComplete && this.mHasCompanionAd) {
            this.setVisibility(8);
            return;
        }
        int n2 = this.getResources().getConfiguration().orientation;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Unrecognized screen orientation: CTA button widget defaulting to portrait layout"});
                        this.setLayoutParams((ViewGroup.LayoutParams)this.mPortraitLayoutParams);
                    } else {
                        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Screen orientation is deprecated ORIENTATION_SQUARE: CTA button widget defaulting to portrait layout"});
                        this.setLayoutParams((ViewGroup.LayoutParams)this.mPortraitLayoutParams);
                    }
                } else {
                    this.setLayoutParams((ViewGroup.LayoutParams)this.mLandscapeLayoutParams);
                }
            } else {
                this.setLayoutParams((ViewGroup.LayoutParams)this.mPortraitLayoutParams);
            }
        } else {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Screen orientation undefined: CTA button widget defaulting to portrait layout"});
            this.setLayoutParams((ViewGroup.LayoutParams)this.mPortraitLayoutParams);
        }
        this.setVisibility(0);
    }

    @Deprecated
    @VisibleForTesting
    String getCtaText() {
        return this.mCtaButtonDrawable.getCtaText();
    }

    @Deprecated
    @VisibleForTesting
    boolean hasLandscapeLayoutParams() {
        return this.getLayoutParams().equals(this.mLandscapeLayoutParams);
    }

    @Deprecated
    @VisibleForTesting
    boolean hasPortraitLayoutParams() {
        return this.getLayoutParams().equals(this.mPortraitLayoutParams);
    }

    void notifyVideoClickable() {
        this.mIsVideoComplete = true;
        this.updateLayoutAndVisibility();
    }

    void notifyVideoComplete() {
        this.mIsVideoSkippable = true;
        this.mIsVideoComplete = true;
        this.updateLayoutAndVisibility();
    }

    void notifyVideoSkippable() {
        this.mIsVideoSkippable = true;
        this.updateLayoutAndVisibility();
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.updateLayoutAndVisibility();
    }

    void updateCtaText(String string2) {
        this.mCtaButtonDrawable.setCtaText(string2);
    }
}

