/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.mopub.common.MoPubBrowser;
import com.mopub.common.Preconditions;
import com.mopub.common.UrlAction;
import com.mopub.common.UrlHandler;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Intents;
import com.mopub.exceptions.IntentNotResolvableException;
import com.mopub.mobileads.VastAbsoluteProgressTracker;
import com.mopub.mobileads.VastCompanionAdConfig;
import com.mopub.mobileads.VastErrorCode;
import com.mopub.mobileads.VastFractionalProgressTracker;
import com.mopub.mobileads.VastFractionalProgressTrackerTwo;
import com.mopub.mobileads.VastIconConfig;
import com.mopub.mobileads.VastTracker;
import com.mopub.mobileads.VastVideoConfig;
import com.mopub.mobileads.VideoTrackingEvent;
import com.mopub.mobileads.VideoViewabilityTracker;
import com.mopub.network.TrackingRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class VastVideoConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    @Expose
    @SerializedName(value="absolute_trackers")
    private final ArrayList<VastAbsoluteProgressTracker> mAbsoluteTrackers;
    @Expose
    @SerializedName(value="avid_javascript_resources")
    private final Set<String> mAvidJavascriptResources;
    @Expose
    @SerializedName(value="clickthrough_url")
    private String mClickThroughUrl;
    @Expose
    @SerializedName(value="click_trackers")
    private final ArrayList<VastTracker> mClickTrackers;
    @Expose
    @SerializedName(value="close_trackers")
    private final ArrayList<VastTracker> mCloseTrackers;
    @Expose
    @SerializedName(value="complete_trackers")
    private final ArrayList<VastTracker> mCompleteTrackers;
    @Expose
    @SerializedName(value="custom_close_icon_url")
    private String mCustomCloseIconUrl;
    @Expose
    @SerializedName(value="custom_cta_text")
    private String mCustomCtaText;
    @Expose
    @SerializedName(value="custom_skip_text")
    private String mCustomSkipText;
    @Expose
    @SerializedName(value="disk_media_file_url")
    private String mDiskMediaFileUrl;
    @Expose
    @SerializedName(value="dsp_creative_id")
    private String mDspCreativeId;
    @Expose
    @SerializedName(value="error_trackers")
    private final ArrayList<VastTracker> mErrorTrackers;
    @Expose
    @SerializedName(value="external_viewability_trackers")
    private final Map<String, String> mExternalViewabilityTrackers;
    @Expose
    @SerializedName(value="fractional_trackers")
    private final ArrayList<VastFractionalProgressTracker> mFractionalTrackers;
    @Expose
    @SerializedName(value="impression_trackers")
    private final ArrayList<VastTracker> mImpressionTrackers = new ArrayList();
    @Expose
    @SerializedName(value="is_rewarded")
    private boolean mIsRewardedVideo = false;
    @Expose
    @SerializedName(value="landscape_companion_ad")
    private VastCompanionAdConfig mLandscapeVastCompanionAdConfig;
    @Expose
    @SerializedName(value="moat_impression_pixels")
    private final Set<String> mMoatImpressionPixels;
    @Expose
    @SerializedName(value="network_media_file_url")
    private String mNetworkMediaFileUrl;
    @Expose
    @SerializedName(value="pause_trackers")
    private final ArrayList<VastTracker> mPauseTrackers;
    @Expose
    @SerializedName(value="portrait_companion_ad")
    private VastCompanionAdConfig mPortraitVastCompanionAdConfig;
    @Expose
    @SerializedName(value="privacy_icon_click_url")
    private String mPrivacyInformationIconClickthroughUrl;
    @Expose
    @SerializedName(value="privacy_icon_image_url")
    private String mPrivacyInformationIconImageUrl;
    @Expose
    @SerializedName(value="resume_trackers")
    private final ArrayList<VastTracker> mResumeTrackers;
    @Expose
    @SerializedName(value="skip_offset")
    private String mSkipOffset;
    @Expose
    @SerializedName(value="skip_trackers")
    private final ArrayList<VastTracker> mSkipTrackers;
    @Expose
    @SerializedName(value="icon_config")
    private VastIconConfig mVastIconConfig;
    @Expose
    @SerializedName(value="video_viewability_tracker")
    private VideoViewabilityTracker mVideoViewabilityTracker;

    public VastVideoConfig() {
        this.mFractionalTrackers = new ArrayList();
        this.mAbsoluteTrackers = new ArrayList();
        this.mPauseTrackers = new ArrayList();
        this.mResumeTrackers = new ArrayList();
        this.mCompleteTrackers = new ArrayList();
        this.mCloseTrackers = new ArrayList();
        this.mSkipTrackers = new ArrayList();
        this.mClickTrackers = new ArrayList();
        this.mErrorTrackers = new ArrayList();
        this.mExternalViewabilityTrackers = new HashMap<String, String>();
        this.mAvidJavascriptResources = new HashSet<String>();
        this.mMoatImpressionPixels = new HashSet<String>();
    }

    private void addCompanionAdClickTrackersForUrls(List<String> list) {
        Preconditions.checkNotNull(list);
        if (this.hasCompanionAd()) {
            list = this.createVastTrackersForUrls(list);
            this.mLandscapeVastCompanionAdConfig.addClickTrackers(list);
            this.mPortraitVastCompanionAdConfig.addClickTrackers(list);
        }
    }

    private void addCompanionAdViewTrackersForUrls(List<String> list) {
        Preconditions.checkNotNull(list);
        if (this.hasCompanionAd()) {
            list = this.createVastTrackersForUrls(list);
            this.mLandscapeVastCompanionAdConfig.addCreativeViewTrackers(list);
            this.mPortraitVastCompanionAdConfig.addCreativeViewTrackers(list);
        }
    }

    private void addCompleteTrackersForUrls(List<String> list) {
        Preconditions.checkNotNull(list);
        this.addCompleteTrackers(this.createVastTrackersForUrls(list));
    }

    private void addFractionalTrackersForUrls(List<String> object, float f3) {
        Preconditions.checkNotNull(object);
        ArrayList<VastFractionalProgressTracker> arrayList = new ArrayList<VastFractionalProgressTracker>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(new VastFractionalProgressTracker((String)object.next(), f3));
        }
        this.addFractionalTrackers(arrayList);
    }

    private void addStartTrackersForUrls(List<String> object) {
        Preconditions.checkNotNull(object);
        ArrayList<VastAbsoluteProgressTracker> arrayList = new ArrayList<VastAbsoluteProgressTracker>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(new VastAbsoluteProgressTracker((String)object.next(), 0));
        }
        this.addAbsoluteTrackers(arrayList);
    }

    private List<VastTracker> createVastTrackersForUrls(List<String> object) {
        Preconditions.checkNotNull(object);
        ArrayList<VastTracker> arrayList = new ArrayList<VastTracker>();
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(new VastTracker((String)object.next()));
        }
        return arrayList;
    }

    private void handleClick(final Context context, int n2, final Integer n3) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mClickTrackers, null, (Integer)n2, (String)this.mNetworkMediaFileUrl, (Context)context);
        if (TextUtils.isEmpty((CharSequence)this.mClickThroughUrl)) {
            return;
        }
        new UrlHandler.Builder().withDspCreativeId(this.mDspCreativeId).withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, new UrlAction[]{UrlAction.OPEN_APP_MARKET, UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK}).withResultActions(new UrlHandler.ResultActions(){

            public void urlHandlingFailed(String string2, UrlAction urlAction) {
            }

            public void urlHandlingSucceeded(String string2, UrlAction object) {
                if (object == UrlAction.OPEN_IN_APP_BROWSER) {
                    object = new Bundle();
                    object.putString("URL", string2);
                    object.putString("mopub-dsp-creative-id", VastVideoConfig.this.mDspCreativeId);
                    string2 = Intents.getStartActivityIntent((Context)context, MoPubBrowser.class, (Bundle)object);
                    try {
                        if (context instanceof Activity) {
                            Preconditions.checkNotNull((Object)n3);
                            ((Activity)context).startActivityForResult((Intent)string2, n3.intValue());
                        } else {
                            Intents.startActivity((Context)context, (Intent)string2);
                        }
                    }
                    catch (IntentNotResolvableException intentNotResolvableException) {
                        MoPubLog.SdkLogEvent sdkLogEvent = MoPubLog.SdkLogEvent.CUSTOM;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Activity ");
                        ((StringBuilder)object).append(MoPubBrowser.class.getName());
                        ((StringBuilder)object).append(" not found. Did you declare it in your AndroidManifest.xml?");
                        MoPubLog.log((MoPubLog.MPLogEventType)sdkLogEvent, (Object[])new Object[]{((StringBuilder)object).toString()});
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        object = MoPubLog.SdkLogEvent.CUSTOM;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Activity ");
                        stringBuilder.append(MoPubBrowser.class.getName());
                        stringBuilder.append(" not found. Did you declare it in your AndroidManifest.xml?");
                        MoPubLog.log((MoPubLog.MPLogEventType)object, (Object[])new Object[]{stringBuilder.toString()});
                    }
                }
            }
        }).withoutMoPubBrowser().build().handleUrl(context, this.mClickThroughUrl);
    }

    private List<String> hydrateUrls(String string2, JSONArray jSONArray) {
        Preconditions.checkNotNull((Object)jSONArray);
        if (string2 == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
            String string3 = jSONArray.optString(i3);
            if (string3 == null) continue;
            arrayList.add(string3.replace("%%VIDEO_EVENT%%", string2));
        }
        return arrayList;
    }

    public void addAbsoluteTrackers(List<VastAbsoluteProgressTracker> list) {
        Preconditions.checkNotNull(list, (String)"absoluteTrackers cannot be null");
        this.mAbsoluteTrackers.addAll(list);
        Collections.sort(this.mAbsoluteTrackers);
    }

    public void addAvidJavascriptResources(Set<String> set) {
        if (set != null) {
            this.mAvidJavascriptResources.addAll(set);
        }
    }

    public void addClickTrackers(List<VastTracker> list) {
        Preconditions.checkNotNull(list, (String)"clickTrackers cannot be null");
        this.mClickTrackers.addAll(list);
    }

    public void addCloseTrackers(List<VastTracker> list) {
        Preconditions.checkNotNull(list, (String)"closeTrackers cannot be null");
        this.mCloseTrackers.addAll(list);
    }

    public void addCompleteTrackers(List<VastTracker> list) {
        Preconditions.checkNotNull(list, (String)"completeTrackers cannot be null");
        this.mCompleteTrackers.addAll(list);
    }

    public void addErrorTrackers(List<VastTracker> list) {
        Preconditions.checkNotNull(list, (String)"errorTrackers cannot be null");
        this.mErrorTrackers.addAll(list);
    }

    public void addExternalViewabilityTrackers(Map<String, String> map) {
        if (map != null) {
            this.mExternalViewabilityTrackers.putAll(map);
        }
    }

    public void addFractionalTrackers(List<VastFractionalProgressTracker> list) {
        Preconditions.checkNotNull(list, (String)"fractionalTrackers cannot be null");
        this.mFractionalTrackers.addAll(list);
        Collections.sort(this.mFractionalTrackers);
    }

    public void addImpressionTrackers(List<VastTracker> list) {
        Preconditions.checkNotNull(list, (String)"impressionTrackers cannot be null");
        this.mImpressionTrackers.addAll(list);
    }

    public void addMoatImpressionPixels(Set<String> set) {
        if (set != null) {
            this.mMoatImpressionPixels.addAll(set);
        }
    }

    public void addPauseTrackers(List<VastTracker> list) {
        Preconditions.checkNotNull(list, (String)"pauseTrackers cannot be null");
        this.mPauseTrackers.addAll(list);
    }

    public void addResumeTrackers(List<VastTracker> list) {
        Preconditions.checkNotNull(list, (String)"resumeTrackers cannot be null");
        this.mResumeTrackers.addAll(list);
    }

    public void addSkipTrackers(List<VastTracker> list) {
        Preconditions.checkNotNull(list, (String)"skipTrackers cannot be null");
        this.mSkipTrackers.addAll(list);
    }

    public void addVideoTrackers(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("urls");
        jSONObject = jSONObject.optJSONArray("events");
        if (jSONArray != null && jSONObject != null) {
            block9: for (int i3 = 0; i3 < jSONObject.length(); ++i3) {
                String string2 = jSONObject.optString(i3);
                Object object = this.hydrateUrls(string2, jSONArray);
                VideoTrackingEvent videoTrackingEvent = VideoTrackingEvent.Companion.fromString(string2);
                if (string2 == null || object == null) continue;
                switch (2.$SwitchMap$com$mopub$mobileads$VideoTrackingEvent[videoTrackingEvent.ordinal()]) {
                    default: {
                        videoTrackingEvent = MoPubLog.SdkLogEvent.CUSTOM;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Encountered unknown video tracking event: ");
                        ((StringBuilder)object).append(string2);
                        MoPubLog.log((MoPubLog.MPLogEventType)videoTrackingEvent, (Object[])new Object[]{((StringBuilder)object).toString()});
                        continue block9;
                    }
                    case 7: {
                        this.addCompanionAdClickTrackersForUrls((List<String>)object);
                        continue block9;
                    }
                    case 6: {
                        this.addCompanionAdViewTrackersForUrls((List<String>)object);
                        continue block9;
                    }
                    case 5: {
                        this.addCompleteTrackersForUrls((List<String>)object);
                        continue block9;
                    }
                    case 4: {
                        this.addFractionalTrackersForUrls((List<String>)object, 0.75f);
                        continue block9;
                    }
                    case 3: {
                        this.addFractionalTrackersForUrls((List<String>)object, 0.5f);
                        continue block9;
                    }
                    case 2: {
                        this.addFractionalTrackersForUrls((List<String>)object, 0.25f);
                        continue block9;
                    }
                    case 1: {
                        this.addStartTrackersForUrls((List<String>)object);
                    }
                }
            }
        }
    }

    public ArrayList<VastAbsoluteProgressTracker> getAbsoluteTrackers() {
        return this.mAbsoluteTrackers;
    }

    public Set<String> getAvidJavascriptResources() {
        return this.mAvidJavascriptResources;
    }

    public String getClickThroughUrl() {
        return this.mClickThroughUrl;
    }

    public List<VastTracker> getClickTrackers() {
        return this.mClickTrackers;
    }

    public List<VastTracker> getCloseTrackers() {
        return this.mCloseTrackers;
    }

    public List<VastTracker> getCompleteTrackers() {
        return this.mCompleteTrackers;
    }

    public String getCustomCloseIconUrl() {
        return this.mCustomCloseIconUrl;
    }

    public String getCustomCtaText() {
        return this.mCustomCtaText;
    }

    public String getCustomSkipText() {
        return this.mCustomSkipText;
    }

    public String getDiskMediaFileUrl() {
        return this.mDiskMediaFileUrl;
    }

    public String getDspCreativeId() {
        return this.mDspCreativeId;
    }

    public List<VastTracker> getErrorTrackers() {
        return this.mErrorTrackers;
    }

    public Map<String, String> getExternalViewabilityTrackers() {
        return this.mExternalViewabilityTrackers;
    }

    public ArrayList<VastFractionalProgressTracker> getFractionalTrackers() {
        return this.mFractionalTrackers;
    }

    public List<VastTracker> getImpressionTrackers() {
        return this.mImpressionTrackers;
    }

    public Set<String> getMoatImpressionPixels() {
        return this.mMoatImpressionPixels;
    }

    public String getNetworkMediaFileUrl() {
        return this.mNetworkMediaFileUrl;
    }

    public List<VastTracker> getPauseTrackers() {
        return this.mPauseTrackers;
    }

    public String getPrivacyInformationIconClickthroughUrl() {
        return this.mPrivacyInformationIconClickthroughUrl;
    }

    public String getPrivacyInformationIconImageUrl() {
        return this.mPrivacyInformationIconImageUrl;
    }

    public int getRemainingProgressTrackerCount() {
        return this.getUntriggeredTrackersBefore(Integer.MAX_VALUE, Integer.MAX_VALUE).size();
    }

    public List<VastTracker> getResumeTrackers() {
        return this.mResumeTrackers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer getSkipOffsetMillis(int n2) {
        block4: {
            Object object;
            block3: {
                block2: {
                    object = this.mSkipOffset;
                    if (object == null) return null;
                    if (!VastAbsoluteProgressTracker.isAbsoluteTracker((String)object)) break block2;
                    object = VastAbsoluteProgressTracker.parseAbsoluteOffset((String)this.mSkipOffset);
                    break block3;
                }
                if (!VastFractionalProgressTrackerTwo.Companion.isPercentageTracker(this.mSkipOffset)) break block4;
                float f3 = Float.parseFloat(this.mSkipOffset.replace("%", "")) / 100.0f;
                object = Math.round((float)n2 * f3);
            }
            if (object == null) return null;
            if ((Integer)object >= n2) return n2;
            return object;
        }
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{String.format("Invalid VAST skipoffset format: %s", this.mSkipOffset)});
        return null;
    }

    public String getSkipOffsetString() {
        return this.mSkipOffset;
    }

    public List<VastTracker> getSkipTrackers() {
        return this.mSkipTrackers;
    }

    public List<VastTracker> getUntriggeredTrackersBefore(int n2, int n3) {
        int n4 = 0;
        boolean bl = n3 > 0;
        if (Preconditions.NoThrow.checkArgument((boolean)bl) && n2 >= 0) {
            VastAbsoluteProgressTracker vastAbsoluteProgressTracker;
            float f3 = (float)n2 / (float)n3;
            ArrayList<VastTracker> arrayList = new ArrayList<VastTracker>();
            VastAbsoluteProgressTracker vastAbsoluteProgressTracker2 = new VastAbsoluteProgressTracker("", n2);
            n3 = this.mAbsoluteTrackers.size();
            for (n2 = 0; n2 < n3 && (vastAbsoluteProgressTracker = this.mAbsoluteTrackers.get(n2)).compareTo(vastAbsoluteProgressTracker2) <= 0; ++n2) {
                if (vastAbsoluteProgressTracker.isTracked()) continue;
                arrayList.add((VastTracker)vastAbsoluteProgressTracker);
            }
            vastAbsoluteProgressTracker2 = new VastFractionalProgressTracker("", f3);
            n3 = this.mFractionalTrackers.size();
            for (n2 = n4; n2 < n3 && (vastAbsoluteProgressTracker = this.mFractionalTrackers.get(n2)).compareTo((VastFractionalProgressTracker)vastAbsoluteProgressTracker2) <= 0; ++n2) {
                if (vastAbsoluteProgressTracker.isTracked()) continue;
                arrayList.add((VastTracker)vastAbsoluteProgressTracker);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public VastCompanionAdConfig getVastCompanionAd(int n2) {
        if (n2 != 1) {
            if (n2 != 2) {
                return this.mLandscapeVastCompanionAdConfig;
            }
            return this.mLandscapeVastCompanionAdConfig;
        }
        return this.mPortraitVastCompanionAdConfig;
    }

    public VastIconConfig getVastIconConfig() {
        return this.mVastIconConfig;
    }

    public VideoViewabilityTracker getVideoViewabilityTracker() {
        return this.mVideoViewabilityTracker;
    }

    public void handleClickForResult(Activity activity, int n2, int n3) {
        this.handleClick((Context)activity, n2, n3);
    }

    public void handleClickWithoutResult(Context context, int n2) {
        this.handleClick(context.getApplicationContext(), n2, null);
    }

    public void handleClose(Context context, int n2) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mCloseTrackers, null, (Integer)n2, (String)this.mNetworkMediaFileUrl, (Context)context);
    }

    public void handleComplete(Context context, int n2) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mCompleteTrackers, null, (Integer)n2, (String)this.mNetworkMediaFileUrl, (Context)context);
    }

    public void handleError(Context context, VastErrorCode vastErrorCode, int n2) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mErrorTrackers, (VastErrorCode)vastErrorCode, (Integer)n2, (String)this.mNetworkMediaFileUrl, (Context)context);
    }

    public void handleImpression(Context context, int n2) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mImpressionTrackers, null, (Integer)n2, (String)this.mNetworkMediaFileUrl, (Context)context);
    }

    public void handlePause(Context context, int n2) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mPauseTrackers, null, (Integer)n2, (String)this.mNetworkMediaFileUrl, (Context)context);
    }

    public void handleResume(Context context, int n2) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mResumeTrackers, null, (Integer)n2, (String)this.mNetworkMediaFileUrl, (Context)context);
    }

    public void handleSkip(Context context, int n2) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        TrackingRequest.makeVastTrackingHttpRequest(this.mSkipTrackers, null, (Integer)n2, (String)this.mNetworkMediaFileUrl, (Context)context);
    }

    public boolean hasCompanionAd() {
        boolean bl = this.mLandscapeVastCompanionAdConfig != null && this.mPortraitVastCompanionAdConfig != null;
        return bl;
    }

    public boolean isRewardedVideo() {
        return this.mIsRewardedVideo;
    }

    public void setClickThroughUrl(String string2) {
        this.mClickThroughUrl = string2;
    }

    public void setCustomCloseIconUrl(String string2) {
        if (string2 != null) {
            this.mCustomCloseIconUrl = string2;
        }
    }

    public void setCustomCtaText(String string2) {
        if (string2 != null) {
            this.mCustomCtaText = string2;
        }
    }

    public void setCustomSkipText(String string2) {
        if (string2 != null) {
            this.mCustomSkipText = string2;
        }
    }

    public void setDiskMediaFileUrl(String string2) {
        this.mDiskMediaFileUrl = string2;
    }

    public void setDspCreativeId(String string2) {
        this.mDspCreativeId = string2;
    }

    public void setIsRewardedVideo(boolean bl) {
        this.mIsRewardedVideo = bl;
    }

    public void setNetworkMediaFileUrl(String string2) {
        this.mNetworkMediaFileUrl = string2;
    }

    public void setPrivacyInformationIconClickthroughUrl(String string2) {
        this.mPrivacyInformationIconClickthroughUrl = string2;
    }

    public void setPrivacyInformationIconImageUrl(String string2) {
        this.mPrivacyInformationIconImageUrl = string2;
    }

    public void setSkipOffset(String string2) {
        if (string2 != null) {
            this.mSkipOffset = string2;
        }
    }

    public void setVastCompanionAd(VastCompanionAdConfig vastCompanionAdConfig, VastCompanionAdConfig vastCompanionAdConfig2) {
        this.mLandscapeVastCompanionAdConfig = vastCompanionAdConfig;
        this.mPortraitVastCompanionAdConfig = vastCompanionAdConfig2;
    }

    public void setVastIconConfig(VastIconConfig vastIconConfig) {
        this.mVastIconConfig = vastIconConfig;
    }

    public void setVideoViewabilityTracker(VideoViewabilityTracker videoViewabilityTracker) {
        if (videoViewabilityTracker != null) {
            this.mVideoViewabilityTracker = videoViewabilityTracker;
        }
    }
}

