/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Dips;
import com.mopub.mobileads.VastVideoCloseButtonWidget;
import com.mopub.mobileads.resource.CloseButtonDrawable;
import com.mopub.mobileads.resource.DrawableConstants;
import com.mopub.network.Networking;
import com.mopub.volley.toolbox.ImageLoader;

public class VastVideoCloseButtonWidget
extends RelativeLayout {
    private CloseButtonDrawable mCloseButtonDrawable;
    private final int mEdgePadding;
    private final ImageLoader mImageLoader;
    private final int mImagePadding;
    private ImageView mImageView;
    private final int mTextRightMargin;
    private TextView mTextView;
    private final int mWidgetHeight;

    public VastVideoCloseButtonWidget(Context context) {
        super(context);
        this.setId(View.generateViewId());
        this.mEdgePadding = Dips.dipsToIntPixels((float)6.0f, (Context)context);
        this.mImagePadding = Dips.dipsToIntPixels((float)15.0f, (Context)context);
        this.mWidgetHeight = Dips.dipsToIntPixels((float)56.0f, (Context)context);
        this.mTextRightMargin = Dips.dipsToIntPixels((float)0.0f, (Context)context);
        this.mCloseButtonDrawable = new CloseButtonDrawable();
        this.mImageLoader = Networking.getImageLoader((Context)context);
        this.createImageView();
        this.createTextView();
        context = new RelativeLayout.LayoutParams(-2, this.mWidgetHeight);
        context.addRule(11);
        this.setLayoutParams((ViewGroup.LayoutParams)context);
    }

    static /* synthetic */ ImageView access$000(VastVideoCloseButtonWidget vastVideoCloseButtonWidget) {
        return vastVideoCloseButtonWidget.mImageView;
    }

    private void createImageView() {
        ImageView imageView;
        this.mImageView = imageView = new ImageView(this.getContext());
        imageView.setId(View.generateViewId());
        int n2 = this.mWidgetHeight;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n2, n2);
        layoutParams.addRule(11);
        this.mImageView.setImageDrawable((Drawable)this.mCloseButtonDrawable);
        imageView = this.mImageView;
        n2 = this.mImagePadding;
        int n3 = this.mEdgePadding;
        imageView.setPadding(n2, n2 + n3, n3 + n2, n2);
        this.addView((View)this.mImageView, (ViewGroup.LayoutParams)layoutParams);
    }

    private void createTextView() {
        TextView textView;
        this.mTextView = textView = new TextView(this.getContext());
        textView.setSingleLine();
        this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
        this.mTextView.setTextColor(-1);
        this.mTextView.setTextSize(20.0f);
        this.mTextView.setTypeface(DrawableConstants.CloseButton.TEXT_TYPEFACE);
        this.mTextView.setText((CharSequence)"");
        textView = new RelativeLayout.LayoutParams(-2, -2);
        textView.addRule(15);
        textView.addRule(0, this.mImageView.getId());
        this.mTextView.setPadding(0, this.mEdgePadding, 0, 0);
        textView.setMargins(0, 0, this.mTextRightMargin, 0);
        this.addView((View)this.mTextView, (ViewGroup.LayoutParams)textView);
    }

    @Deprecated
    @VisibleForTesting
    ImageView getImageView() {
        return this.mImageView;
    }

    @Deprecated
    @VisibleForTesting
    TextView getTextView() {
        return this.mTextView;
    }

    @Deprecated
    @VisibleForTesting
    void setImageView(ImageView imageView) {
        this.mImageView = imageView;
    }

    void setOnTouchListenerToContent(View.OnTouchListener onTouchListener) {
        this.mImageView.setOnTouchListener(onTouchListener);
        this.mTextView.setOnTouchListener(onTouchListener);
    }

    void updateCloseButtonIcon(String string2) {
        this.mImageLoader.get(string2, (ImageLoader.ImageListener)new 1(this, string2));
    }

    void updateCloseButtonText(String string2) {
        TextView textView = this.mTextView;
        if (textView != null) {
            textView.setText((CharSequence)string2);
        }
    }
}

