/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.util.Log;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.InterstitialAd;
import com.mopub.mobileads.CustomEventInterstitial;
import com.mopub.mobileads.MoPubErrorCode;
import java.util.Map;

public class GooglePlayServicesInterstitial
extends CustomEventInterstitial {
    public static final String AD_UNIT_ID_KEY = "adUnitID";
    public static final String LOCATION_KEY = "location";
    private InterstitialAd mGoogleInterstitialAd;
    private CustomEventInterstitial.CustomEventInterstitialListener mInterstitialListener;

    private boolean extrasAreValid(Map<String, String> map) {
        return map.containsKey(AD_UNIT_ID_KEY);
    }

    @Deprecated
    InterstitialAd getGoogleInterstitialAd() {
        return this.mGoogleInterstitialAd;
    }

    @Override
    protected void loadInterstitial(Context context, CustomEventInterstitial.CustomEventInterstitialListener object, Map<String, Object> map, Map<String, String> map2) {
        this.mInterstitialListener = object;
        if (this.extrasAreValid(map2)) {
            object = map2.get(AD_UNIT_ID_KEY);
            context = new InterstitialAd(context);
            this.mGoogleInterstitialAd = context;
            context.setAdListener((AdListener)new InterstitialAdListener());
            this.mGoogleInterstitialAd.setAdUnitId((String)object);
            context = new AdRequest.Builder().setRequestAgent("MoPub").build();
            try {
                this.mGoogleInterstitialAd.loadAd((AdRequest)context);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.mInterstitialListener.onInterstitialFailed(MoPubErrorCode.NETWORK_NO_FILL);
            }
            return;
        }
        this.mInterstitialListener.onInterstitialFailed(MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
    }

    @Override
    protected void onInvalidate() {
        InterstitialAd interstitialAd = this.mGoogleInterstitialAd;
        if (interstitialAd != null) {
            interstitialAd.setAdListener(null);
        }
    }

    @Override
    protected void showInterstitial() {
        if (this.mGoogleInterstitialAd.isLoaded()) {
            this.mGoogleInterstitialAd.show();
        } else {
            Log.d((String)"MoPub", (String)"Tried to show a Google Play Services interstitial ad before it finished loading. Please try again.");
        }
    }

    private class InterstitialAdListener
    extends AdListener {
        private InterstitialAdListener() {
        }

        private MoPubErrorCode getMoPubErrorCode(int n2) {
            MoPubErrorCode moPubErrorCode = n2 != 0 ? (n2 != 1 ? (n2 != 2 ? (n2 != 3 ? MoPubErrorCode.UNSPECIFIED : MoPubErrorCode.NO_FILL) : MoPubErrorCode.NO_CONNECTION) : MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR) : MoPubErrorCode.INTERNAL_ERROR;
            return moPubErrorCode;
        }

        public void onAdClosed() {
            Log.d((String)"MoPub", (String)"Google Play Services interstitial ad dismissed.");
            if (GooglePlayServicesInterstitial.this.mInterstitialListener != null) {
                GooglePlayServicesInterstitial.this.mInterstitialListener.onInterstitialDismissed();
            }
        }

        public void onAdFailedToLoad(int n2) {
            Log.d((String)"MoPub", (String)"Google Play Services interstitial ad failed to load.");
            if (GooglePlayServicesInterstitial.this.mInterstitialListener != null) {
                GooglePlayServicesInterstitial.this.mInterstitialListener.onInterstitialFailed(this.getMoPubErrorCode(n2));
            }
        }

        public void onAdLeftApplication() {
            Log.d((String)"MoPub", (String)"Google Play Services interstitial ad clicked.");
            if (GooglePlayServicesInterstitial.this.mInterstitialListener != null) {
                GooglePlayServicesInterstitial.this.mInterstitialListener.onInterstitialClicked();
            }
        }

        public void onAdLoaded() {
            Log.d((String)"MoPub", (String)"Google Play Services interstitial ad loaded successfully.");
            if (GooglePlayServicesInterstitial.this.mInterstitialListener != null) {
                GooglePlayServicesInterstitial.this.mInterstitialListener.onInterstitialLoaded();
            }
        }

        public void onAdOpened() {
            Log.d((String)"MoPub", (String)"Showing Google Play Services interstitial ad.");
            if (GooglePlayServicesInterstitial.this.mInterstitialListener != null) {
                GooglePlayServicesInterstitial.this.mInterstitialListener.onInterstitialShown();
            }
        }
    }
}

