/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import android.text.TextUtils;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.BidderTokenProvider;
import com.mopub.common.BaseAdapterConfiguration;
import com.mopub.common.OnNetworkInitializationFinishedListener;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.MoPubErrorCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FacebookAdapterConfiguration
extends BaseAdapterConfiguration {
    private static final String ADAPTER_VERSION = "5.10.1.0";
    private static final String MOPUB_NETWORK_NAME = "facebook";
    private static final String NATIVE_BANNER_KEY = "native_banner";
    private static final String PLACEMENT_IDS_KEY = "placement_ids";
    private static final String SDK_VERSION = "5.10.1";
    private static Boolean isNativeBanner;
    private AtomicBoolean isComputingToken;
    private AtomicReference<String> tokenReference = new AtomicReference<Object>(null);

    public FacebookAdapterConfiguration() {
        this.isComputingToken = new AtomicBoolean(false);
    }

    public static Boolean getNativeBannerPref() {
        return isNativeBanner;
    }

    private void refreshBidderToken(final Context context) {
        if (this.isComputingToken.compareAndSet(false, true)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String string2 = BidderTokenProvider.getBidderToken((Context)context);
                    if (string2 != null) {
                        FacebookAdapterConfiguration.this.tokenReference.set(string2);
                    }
                    FacebookAdapterConfiguration.this.isComputingToken.set(false);
                }
            }).start();
        }
    }

    private static void setNativeBannerPref(Boolean bl) {
        isNativeBanner = bl;
    }

    public String getAdapterVersion() {
        return ADAPTER_VERSION;
    }

    public String getBiddingToken(Context context) {
        Preconditions.checkNotNull((Object)context);
        this.refreshBidderToken(context);
        return this.tokenReference.get();
    }

    public String getMoPubNetworkName() {
        return MOPUB_NETWORK_NAME;
    }

    public String getNetworkSdkVersion() {
        return SDK_VERSION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initializeNetwork(Context context, Map<String, String> object, OnNetworkInitializationFinishedListener onNetworkInitializationFinishedListener) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)onNetworkInitializationFinishedListener);
        synchronized (FacebookAdapterConfiguration.class) {
            try {
                ArrayList arrayList;
                this.tokenReference.set(BidderTokenProvider.getBidderToken((Context)context));
                Object object2 = arrayList = new ArrayList();
                if (object != null) {
                    object2 = arrayList;
                    if (!object.isEmpty()) {
                        object2 = object.get(PLACEMENT_IDS_KEY);
                        if (!TextUtils.isEmpty((CharSequence)object2)) {
                            arrayList = Arrays.asList(((String)object2).split("\\s*,\\s*"));
                        }
                        isNativeBanner = object = Boolean.valueOf(object.get(NATIVE_BANNER_KEY));
                        FacebookAdapterConfiguration.setNativeBannerPref((Boolean)object);
                        object2 = arrayList;
                    }
                }
                if (!AudienceNetworkAds.isInitialized((Context)context)) {
                    AudienceNetworkAds.buildInitSettings((Context)context).withPlacementIds(object2).withMediationService("MOPUB_5.13.1:5.10.1.0").initialize();
                }
            }
            catch (Throwable throwable) {
                MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.AdapterLogEvent.CUSTOM_WITH_THROWABLE, (Object[])new Object[]{"Initializing Facebook Audience Network has encountered an exception.", throwable});
            }
        }
        onNetworkInitializationFinishedListener.onNetworkInitializationFinished(FacebookAdapterConfiguration.class, MoPubErrorCode.ADAPTER_INITIALIZATION_SUCCESS);
    }
}

