/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import com.mopub.common.BaseUrlGenerator;
import com.mopub.common.ClientMetadata;

class ConversionUrlGenerator
extends BaseUrlGenerator {
    private static final String PACKAGE_NAME_KEY = "id";
    private static final String SESSION_TRACKER_KEY = "st";
    private String mConsentedPrivacyPolicyVersion;
    private String mConsentedVendorListVersion;
    private Context mContext;
    private String mCurrentConsentStatus;
    private boolean mForceGdprApplies;
    private Boolean mGdprApplies;
    private boolean mSt;

    ConversionUrlGenerator(Context context) {
        this.mContext = context;
    }

    public String generateUrlString(String string2) {
        ClientMetadata clientMetadata = ClientMetadata.getInstance((Context)this.mContext);
        this.initUrlString(string2, "/m/open");
        this.setApiVersion("6");
        this.setAppVersion(clientMetadata.getAppVersion());
        this.appendAdvertisingInfoTemplates();
        this.addParam(PACKAGE_NAME_KEY, this.mContext.getPackageName());
        if (this.mSt) {
            this.addParam(SESSION_TRACKER_KEY, true);
        }
        this.addParam("nv", "5.12.0");
        this.appendAppEngineInfo();
        this.appendWrapperVersion();
        this.addParam("current_consent_status", this.mCurrentConsentStatus);
        this.addParam("consented_vendor_list_version", this.mConsentedVendorListVersion);
        this.addParam("consented_privacy_policy_version", this.mConsentedPrivacyPolicyVersion);
        this.addParam("gdpr_applies", this.mGdprApplies);
        this.addParam("force_gdpr_applies", this.mForceGdprApplies);
        return this.getFinalUrlString();
    }

    public ConversionUrlGenerator withConsentedPrivacyPolicyVersion(String string2) {
        this.mConsentedPrivacyPolicyVersion = string2;
        return this;
    }

    public ConversionUrlGenerator withConsentedVendorListVersion(String string2) {
        this.mConsentedVendorListVersion = string2;
        return this;
    }

    public ConversionUrlGenerator withCurrentConsentStatus(String string2) {
        this.mCurrentConsentStatus = string2;
        return this;
    }

    public ConversionUrlGenerator withForceGdprApplies(boolean bl) {
        this.mForceGdprApplies = bl;
        return this;
    }

    public ConversionUrlGenerator withGdprApplies(Boolean bl) {
        this.mGdprApplies = bl;
        return this;
    }

    public ConversionUrlGenerator withSessionTracker(boolean bl) {
        this.mSt = bl;
        return this;
    }
}

