/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import com.mopub.common.VisibleForTesting;
import com.mopub.common.util.Views;
import com.mopub.mobileads.util.WebViews;

public class BaseWebView
extends WebView {
    private static boolean sDeadlockCleared;
    protected boolean mIsDestroyed;

    public BaseWebView(Context context) {
        super(context.getApplicationContext());
        this.restrictDeviceContentAccess();
        WebViews.setDisableJSChromeClient((WebView)this);
        if (!sDeadlockCleared) {
            this.clearWebViewDeadlock(this.getContext());
            sDeadlockCleared = true;
        }
    }

    private void clearWebViewDeadlock(Context context) {
        if (Build.VERSION.SDK_INT == 19) {
            WebView webView = new WebView(context.getApplicationContext());
            webView.setBackgroundColor(0);
            webView.loadDataWithBaseURL(null, "", "text/html", "UTF-8", null);
            WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
            layoutParams.width = 1;
            layoutParams.height = 1;
            layoutParams.type = 2005;
            layoutParams.flags = 0x1000018;
            layoutParams.format = -2;
            layoutParams.gravity = 0x800033;
            ((WindowManager)context.getSystemService("window")).addView((View)webView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void restrictDeviceContentAccess() {
        this.getSettings().setAllowFileAccess(false);
        this.getSettings().setAllowContentAccess(false);
        this.getSettings().setAllowFileAccessFromFileURLs(false);
        this.getSettings().setAllowUniversalAccessFromFileURLs(false);
    }

    public void destroy() {
        if (this.mIsDestroyed) {
            return;
        }
        this.mIsDestroyed = true;
        Views.removeFromParent((View)this);
        this.removeAllViews();
        super.destroy();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void enableJavascriptCaching() {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setDomStorageEnabled(true);
        this.getSettings().setAppCacheEnabled(true);
        this.getSettings().setAppCachePath(this.getContext().getCacheDir().getAbsolutePath());
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        WebViews.manageThirdPartyCookies((WebView)this);
    }

    @Deprecated
    @VisibleForTesting
    void setIsDestroyed(boolean bl) {
        this.mIsDestroyed = bl;
    }
}

