/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.mobileads.BaseBroadcastReceiver;

public abstract class BaseVideoViewController {
    private final BaseVideoViewControllerListener mBaseVideoViewControllerListener;
    private Long mBroadcastIdentifier;
    private final Context mContext;
    private final RelativeLayout mLayout;

    protected BaseVideoViewController(Context context, Long l3, BaseVideoViewControllerListener baseVideoViewControllerListener) {
        Preconditions.checkNotNull((Object)baseVideoViewControllerListener);
        this.mContext = context;
        this.mBroadcastIdentifier = l3;
        this.mBaseVideoViewControllerListener = baseVideoViewControllerListener;
        this.mLayout = new RelativeLayout(this.mContext);
    }

    public boolean backButtonEnabled() {
        return true;
    }

    void broadcastAction(String string2) {
        Long l3 = this.mBroadcastIdentifier;
        if (l3 != null) {
            BaseBroadcastReceiver.broadcastAction(this.mContext, l3, string2);
        } else {
            MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Tried to broadcast a video event without a broadcast identifier to send to."});
        }
    }

    protected BaseVideoViewControllerListener getBaseVideoViewControllerListener() {
        return this.mBaseVideoViewControllerListener;
    }

    protected Context getContext() {
        return this.mContext;
    }

    public ViewGroup getLayout() {
        return this.mLayout;
    }

    protected abstract View getVideoView();

    void onActivityResult(int n2, int n3, Intent intent) {
    }

    protected abstract void onBackPressed();

    protected abstract void onConfigurationChanged(Configuration var1);

    protected void onCreate() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.mLayout.addView(this.getVideoView(), 0, (ViewGroup.LayoutParams)layoutParams);
        this.mBaseVideoViewControllerListener.onSetContentView((View)this.mLayout);
    }

    protected abstract void onDestroy();

    protected abstract void onPause();

    protected abstract void onResume();

    protected abstract void onSaveInstanceState(Bundle var1);

    protected void videoCompleted(boolean bl) {
        if (bl) {
            this.mBaseVideoViewControllerListener.onFinish();
        }
    }

    protected void videoError(boolean bl) {
        MoPubLog.log((MoPubLog.MPLogEventType)MoPubLog.SdkLogEvent.CUSTOM, (Object[])new Object[]{"Video cannot be played."});
        this.broadcastAction("com.mopub.action.interstitial.fail");
        if (bl) {
            this.mBaseVideoViewControllerListener.onFinish();
        }
    }

    public static interface BaseVideoViewControllerListener {
        public void onFinish();

        public void onSetContentView(View var1);

        public void onSetRequestedOrientation(int var1);

        public void onStartActivityForResult(Class<? extends Activity> var1, int var2, Bundle var3);
    }
}

