/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.mopub.common.Preconditions;

public abstract class BaseBroadcastReceiver
extends BroadcastReceiver {
    private final long mBroadcastIdentifier;
    private Context mContext;

    public BaseBroadcastReceiver(long l3) {
        this.mBroadcastIdentifier = l3;
    }

    public static void broadcastAction(Context context, long l3, String string2) {
        Preconditions.checkNotNull((Object)context, (String)"context cannot be null");
        Preconditions.checkNotNull((Object)string2, (String)"action cannot be null");
        string2 = new Intent(string2);
        string2.putExtra("broadcastIdentifier", l3);
        LocalBroadcastManager.getInstance((Context)context.getApplicationContext()).sendBroadcast((Intent)string2);
    }

    public abstract IntentFilter getIntentFilter();

    public void register(BroadcastReceiver broadcastReceiver, Context context) {
        this.mContext = context;
        LocalBroadcastManager.getInstance((Context)context).registerReceiver(broadcastReceiver, this.getIntentFilter());
    }

    public boolean shouldConsumeBroadcast(Intent intent) {
        Preconditions.checkNotNull((Object)intent, (String)"intent cannot be null");
        long l3 = intent.getLongExtra("broadcastIdentifier", -1L);
        boolean bl = this.mBroadcastIdentifier == l3;
        return bl;
    }

    public void unregister(BroadcastReceiver broadcastReceiver) {
        Context context = this.mContext;
        if (context != null && broadcastReceiver != null) {
            LocalBroadcastManager.getInstance((Context)context).unregisterReceiver(broadcastReceiver);
            this.mContext = null;
        }
    }
}

