/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.mobileads;

import android.content.Context;
import com.mopub.common.AdFormat;
import com.mopub.common.Preconditions;
import com.mopub.network.AdLoader;
import com.mopub.network.AdResponse;
import com.mopub.network.MultiAdResponse;
import com.mopub.network.SingleImpression;
import com.mopub.network.TrackingRequest;
import java.util.Collections;
import java.util.List;

class AdLoaderRewardedVideo
extends AdLoader {
    private boolean mClickTrackerFired = false;
    private boolean mImpressionTrackerFired = false;

    AdLoaderRewardedVideo(String string2, AdFormat adFormat, String string3, Context context, AdLoader.Listener listener) {
        super(string2, adFormat, string3, context, listener);
    }

    String getClickUrl() {
        AdResponse adResponse = this.mLastDeliveredResponse;
        if (adResponse != null) {
            return adResponse.getClickTrackingUrl();
        }
        return null;
    }

    String getFailurl() {
        MultiAdResponse multiAdResponse = this.mMultiAdResponse;
        if (multiAdResponse != null) {
            return multiAdResponse.getFailURL();
        }
        return null;
    }

    List<String> getImpressionUrls() {
        AdResponse adResponse = this.mLastDeliveredResponse;
        if (adResponse != null) {
            return adResponse.getImpressionTrackingUrls();
        }
        return Collections.emptyList();
    }

    AdResponse getLastDeliveredResponse() {
        return this.mLastDeliveredResponse;
    }

    void trackClick(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (this.mLastDeliveredResponse != null && !this.mClickTrackerFired) {
            this.mClickTrackerFired = true;
            TrackingRequest.makeTrackingHttpRequest((String)this.getClickUrl(), (Context)context);
        }
    }

    void trackImpression(Context context) {
        Preconditions.checkNotNull((Object)context);
        if (this.mLastDeliveredResponse != null && !this.mImpressionTrackerFired) {
            this.mImpressionTrackerFired = true;
            TrackingRequest.makeTrackingHttpRequest(this.getImpressionUrls(), (Context)context);
            new SingleImpression(this.mLastDeliveredResponse.getAdUnitId(), this.mLastDeliveredResponse.getImpressionData()).sendImpression();
        }
    }
}

