/*
 * Decompiled with CFR 0.152.
 */
package com.mobisystems.office.chat.cache;

import androidx.annotation.NonNull;
import androidx.core.util.ObjectsCompat;
import c.b.c.a.a;
import com.mobisystems.office.chat.cache.Chat;
import com.mobisystems.office.chat.cache.Event;
import com.mobisystems.office.chat.cache.EventFile;
import com.mobisystems.office.chat.cache.File;
import com.mobisystems.office.chat.cache.Profile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Utils {
    public static /* synthetic */ String access$000(String string2, String string3) {
        return Utils.createFileIdString(string2, string3);
    }

    public static <K, V> boolean areSame(HashMap<K, V> object, HashMap<K, V> hashMap, Comparator<V> comparator) {
        for (Map.Entry entry : ((HashMap)((Object)object)).entrySet()) {
            if (comparator.compare(entry.getValue(), hashMap.remove(entry.getKey())) == 0) continue;
            return false;
        }
        return hashMap.isEmpty();
    }

    public static Chat copyChat(Chat chat) {
        Chat chat2 = new Chat();
        chat2.setServerId(chat.getServerId());
        chat2.setChatId(chat.getChatId());
        if (chat.getDateCreated() != null) {
            chat2.setDateCreated(new Date(chat.getDateCreated().getTime()));
        }
        if (chat.getMembers() != null) {
            ArrayList<Profile> arrayList = new ArrayList<Profile>();
            Iterator<Profile> iterator = chat.getMembers().iterator();
            while (iterator.hasNext()) {
                arrayList.add(Utils.copyProfile(iterator.next()));
            }
            chat2.setMembers(arrayList);
        }
        chat2.setDirty(chat.isDirty());
        chat2.setPersonal(chat.isPersonal());
        chat2.setNumOfNewEvents(chat.getNumOfNewEvents());
        if (chat.getNewestEventDate() != null) {
            chat2.setNewestEventDate(new Date(chat.getNewestEventDate().getTime()));
        }
        if (chat.getLastActiveDate() != null) {
            chat2.setLastActiveDate(new Date(chat.getLastActiveDate().getTime()));
        }
        chat2.setCreatorId(chat.getCreatorId());
        chat2.setTotalMembersCount(chat.getTotalMembersCount());
        chat2.setName(chat.getName());
        chat2.setPhotoURL(chat.getPhotoURL());
        if (chat.getMuteDate() != null) {
            chat2.setMuteDate(new Date(chat.getMuteDate().getTime()));
        }
        if (chat.getClearedContentDate() != null) {
            chat2.setClearedContentDate(new Date(chat.getClearedContentDate().getTime()));
        }
        if (chat.getHiddenDate() != null) {
            chat2.setHiddenDate(new Date(chat.getHiddenDate().getTime()));
        }
        if (chat.getDeletedDate() != null) {
            chat2.setDeletedDate(new Date(chat.getDeletedDate().getTime()));
        }
        if (chat.getAddedByUnknownAccount() != null) {
            chat2.setAddedByUnknownAccount(Utils.copyProfile(chat.getAddedByUnknownAccount()));
        }
        if (chat.getLastEvent() != null) {
            chat2.setLastEvent(Utils.copyEvent(chat.getLastEvent()));
        }
        chat2.setFirstTimeOpen(chat.isFirstTimeOpen());
        return chat2;
    }

    public static Event copyEvent(Event event) {
        ArrayList<Profile> arrayList;
        Event event2 = new Event();
        event2.setEventId(event.getEventId());
        event2.setServerId(event.getServerId());
        event2.setChatId(event.getChatId());
        event2.setMessage(event.getMessage());
        event2.setEventType(event.getEventType());
        if (event.getDateRemoved() != null) {
            event2.setDateRemoved(new Date(event.getDateRemoved().getTime()));
        }
        if (event.getDate() != null) {
            event2.setDate(new Date(event.getDate().getTime()));
        }
        if (event.getPayload() != null) {
            HashMap<String, String> object = new HashMap<String, String>();
            for (Map.Entry entry : event.getPayload().entrySet()) {
                object.put((String)entry.getKey(), (String)entry.getValue());
            }
            event2.setPayload(object);
        }
        if (event.getMetadata() != null) {
            arrayList = new HashMap();
            for (Map.Entry<String, String> entry : event.getMetadata().entrySet()) {
                ((HashMap)((Object)arrayList)).put(entry.getKey(), entry.getValue());
            }
            event2.setMetadata((HashMap<String, String>)((Object)arrayList));
        }
        if (event.getEventProfiles() != null) {
            arrayList = new ArrayList<Profile>();
            Iterator<Profile> iterator = event.getEventProfiles().iterator();
            while (iterator.hasNext()) {
                arrayList.add(Utils.copyProfile(iterator.next()));
            }
            event2.setEventProfiles(arrayList);
        }
        if (event.getEventFiles() != null) {
            arrayList = new ArrayList();
            Iterator<EventFile> iterator = event.getEventFiles().iterator();
            while (iterator.hasNext()) {
                arrayList.add((Profile)((Object)Utils.copyEventFile(iterator.next())));
            }
            event2.setEventFiles(arrayList);
        }
        if (event.getEventCreator() != null) {
            event2.setEventCreator(Utils.copyProfile(event.getEventCreator()));
        }
        return event2;
    }

    public static EventFile copyEventFile(EventFile eventFile) {
        EventFile eventFile2 = new EventFile();
        eventFile2.setRemoved(eventFile.isRemoved());
        eventFile2.setStreamStatus(eventFile.getStreamStatus());
        eventFile2.setAccess(eventFile.getAccess());
        Utils.copyFile(eventFile2, eventFile);
        return eventFile2;
    }

    public static File copyFile(File file) {
        File file2 = new File();
        Utils.copyFile(file2, file);
        return file2;
    }

    public static void copyFile(File file, File file2) {
        file.setSize(file2.getSize());
        file.setNumRevisions(file2.getNumRevisions());
        file.setAccountId(file2.getAccountId());
        file.setKey(file2.getKey());
        file.setName(file2.getName());
        file.setContentType(file2.getContentType());
        file.setAccessOwn(file2.getAccessOwn());
        file.setAccessParent(file2.getAccessParent());
        file.setHeadRevision(file2.getHeadRevision());
        file.setDescription(file2.getDescription());
        file.setShared(file2.isShared());
        file.setShareInherited(file2.isShareInherited());
        file.setDir(file2.isDir());
        file.setPubliclyShared(file2.isPubliclyShared());
        file.setHasThumbnail(file2.isHasThumbnail());
        if (file2.getDateCreated() != null) {
            file.setDateCreated(new Date(file2.getDateCreated().getTime()));
        }
        if (file2.getDateModified() != null) {
            file.setDateModified(new Date(file2.getDateModified().getTime()));
        }
    }

    public static Profile copyProfile(Profile profile) {
        Profile profile2 = new Profile();
        profile2.setServerId(profile.getServerId());
        profile2.setNativeId(profile.getNativeId());
        profile2.setEmail(profile.getEmail());
        profile2.setPhone(profile.getPhone());
        profile2.setName(profile.getName());
        profile2.setLocalName(profile.getLocalName());
        profile2.setPhotoUrl(profile.getPhotoUrl());
        profile2.setSameSubscription(profile.isSameSubscription());
        profile2.setHasFCWithChats(profile.isHasFCWithChats());
        profile2.setHasOSWithChats(profile.isHasOSWithChats());
        return profile2;
    }

    @NonNull
    public static String createFileIdString(@NonNull String string2, @NonNull String string3) {
        return a.a((String)string2, (String)":", (String)string3);
    }

    public static class ChatsComparator
    implements Comparator<Chat> {
        public EventComparator _eventComparator;
        public ProfilesComparator _profilesComparator = new ProfilesComparator();

        public ChatsComparator() {
            this._eventComparator = new EventComparator();
        }

        @Override
        public int compare(Chat chat, Chat chat2) {
            if (chat == chat2) {
                return 0;
            }
            if (chat != null && chat2 != null) {
                if (!ObjectsCompat.equals((Object)chat.getServerId(), (Object)chat2.getServerId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getChatId(), (Object)chat2.getChatId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getDateCreated(), (Object)chat2.getDateCreated())) {
                    return -1;
                }
                Object object = chat.getMembers();
                List<Profile> object22 = chat2.getMembers();
                Object object2 = object;
                if (object == null) {
                    object2 = new ArrayList<Profile>();
                }
                object = object22;
                if (object22 == null) {
                    object = new ArrayList<Profile>();
                }
                if (!object2.isEmpty() || !object.isEmpty()) {
                    object = new HashMap();
                    object2 = new HashMap();
                    for (Profile profile : chat.getMembers()) {
                        ((HashMap)object).put(profile.getServerId(), profile);
                    }
                    for (Profile profile : chat2.getMembers()) {
                        ((HashMap)object2).put(profile.getServerId(), profile);
                    }
                    if (!Utils.areSame(object, object2, this._profilesComparator)) {
                        return -1;
                    }
                }
                if (!ObjectsCompat.equals((Object)chat.isDirty(), (Object)chat2.isDirty())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.isPersonal(), (Object)chat2.isPersonal())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getNumOfNewEvents(), (Object)chat2.getNumOfNewEvents())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getNewestEventDate(), (Object)chat2.getNewestEventDate())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getLastActiveDate(), (Object)chat2.getLastActiveDate())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getCreatorId(), (Object)chat2.getCreatorId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getTotalMembersCount(), (Object)chat2.getTotalMembersCount())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getName(), (Object)chat2.getName())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getPhotoURL(), (Object)chat2.getPhotoURL())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getMuteDate(), (Object)chat2.getMuteDate())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getClearedContentDate(), (Object)chat2.getClearedContentDate())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getHiddenDate(), (Object)chat2.getHiddenDate())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.getDeletedDate(), (Object)chat2.getDeletedDate())) {
                    return -1;
                }
                if (this._profilesComparator.compare(chat.getAddedByUnknownAccount(), chat2.getAddedByUnknownAccount()) != 0) {
                    return -1;
                }
                if (this._eventComparator.compare(chat.getLastEvent(), chat2.getLastEvent()) != 0) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)chat.isFirstTimeOpen(), (Object)chat2.isFirstTimeOpen())) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }

    public static class EventComparator
    implements Comparator<Event> {
        public EventFileComparator _eventFileComparator;
        public ProfilesComparator _profilesComparator = new ProfilesComparator();

        public EventComparator() {
            this._eventFileComparator = new EventFileComparator();
        }

        @Override
        public int compare(Event object, Event object2) {
            if (object == object2) {
                return 0;
            }
            if (object != null && object2 != null) {
                if (!ObjectsCompat.equals((Object)((Event)object).getServerId(), (Object)((Event)object2).getServerId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)((Event)object).getEventId(), (Object)((Event)object2).getEventId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)((Event)object).getChatId(), (Object)((Event)object2).getChatId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)((Event)object).getMessage(), (Object)((Event)object2).getMessage())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)((Object)((Event)object).getEventType()), (Object)((Object)((Event)object2).getEventType()))) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)((Event)object).getDate(), (Object)((Event)object2).getDate())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)((Event)object).getDateRemoved(), (Object)((Event)object2).getDateRemoved())) {
                    return -1;
                }
                if ((((Event)object).getPayload() != null && !((Event)object).getPayload().isEmpty() || ((Event)object2).getPayload() != null && !((Event)object2).getPayload().isEmpty()) && !ObjectsCompat.equals(((Event)object).getPayload(), ((Event)object2).getPayload())) {
                    return -1;
                }
                if ((((Event)object).getMetadata() != null && !((Event)object).getMetadata().isEmpty() || ((Event)object2).getMetadata() != null && !((Event)object2).getMetadata().isEmpty()) && !ObjectsCompat.equals(((Event)object).getMetadata(), ((Event)object2).getMetadata())) {
                    return -1;
                }
                if (this._profilesComparator.compare(((Event)object).getEventCreator(), ((Event)object2).getEventCreator()) != 0) {
                    return -1;
                }
                HashMap<String, Object> hashMap = ((Event)object).getEventProfiles();
                Iterator iterator = ((Event)object2).getEventProfiles();
                Object object3 = hashMap;
                if (hashMap == null) {
                    object3 = new ArrayList<Profile>();
                }
                hashMap = iterator;
                if (iterator == null) {
                    hashMap = new ArrayList<Profile>();
                }
                if (!object3.isEmpty() || !hashMap.isEmpty()) {
                    iterator = new HashMap();
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    object3 = object3.iterator();
                    while (object3.hasNext()) {
                        Profile profile = (Profile)object3.next();
                        ((HashMap)((Object)iterator)).put(profile.getServerId(), profile);
                    }
                    hashMap = hashMap.iterator();
                    while (hashMap.hasNext()) {
                        object3 = (Profile)hashMap.next();
                        hashMap2.put(((Profile)object3).getServerId(), object3);
                    }
                    if (!Utils.areSame(iterator, hashMap2, this._profilesComparator)) {
                        return -1;
                    }
                }
                hashMap = ((Event)object).getEventFiles();
                object3 = ((Event)object2).getEventFiles();
                object = hashMap;
                if (hashMap == null) {
                    object = new ArrayList();
                }
                object2 = object3;
                if (object3 == null) {
                    object2 = new ArrayList();
                }
                if (!object.isEmpty() || !object2.isEmpty()) {
                    object3 = new HashMap();
                    hashMap = new HashMap<String, Object>();
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        object = (EventFile)iterator.next();
                        ((HashMap)object3).put(Utils.createFileIdString(((File)object).getAccountId(), ((File)object).getKey()), object);
                    }
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        object = (EventFile)object2.next();
                        hashMap.put(Utils.createFileIdString(((File)object).getAccountId(), ((File)object).getKey()), object);
                    }
                    if (!Utils.areSame(object3, hashMap, this._eventFileComparator)) {
                        return -1;
                    }
                }
                return 0;
            }
            return -1;
        }
    }

    public static class EventFileComparator
    implements Comparator<EventFile> {
        public FileComparator _fileComparator = new FileComparator();

        @Override
        public int compare(EventFile eventFile, EventFile eventFile2) {
            int n2 = this._fileComparator.compare(eventFile, eventFile2);
            if (n2 != 0) {
                return n2;
            }
            if (!ObjectsCompat.equals((Object)eventFile.isRemoved(), (Object)eventFile2.isRemoved())) {
                return -1;
            }
            if (!ObjectsCompat.equals((Object)((Object)eventFile.getStreamStatus()), (Object)((Object)eventFile2.getStreamStatus()))) {
                return -1;
            }
            if (!ObjectsCompat.equals((Object)eventFile.getAccess(), (Object)eventFile2.getAccess())) {
                return -1;
            }
            return 0;
        }
    }

    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            if (file == file2) {
                return 0;
            }
            if (file != null && file2 != null) {
                if (!ObjectsCompat.equals((Object)file.getSize(), (Object)file2.getSize())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getNumRevisions(), (Object)file2.getNumRevisions())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getAccountId(), (Object)file2.getAccountId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getKey(), (Object)file2.getKey())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getName(), (Object)file2.getName())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getContentType(), (Object)file2.getContentType())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getAccessOwn(), (Object)file2.getAccessOwn())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getAccessParent(), (Object)file2.getAccessParent())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getHeadRevision(), (Object)file2.getHeadRevision())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getDescription(), (Object)file2.getDescription())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.isShared(), (Object)file2.isShared())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.isShareInherited(), (Object)file2.isShareInherited())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.isDir(), (Object)file2.isDir())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.isPubliclyShared(), (Object)file2.isPubliclyShared())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.isHasThumbnail(), (Object)file2.isHasThumbnail())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getDateCreated(), (Object)file2.getDateCreated())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)file.getDateModified(), (Object)file2.getDateModified())) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }

    public static class ProfilesComparator
    implements Comparator<Profile> {
        @Override
        public int compare(Profile profile, Profile profile2) {
            if (profile == profile2) {
                return 0;
            }
            if (profile != null && profile2 != null) {
                if (!ObjectsCompat.equals((Object)profile.getServerId(), (Object)profile2.getServerId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.getEmail(), (Object)profile2.getEmail())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.getLocalName(), (Object)profile2.getLocalName())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.getName(), (Object)profile2.getName())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.getNativeId(), (Object)profile2.getNativeId())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.getPhone(), (Object)profile2.getPhone())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.getPhotoUrl(), (Object)profile2.getPhotoUrl())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.isHasFCWithChats(), (Object)profile2.isHasFCWithChats())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.isHasOSWithChats(), (Object)profile2.isHasOSWithChats())) {
                    return -1;
                }
                if (!ObjectsCompat.equals((Object)profile.isSameSubscription(), (Object)profile2.isSameSubscription())) {
                    return -1;
                }
                return 0;
            }
            return -1;
        }
    }
}

