/*
 * Decompiled with CFR 0.152.
 */
package com.mobisystems.math;

import android.graphics.Matrix;
import android.graphics.Point;
import com.mobisystems.android.ui.Debug;

public class MathUtils {
    public static float clamp(float f3, float f4, float f5) {
        boolean bl = f4 < f5;
        Debug.assrt((boolean)bl);
        if (!(f3 < f4)) {
            f4 = f3;
            if (f3 > f5) {
                f4 = f5;
            }
        }
        return f4;
    }

    public static boolean equal(double d3, double d4) {
        return MathUtils.equal(d3, d4, 1.0E-6, false);
    }

    public static boolean equal(double d3, double d4, double d5, boolean bl) {
        double d6 = Math.abs(d3 - d4);
        if (d6 < d5) {
            return true;
        }
        return bl && Double.isNaN(d6) && Double.compare(d3, d4) == 0;
    }

    public static double euclideanDistance(int n2, int n3, int n4, int n5) {
        n2 = n4 - n2;
        n3 = n5 - n3;
        return Math.sqrt(n3 * n3 + n2 * n2);
    }

    public static float fixedToFloat(int n2, int n3) {
        return (float)n2 / (float)(1 << n3);
    }

    public static int normalizeAngle(int n2) {
        int n3 = n2;
        if (n2 < 0) {
            n3 = 360 - -n2 % 360;
        }
        n2 = n3;
        if (n3 >= 360) {
            n2 = n3 % 360;
        }
        return n2;
    }

    public static boolean sameFloat(float f3, float f4) {
        return MathUtils.sameFloat(f3, f4, 1.0E-6f);
    }

    public static boolean sameFloat(float f3, float f4, float f5) {
        boolean bl = Math.abs(f3 - f4) < f5;
        return bl;
    }

    public static void transformImageSize(float f3, float f4, Matrix matrix, Point point, float[] fArray) {
        boolean bl = matrix.isIdentity();
        int n2 = 1;
        float f5 = f3;
        float f6 = f4;
        if (!bl) {
            float[] fArray2 = fArray;
            if (fArray == null) {
                fArray2 = new float[]{f3, 0.0f, 0.0f, f4};
            }
            matrix.mapVectors(fArray2, 0, fArray2, 0, 2);
            f4 = fArray2[0];
            f3 = fArray2[0];
            f5 = (float)Math.sqrt(fArray2[1] * fArray2[1] + f4 * f3);
            f4 = fArray2[2];
            f3 = fArray2[2];
            f6 = (float)Math.sqrt(fArray2[3] * fArray2[3] + f4 * f3);
        }
        int n3 = f5 < 1.0f ? 1 : (int)Math.ceil(f5);
        point.x = n3;
        n3 = f6 < 1.0f ? n2 : (int)Math.ceil(f6);
        point.y = n3;
    }
}

