/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util.pool;

import android.util.Log;
import androidx.core.util.Pools;
import com.bumptech.glide.util.pool.StateVerifier;
import java.util.ArrayList;
import java.util.List;

public final class FactoryPools {
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final Resetter<Object> EMPTY_RESETTER = new Resetter<Object>(){

        @Override
        public void reset(Object object) {
        }
    };
    private static final String TAG = "FactoryPools";

    private FactoryPools() {
    }

    private static <T extends Poolable> Pools.Pool<T> build(Pools.Pool<T> pool, Factory<T> factory) {
        return FactoryPools.build(pool, factory, FactoryPools.<T>emptyResetter());
    }

    private static <T> Pools.Pool<T> build(Pools.Pool<T> pool, Factory<T> factory, Resetter<T> resetter) {
        return new FactoryPool<T>(pool, factory, resetter);
    }

    private static <T> Resetter<T> emptyResetter() {
        return EMPTY_RESETTER;
    }

    public static <T extends Poolable> Pools.Pool<T> simple(int n2, Factory<T> factory) {
        return FactoryPools.build(new Pools.SimplePool(n2), factory);
    }

    public static <T extends Poolable> Pools.Pool<T> threadSafe(int n2, Factory<T> factory) {
        return FactoryPools.build(new Pools.SynchronizedPool(n2), factory);
    }

    public static <T> Pools.Pool<List<T>> threadSafeList() {
        return FactoryPools.threadSafeList(20);
    }

    public static <T> Pools.Pool<List<T>> threadSafeList(int n2) {
        return FactoryPools.build(new Pools.SynchronizedPool(n2), new Factory<List<T>>(){

            @Override
            public List<T> create() {
                return new ArrayList();
            }
        }, new Resetter<List<T>>(){

            @Override
            public void reset(List<T> list) {
                list.clear();
            }
        });
    }

    public static interface Factory<T> {
        public T create();
    }

    private static final class FactoryPool<T>
    implements Pools.Pool<T> {
        private final Factory<T> factory;
        private final Pools.Pool<T> pool;
        private final Resetter<T> resetter;

        FactoryPool(Pools.Pool<T> pool, Factory<T> factory, Resetter<T> resetter) {
            this.pool = pool;
            this.factory = factory;
            this.resetter = resetter;
        }

        public T acquire() {
            Object object;
            Object object2 = object = this.pool.acquire();
            if (object == null) {
                object2 = object = this.factory.create();
                if (Log.isLoggable((String)FactoryPools.TAG, (int)2)) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Created new ");
                    ((StringBuilder)object2).append(object.getClass());
                    Log.v((String)FactoryPools.TAG, (String)((StringBuilder)object2).toString());
                    object2 = object;
                }
            }
            if (object2 instanceof Poolable) {
                ((Poolable)object2).getVerifier().setRecycled(false);
            }
            return (T)object2;
        }

        public boolean release(T t2) {
            if (t2 instanceof Poolable) {
                ((Poolable)t2).getVerifier().setRecycled(true);
            }
            this.resetter.reset(t2);
            return this.pool.release(t2);
        }
    }

    public static interface Poolable {
        public StateVerifier getVerifier();
    }

    public static interface Resetter<T> {
        public void reset(T var1);
    }
}

