/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import com.bumptech.glide.load.model.Model;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;

public final class Util {
    private static final int HASH_ACCUMULATOR = 17;
    private static final int HASH_MULTIPLIER = 31;
    private static final char[] HEX_CHAR_ARRAY = "0123456789abcdef".toCharArray();
    private static final char[] SHA_256_CHARS = new char[64];

    private Util() {
    }

    public static void assertBackgroundThread() {
        if (Util.isOnBackgroundThread()) {
            return;
        }
        throw new IllegalArgumentException("You must call this method on a background thread");
    }

    public static void assertMainThread() {
        if (Util.isOnMainThread()) {
            return;
        }
        throw new IllegalArgumentException("You must call this method on the main thread");
    }

    public static boolean bothModelsNullEquivalentOrEquals(Object object, Object object2) {
        if (object == null) {
            boolean bl = object2 == null;
            return bl;
        }
        if (object instanceof Model) {
            return ((Model)object).isEquivalentTo(object2);
        }
        return object.equals(object2);
    }

    public static boolean bothNullOrEqual(Object object, Object object2) {
        boolean bl = object == null ? object2 == null : object.equals(object2);
        return bl;
    }

    private static String bytesToHex(byte[] byArray, char[] cArray) {
        for (int i3 = 0; i3 < byArray.length; ++i3) {
            int n2 = byArray[i3] & 0xFF;
            int n3 = i3 * 2;
            char[] cArray2 = HEX_CHAR_ARRAY;
            cArray[n3] = cArray2[n2 >>> 4];
            cArray[n3 + 1] = cArray2[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static <T> Queue<T> createQueue(int n2) {
        return new ArrayDeque(n2);
    }

    public static int getBitmapByteSize(int n2, int n3, Bitmap.Config config) {
        return n2 * n3 * Util.getBytesPerPixel(config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getBitmapByteSize(Bitmap bitmap2) {
        if (bitmap2.isRecycled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Cannot obtain size for recycled Bitmap: ");
            stringBuilder.append(bitmap2);
            stringBuilder.append("[");
            stringBuilder.append(bitmap2.getWidth());
            stringBuilder.append("x");
            stringBuilder.append(bitmap2.getHeight());
            stringBuilder.append("] ");
            stringBuilder.append(bitmap2.getConfig());
            throw new IllegalStateException(stringBuilder.toString());
        }
        if (Build.VERSION.SDK_INT < 19) return bitmap2.getHeight() * bitmap2.getRowBytes();
        try {
            return bitmap2.getAllocationByteCount();
        }
        catch (NullPointerException nullPointerException) {
            return bitmap2.getHeight() * bitmap2.getRowBytes();
        }
    }

    private static int getBytesPerPixel(Bitmap.Config config) {
        int n2;
        Bitmap.Config config2 = config;
        if (config == null) {
            config2 = Bitmap.Config.ARGB_8888;
        }
        int n3 = 1.$SwitchMap$android$graphics$Bitmap$Config[config2.ordinal()];
        int n4 = 2;
        if (n3 != 1) {
            n2 = n4;
            if (n3 != 2) {
                n2 = n4;
                if (n3 != 3) {
                    n2 = 4;
                }
            }
        } else {
            n2 = 1;
        }
        return n2;
    }

    @Deprecated
    public static int getSize(Bitmap bitmap2) {
        return Util.getBitmapByteSize(bitmap2);
    }

    public static <T> List<T> getSnapshot(Collection<T> collection2) {
        ArrayList<Collection<T>> arrayList = new ArrayList<Collection<T>>(collection2.size());
        for (Collection<T> collection2 : collection2) {
            if (collection2 == null) continue;
            arrayList.add(collection2);
        }
        return arrayList;
    }

    public static int hashCode(float f3) {
        return Util.hashCode(f3, 17);
    }

    public static int hashCode(float f3, int n2) {
        return Util.hashCode(Float.floatToIntBits(f3), n2);
    }

    public static int hashCode(int n2) {
        return Util.hashCode(n2, 17);
    }

    public static int hashCode(int n2, int n3) {
        return n3 * 31 + n2;
    }

    public static int hashCode(Object object, int n2) {
        int n3 = object == null ? 0 : object.hashCode();
        return Util.hashCode(n3, n2);
    }

    public static int hashCode(boolean bl) {
        return Util.hashCode(bl, 17);
    }

    public static int hashCode(boolean bl, int n2) {
        return Util.hashCode(bl ? 1 : 0, n2);
    }

    public static boolean isOnBackgroundThread() {
        return Util.isOnMainThread() ^ true;
    }

    public static boolean isOnMainThread() {
        boolean bl = Looper.myLooper() == Looper.getMainLooper();
        return bl;
    }

    private static boolean isValidDimension(int n2) {
        boolean bl = n2 > 0 || n2 == Integer.MIN_VALUE;
        return bl;
    }

    public static boolean isValidDimensions(int n2, int n3) {
        boolean bl = Util.isValidDimension(n2) && Util.isValidDimension(n3);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sha256BytesToHex(byte[] object) {
        char[] cArray = SHA_256_CHARS;
        synchronized (cArray) {
            return Util.bytesToHex(object, SHA_256_CHARS);
        }
    }
}

