/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MarkEnforcingInputStream
extends FilterInputStream {
    private static final int END_OF_STREAM = -1;
    private static final int UNSET = Integer.MIN_VALUE;
    private int availableBytes = Integer.MIN_VALUE;

    public MarkEnforcingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    private long getBytesToRead(long l3) {
        int n2 = this.availableBytes;
        if (n2 == 0) {
            return -1L;
        }
        long l4 = l3;
        if (n2 != Integer.MIN_VALUE) {
            l4 = l3;
            if (l3 > (long)n2) {
                l4 = n2;
            }
        }
        return l4;
    }

    private void updateAvailableBytesAfterRead(long l3) {
        int n2 = this.availableBytes;
        if (n2 != Integer.MIN_VALUE && l3 != -1L) {
            this.availableBytes = (int)((long)n2 - l3);
        }
    }

    @Override
    public int available() throws IOException {
        int n2 = this.availableBytes;
        n2 = n2 == Integer.MIN_VALUE ? super.available() : Math.min(n2, super.available());
        return n2;
    }

    @Override
    public void mark(int n2) {
        synchronized (this) {
            super.mark(n2);
            this.availableBytes = n2;
            return;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.getBytesToRead(1L) == -1L) {
            return -1;
        }
        int n2 = super.read();
        this.updateAvailableBytesAfterRead(1L);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if ((n3 = (int)this.getBytesToRead(n3)) == -1) {
            return -1;
        }
        n2 = super.read(byArray, n2, n3);
        this.updateAvailableBytesAfterRead(n2);
        return n2;
    }

    @Override
    public void reset() throws IOException {
        synchronized (this) {
            super.reset();
            this.availableBytes = Integer.MIN_VALUE;
            return;
        }
    }

    @Override
    public long skip(long l3) throws IOException {
        if ((l3 = this.getBytesToRead(l3)) == -1L) {
            return 0L;
        }
        l3 = super.skip(l3);
        this.updateAvailableBytesAfterRead(l3);
        return l3;
    }
}

