/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LruCache<T, Y> {
    private final Map<T, Y> cache = new LinkedHashMap<T, Y>(100, 0.75f, true);
    private long currentSize;
    private final long initialMaxSize;
    private long maxSize;

    public LruCache(long l3) {
        this.initialMaxSize = l3;
        this.maxSize = l3;
    }

    private void evict() {
        this.trimToSize(this.maxSize);
    }

    public void clearMemory() {
        this.trimToSize(0L);
    }

    public boolean contains(T t2) {
        synchronized (this) {
            boolean bl = this.cache.containsKey(t2);
            return bl;
        }
    }

    public Y get(T object) {
        synchronized (this) {
            object = this.cache.get(object);
            return (Y)object;
        }
    }

    protected int getCount() {
        synchronized (this) {
            int n2 = this.cache.size();
            return n2;
        }
    }

    public long getCurrentSize() {
        synchronized (this) {
            long l3 = this.currentSize;
            return l3;
        }
    }

    public long getMaxSize() {
        synchronized (this) {
            long l3 = this.maxSize;
            return l3;
        }
    }

    protected int getSize(Y y2) {
        return 1;
    }

    protected void onItemEvicted(T t2, Y y2) {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Y put(T t2, Y y2) {
        synchronized (this) {
            void var5_4;
            void var2_2;
            long l3 = this.getSize(var2_2);
            if (l3 >= this.maxSize) {
                this.onItemEvicted(t2, var2_2);
                return null;
            }
            if (var2_2 != null) {
                this.currentSize += l3;
            }
            if ((var5_4 = this.cache.put(t2, var2_2)) != null) {
                this.currentSize -= (long)this.getSize(var5_4);
                if (!var5_4.equals(var2_2)) {
                    this.onItemEvicted(t2, var5_4);
                }
            }
            this.evict();
            return var5_4;
        }
    }

    public Y remove(T object) {
        synchronized (this) {
            block4: {
                object = this.cache.remove(object);
                if (object == null) break block4;
                this.currentSize -= (long)this.getSize(object);
            }
            return (Y)object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSizeMultiplier(float f3) {
        synchronized (this) {
            Throwable throwable2;
            if (!(f3 < 0.0f)) {
                try {
                    this.maxSize = Math.round((float)this.initialMaxSize * f3);
                    this.evict();
                    return;
                }
                catch (Throwable throwable2) {}
            } else {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Multiplier must be >= 0");
                throw illegalArgumentException;
            }
            throw throwable2;
        }
    }

    protected void trimToSize(long l3) {
        synchronized (this) {
            while (this.currentSize > l3) {
                Iterator<Map.Entry<T, Y>> iterator = this.cache.entrySet().iterator();
                Map.Entry<Object, Object> entry = iterator.next();
                Y y2 = entry.getValue();
                this.currentSize -= (long)this.getSize(y2);
                entry = entry.getKey();
                iterator.remove();
                this.onItemEvicted(entry, y2);
            }
            return;
        }
    }
}

