/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.util;

import android.text.TextUtils;
import android.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ContentLengthInputStream
extends FilterInputStream {
    private static final String TAG = "ContentLengthStream";
    private static final int UNKNOWN = -1;
    private final long contentLength;
    private int readSoFar;

    private ContentLengthInputStream(InputStream inputStream, long l3) {
        super(inputStream);
        this.contentLength = l3;
    }

    private int checkReadSoFarOrThrow(int n2) throws IOException {
        block4: {
            block3: {
                block2: {
                    if (n2 < 0) break block2;
                    this.readSoFar += n2;
                    break block3;
                }
                if (this.contentLength - (long)this.readSoFar > 0L) break block4;
            }
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Failed to read all expected data, expected: ");
        stringBuilder.append(this.contentLength);
        stringBuilder.append(", but read: ");
        stringBuilder.append(this.readSoFar);
        throw new IOException(stringBuilder.toString());
    }

    public static InputStream obtain(InputStream inputStream, long l3) {
        return new ContentLengthInputStream(inputStream, l3);
    }

    public static InputStream obtain(InputStream inputStream, String string2) {
        return ContentLengthInputStream.obtain(inputStream, ContentLengthInputStream.parseContentLength(string2));
    }

    private static int parseContentLength(String string2) {
        int n2;
        block3: {
            block4: {
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    try {
                        n2 = Integer.parseInt(string2);
                        break block3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!Log.isLoggable((String)TAG, (int)3)) break block4;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("failed to parse content length header: ");
                        stringBuilder.append(string2);
                        Log.d((String)TAG, (String)stringBuilder.toString(), (Throwable)numberFormatException);
                    }
                }
            }
            n2 = -1;
        }
        return n2;
    }

    @Override
    public int available() throws IOException {
        synchronized (this) {
            long l3 = Math.max(this.contentLength - (long)this.readSoFar, (long)this.in.available());
            int n2 = (int)l3;
            return n2;
        }
    }

    @Override
    public int read() throws IOException {
        synchronized (this) {
            int n2 = super.read();
            int n3 = n2 >= 0 ? 1 : -1;
            this.checkReadSoFarOrThrow(n3);
            return n2;
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        synchronized (this) {
            n2 = this.checkReadSoFarOrThrow(super.read(byArray, n2, n3));
            return n2;
        }
    }
}

