/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.target;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.target.BaseTarget;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ViewTarget<T extends View, Z>
extends BaseTarget<Z> {
    private static final String TAG = "ViewTarget";
    private static boolean isTagUsedAtLeastOnce;
    private static Integer tagId;
    private View.OnAttachStateChangeListener attachStateListener;
    private boolean isAttachStateListenerAdded;
    private boolean isClearedByUs;
    private final SizeDeterminer sizeDeterminer;
    protected final T view;

    public ViewTarget(T t2) {
        this.view = (View)Preconditions.checkNotNull(t2);
        this.sizeDeterminer = new SizeDeterminer((View)t2);
    }

    @Deprecated
    public ViewTarget(T t2, boolean bl) {
        this(t2);
        if (bl) {
            this.waitForLayout();
        }
    }

    private Object getTag() {
        Integer n2 = tagId;
        if (n2 == null) {
            return this.view.getTag();
        }
        return this.view.getTag(n2.intValue());
    }

    private void maybeAddAttachStateListener() {
        View.OnAttachStateChangeListener onAttachStateChangeListener = this.attachStateListener;
        if (onAttachStateChangeListener != null && !this.isAttachStateListenerAdded) {
            this.view.addOnAttachStateChangeListener(onAttachStateChangeListener);
            this.isAttachStateListenerAdded = true;
        }
    }

    private void maybeRemoveAttachStateListener() {
        View.OnAttachStateChangeListener onAttachStateChangeListener = this.attachStateListener;
        if (onAttachStateChangeListener != null && this.isAttachStateListenerAdded) {
            this.view.removeOnAttachStateChangeListener(onAttachStateChangeListener);
            this.isAttachStateListenerAdded = false;
        }
    }

    private void setTag(Object object) {
        Integer n2 = tagId;
        if (n2 == null) {
            isTagUsedAtLeastOnce = true;
            this.view.setTag(object);
        } else {
            this.view.setTag(n2.intValue(), object);
        }
    }

    public static void setTagId(int n2) {
        if (tagId == null && !isTagUsedAtLeastOnce) {
            tagId = n2;
            return;
        }
        throw new IllegalArgumentException("You cannot set the tag id more than once or change the tag id after the first request has been made");
    }

    public final ViewTarget<T, Z> clearOnDetach() {
        if (this.attachStateListener != null) {
            return this;
        }
        this.attachStateListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View view) {
                ViewTarget.this.resumeMyRequest();
            }

            public void onViewDetachedFromWindow(View view) {
                ViewTarget.this.pauseMyRequest();
            }
        };
        this.maybeAddAttachStateListener();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Request getRequest() {
        Object object = this.getTag();
        if (object == null) return null;
        if (!(object instanceof Request)) throw new IllegalArgumentException("You must not call setTag() on a view Glide is targeting");
        return (Request)object;
    }

    @Override
    public void getSize(SizeReadyCallback sizeReadyCallback) {
        this.sizeDeterminer.getSize(sizeReadyCallback);
    }

    public T getView() {
        return this.view;
    }

    @Override
    public void onLoadCleared(Drawable drawable2) {
        super.onLoadCleared(drawable2);
        this.sizeDeterminer.clearCallbacksAndListener();
        if (!this.isClearedByUs) {
            this.maybeRemoveAttachStateListener();
        }
    }

    @Override
    public void onLoadStarted(Drawable drawable2) {
        super.onLoadStarted(drawable2);
        this.maybeAddAttachStateListener();
    }

    void pauseMyRequest() {
        Request request = this.getRequest();
        if (request != null && !request.isCancelled() && !request.isPaused()) {
            this.isClearedByUs = true;
            request.pause();
            this.isClearedByUs = false;
        }
    }

    @Override
    public void removeCallback(SizeReadyCallback sizeReadyCallback) {
        this.sizeDeterminer.removeCallback(sizeReadyCallback);
    }

    void resumeMyRequest() {
        Request request = this.getRequest();
        if (request != null && request.isPaused()) {
            request.begin();
        }
    }

    @Override
    public void setRequest(Request request) {
        this.setTag(request);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Target for: ");
        stringBuilder.append(this.view);
        return stringBuilder.toString();
    }

    public final ViewTarget<T, Z> waitForLayout() {
        this.sizeDeterminer.waitForLayout = true;
        return this;
    }

    static final class SizeDeterminer {
        private static final int PENDING_SIZE = 0;
        static Integer maxDisplayLength;
        private final List<SizeReadyCallback> cbs = new ArrayList<SizeReadyCallback>();
        private SizeDeterminerLayoutListener layoutListener;
        private final View view;
        boolean waitForLayout;

        SizeDeterminer(View view) {
            this.view = view;
        }

        private static int getMaxDisplayLength(Context context) {
            if (maxDisplayLength == null) {
                context = Preconditions.checkNotNull((WindowManager)context.getSystemService("window")).getDefaultDisplay();
                Point point = new Point();
                context.getSize(point);
                maxDisplayLength = Math.max(point.x, point.y);
            }
            return maxDisplayLength;
        }

        private int getTargetDimen(int n2, int n3, int n4) {
            int n5 = n3 - n4;
            if (n5 > 0) {
                return n5;
            }
            if (this.waitForLayout && this.view.isLayoutRequested()) {
                return 0;
            }
            if ((n2 -= n4) > 0) {
                return n2;
            }
            if (!this.view.isLayoutRequested() && n3 == -2) {
                if (Log.isLoggable((String)ViewTarget.TAG, (int)4)) {
                    Log.i((String)ViewTarget.TAG, (String)"Glide treats LayoutParams.WRAP_CONTENT as a request for an image the size of this device's screen dimensions. If you want to load the original image and are ok with the corresponding memory cost and OOMs (depending on the input size), use .override(Target.SIZE_ORIGINAL). Otherwise, use LayoutParams.MATCH_PARENT, set layout_width and layout_height to fixed dimension, or use .override() with fixed dimensions.");
                }
                return SizeDeterminer.getMaxDisplayLength(this.view.getContext());
            }
            return 0;
        }

        private int getTargetHeight() {
            int n2 = this.view.getPaddingTop();
            int n3 = this.view.getPaddingBottom();
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            int n4 = layoutParams != null ? layoutParams.height : 0;
            return this.getTargetDimen(this.view.getHeight(), n4, n2 + n3);
        }

        private int getTargetWidth() {
            int n2 = this.view.getPaddingLeft();
            int n3 = this.view.getPaddingRight();
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            int n4 = layoutParams != null ? layoutParams.width : 0;
            return this.getTargetDimen(this.view.getWidth(), n4, n2 + n3);
        }

        private boolean isDimensionValid(int n2) {
            boolean bl = n2 > 0 || n2 == Integer.MIN_VALUE;
            return bl;
        }

        private boolean isViewStateAndSizeValid(int n2, int n3) {
            boolean bl = this.isDimensionValid(n2) && this.isDimensionValid(n3);
            return bl;
        }

        private void notifyCbs(int n2, int n3) {
            Iterator<SizeReadyCallback> iterator = new ArrayList<SizeReadyCallback>(this.cbs).iterator();
            while (iterator.hasNext()) {
                iterator.next().onSizeReady(n2, n3);
            }
        }

        void checkCurrentDimens() {
            int n2;
            if (this.cbs.isEmpty()) {
                return;
            }
            int n3 = this.getTargetWidth();
            if (!this.isViewStateAndSizeValid(n3, n2 = this.getTargetHeight())) {
                return;
            }
            this.notifyCbs(n3, n2);
            this.clearCallbacksAndListener();
        }

        void clearCallbacksAndListener() {
            ViewTreeObserver viewTreeObserver = this.view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
            }
            this.layoutListener = null;
            this.cbs.clear();
        }

        void getSize(SizeReadyCallback sizeReadyCallback) {
            int n2;
            int n3 = this.getTargetWidth();
            if (this.isViewStateAndSizeValid(n3, n2 = this.getTargetHeight())) {
                sizeReadyCallback.onSizeReady(n3, n2);
                return;
            }
            if (!this.cbs.contains(sizeReadyCallback)) {
                this.cbs.add(sizeReadyCallback);
            }
            if (this.layoutListener == null) {
                sizeReadyCallback = this.view.getViewTreeObserver();
                this.layoutListener = new SizeDeterminerLayoutListener(this);
                sizeReadyCallback.addOnPreDrawListener(this.layoutListener);
            }
        }

        void removeCallback(SizeReadyCallback sizeReadyCallback) {
            this.cbs.remove(sizeReadyCallback);
        }

        private static final class SizeDeterminerLayoutListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final WeakReference<SizeDeterminer> sizeDeterminerRef;

            SizeDeterminerLayoutListener(SizeDeterminer sizeDeterminer) {
                this.sizeDeterminerRef = new WeakReference<SizeDeterminer>(sizeDeterminer);
            }

            public boolean onPreDraw() {
                Object object;
                if (Log.isLoggable((String)ViewTarget.TAG, (int)2)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("OnGlobalLayoutListener called attachStateListener=");
                    ((StringBuilder)object).append(this);
                    Log.v((String)ViewTarget.TAG, (String)((StringBuilder)object).toString());
                }
                if ((object = (SizeDeterminer)this.sizeDeterminerRef.get()) != null) {
                    ((SizeDeterminer)object).checkCurrentDimens();
                }
                return true;
            }
        }
    }
}

