/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.target;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Preconditions;

public class NotificationTarget
extends SimpleTarget<Bitmap> {
    private final Context context;
    private final Notification notification;
    private final int notificationId;
    private final String notificationTag;
    private final RemoteViews remoteViews;
    private final int viewId;

    public NotificationTarget(Context context, int n2, int n3, int n4, RemoteViews remoteViews, Notification notification, int n5, String string2) {
        super(n2, n3);
        this.context = Preconditions.checkNotNull(context, "Context must not be null!");
        this.notification = Preconditions.checkNotNull(notification, "Notification object can not be null!");
        this.remoteViews = Preconditions.checkNotNull(remoteViews, "RemoteViews object can not be null!");
        this.viewId = n4;
        this.notificationId = n5;
        this.notificationTag = string2;
    }

    public NotificationTarget(Context context, int n2, RemoteViews remoteViews, Notification notification, int n3) {
        this(context, n2, remoteViews, notification, n3, null);
    }

    public NotificationTarget(Context context, int n2, RemoteViews remoteViews, Notification notification, int n3, String string2) {
        this(context, Integer.MIN_VALUE, Integer.MIN_VALUE, n2, remoteViews, notification, n3, string2);
    }

    private void update() {
        Preconditions.checkNotNull((NotificationManager)this.context.getSystemService("notification")).notify(this.notificationTag, this.notificationId, this.notification);
    }

    @Override
    public void onResourceReady(Bitmap bitmap2, Transition<? super Bitmap> transition) {
        this.remoteViews.setImageViewBitmap(this.viewId, bitmap2);
        this.update();
    }
}

