/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request.target;

import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.graphics.Bitmap;
import android.widget.RemoteViews;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Preconditions;

public class AppWidgetTarget
extends SimpleTarget<Bitmap> {
    private final ComponentName componentName;
    private final Context context;
    private final RemoteViews remoteViews;
    private final int viewId;
    private final int[] widgetIds;

    public AppWidgetTarget(Context context, int n2, int n3, int n4, RemoteViews remoteViews, ComponentName componentName) {
        super(n2, n3);
        this.context = Preconditions.checkNotNull(context, "Context can not be null!");
        this.remoteViews = Preconditions.checkNotNull(remoteViews, "RemoteViews object can not be null!");
        this.componentName = Preconditions.checkNotNull(componentName, "ComponentName can not be null!");
        this.viewId = n4;
        this.widgetIds = null;
    }

    public AppWidgetTarget(Context context, int n2, int n3, int n4, RemoteViews remoteViews, int ... nArray) {
        super(n2, n3);
        if (nArray.length != 0) {
            this.context = Preconditions.checkNotNull(context, "Context can not be null!");
            this.remoteViews = Preconditions.checkNotNull(remoteViews, "RemoteViews object can not be null!");
            this.widgetIds = Preconditions.checkNotNull(nArray, "WidgetIds can not be null!");
            this.viewId = n4;
            this.componentName = null;
            return;
        }
        throw new IllegalArgumentException("WidgetIds must have length > 0");
    }

    public AppWidgetTarget(Context context, int n2, RemoteViews remoteViews, ComponentName componentName) {
        this(context, Integer.MIN_VALUE, Integer.MIN_VALUE, n2, remoteViews, componentName);
    }

    public AppWidgetTarget(Context context, int n2, RemoteViews remoteViews, int ... nArray) {
        this(context, Integer.MIN_VALUE, Integer.MIN_VALUE, n2, remoteViews, nArray);
    }

    private void update() {
        AppWidgetManager appWidgetManager = AppWidgetManager.getInstance((Context)this.context);
        ComponentName componentName = this.componentName;
        if (componentName != null) {
            appWidgetManager.updateAppWidget(componentName, this.remoteViews);
        } else {
            appWidgetManager.updateAppWidget(this.widgetIds, this.remoteViews);
        }
    }

    @Override
    public void onResourceReady(Bitmap bitmap2, Transition<? super Bitmap> transition) {
        this.remoteViews.setImageViewBitmap(this.viewId, bitmap2);
        this.update();
    }
}

