/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.Log;
import androidx.core.util.Pools;
import com.bumptech.glide.GlideContext;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.Engine;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.drawable.DrawableDecoderCompat;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.ResourceCallback;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.TransitionFactory;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Util;
import com.bumptech.glide.util.pool.FactoryPools;
import com.bumptech.glide.util.pool.StateVerifier;

public final class SingleRequest<R>
implements Request,
SizeReadyCallback,
ResourceCallback,
FactoryPools.Poolable {
    private static final String GLIDE_TAG = "Glide";
    private static final boolean IS_VERBOSE_LOGGABLE;
    private static final Pools.Pool<SingleRequest<?>> POOL;
    private static final String TAG = "Request";
    private TransitionFactory<? super R> animationFactory;
    private Context context;
    private Engine engine;
    private Drawable errorDrawable;
    private Drawable fallbackDrawable;
    private GlideContext glideContext;
    private int height;
    private boolean isCallingCallbacks;
    private Engine.LoadStatus loadStatus;
    private Object model;
    private int overrideHeight;
    private int overrideWidth;
    private Drawable placeholderDrawable;
    private Priority priority;
    private RequestCoordinator requestCoordinator;
    private RequestListener<R> requestListener;
    private RequestOptions requestOptions;
    private Resource<R> resource;
    private long startTime;
    private final StateVerifier stateVerifier;
    private Status status;
    private final String tag;
    private Target<R> target;
    private RequestListener<R> targetListener;
    private Class<R> transcodeClass;
    private int width;

    static {
        POOL = FactoryPools.simple(150, new FactoryPools.Factory<SingleRequest<?>>(){

            @Override
            public SingleRequest<?> create() {
                return new SingleRequest();
            }
        });
        IS_VERBOSE_LOGGABLE = Log.isLoggable((String)TAG, (int)2);
    }

    SingleRequest() {
        String string2 = IS_VERBOSE_LOGGABLE ? String.valueOf(super.hashCode()) : null;
        this.tag = string2;
        this.stateVerifier = StateVerifier.newInstance();
    }

    private void assertNotCallingCallbacks() {
        if (!this.isCallingCallbacks) {
            return;
        }
        throw new IllegalStateException("You can't start or clear loads in RequestListener or Target callbacks. If you're trying to start a fallback request when a load fails, use RequestBuilder#error(RequestBuilder). Otherwise consider posting your into() or clear() calls to the main thread using a Handler instead.");
    }

    private boolean canNotifyCleared() {
        RequestCoordinator requestCoordinator = this.requestCoordinator;
        boolean bl = requestCoordinator == null || requestCoordinator.canNotifyCleared(this);
        return bl;
    }

    private boolean canNotifyStatusChanged() {
        RequestCoordinator requestCoordinator = this.requestCoordinator;
        boolean bl = requestCoordinator == null || requestCoordinator.canNotifyStatusChanged(this);
        return bl;
    }

    private boolean canSetResource() {
        RequestCoordinator requestCoordinator = this.requestCoordinator;
        boolean bl = requestCoordinator == null || requestCoordinator.canSetImage(this);
        return bl;
    }

    private Drawable getErrorDrawable() {
        if (this.errorDrawable == null) {
            this.errorDrawable = this.requestOptions.getErrorPlaceholder();
            if (this.errorDrawable == null && this.requestOptions.getErrorId() > 0) {
                this.errorDrawable = this.loadDrawable(this.requestOptions.getErrorId());
            }
        }
        return this.errorDrawable;
    }

    private Drawable getFallbackDrawable() {
        if (this.fallbackDrawable == null) {
            this.fallbackDrawable = this.requestOptions.getFallbackDrawable();
            if (this.fallbackDrawable == null && this.requestOptions.getFallbackId() > 0) {
                this.fallbackDrawable = this.loadDrawable(this.requestOptions.getFallbackId());
            }
        }
        return this.fallbackDrawable;
    }

    private Drawable getPlaceholderDrawable() {
        if (this.placeholderDrawable == null) {
            this.placeholderDrawable = this.requestOptions.getPlaceholderDrawable();
            if (this.placeholderDrawable == null && this.requestOptions.getPlaceholderId() > 0) {
                this.placeholderDrawable = this.loadDrawable(this.requestOptions.getPlaceholderId());
            }
        }
        return this.placeholderDrawable;
    }

    private void init(Context context, GlideContext glideContext, Object object, Class<R> clazz, RequestOptions requestOptions, int n2, int n3, Priority priority, Target<R> target, RequestListener<R> requestListener, RequestListener<R> requestListener2, RequestCoordinator requestCoordinator, Engine engine, TransitionFactory<? super R> transitionFactory) {
        this.context = context;
        this.glideContext = glideContext;
        this.model = object;
        this.transcodeClass = clazz;
        this.requestOptions = requestOptions;
        this.overrideWidth = n2;
        this.overrideHeight = n3;
        this.priority = priority;
        this.target = target;
        this.targetListener = requestListener;
        this.requestListener = requestListener2;
        this.requestCoordinator = requestCoordinator;
        this.engine = engine;
        this.animationFactory = transitionFactory;
        this.status = Status.PENDING;
    }

    private boolean isFirstReadyResource() {
        RequestCoordinator requestCoordinator = this.requestCoordinator;
        boolean bl = requestCoordinator == null || !requestCoordinator.isAnyResourceSet();
        return bl;
    }

    private Drawable loadDrawable(int n2) {
        Resources.Theme theme = this.requestOptions.getTheme() != null ? this.requestOptions.getTheme() : this.context.getTheme();
        return DrawableDecoderCompat.getDrawable((Context)this.glideContext, n2, theme);
    }

    private void logV(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(" this: ");
        stringBuilder.append(this.tag);
        Log.v((String)TAG, (String)stringBuilder.toString());
    }

    private static int maybeApplySizeMultiplier(int n2, float f3) {
        if (n2 != Integer.MIN_VALUE) {
            n2 = Math.round(f3 * (float)n2);
        }
        return n2;
    }

    private void notifyLoadFailed() {
        RequestCoordinator requestCoordinator = this.requestCoordinator;
        if (requestCoordinator != null) {
            requestCoordinator.onRequestFailed(this);
        }
    }

    private void notifyLoadSuccess() {
        RequestCoordinator requestCoordinator = this.requestCoordinator;
        if (requestCoordinator != null) {
            requestCoordinator.onRequestSuccess(this);
        }
    }

    public static <R> SingleRequest<R> obtain(Context context, GlideContext glideContext, Object object, Class<R> clazz, RequestOptions requestOptions, int n2, int n3, Priority priority, Target<R> target, RequestListener<R> requestListener, RequestListener<R> requestListener2, RequestCoordinator requestCoordinator, Engine engine, TransitionFactory<? super R> transitionFactory) {
        SingleRequest<R> singleRequest;
        SingleRequest<R> singleRequest2 = singleRequest = (SingleRequest<R>)POOL.acquire();
        if (singleRequest == null) {
            singleRequest2 = new SingleRequest<R>();
        }
        super.init(context, glideContext, object, clazz, requestOptions, n2, n3, priority, target, requestListener, requestListener2, requestCoordinator, engine, transitionFactory);
        return singleRequest2;
    }

    private void onLoadFailed(GlideException glideException, int n2) {
        this.stateVerifier.throwIfRecycled();
        int n3 = this.glideContext.getLogLevel();
        if (n3 <= n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Load failed for ");
            stringBuilder.append(this.model);
            stringBuilder.append(" with size [");
            stringBuilder.append(this.width);
            stringBuilder.append("x");
            stringBuilder.append(this.height);
            stringBuilder.append("]");
            Log.w((String)GLIDE_TAG, (String)stringBuilder.toString(), (Throwable)glideException);
            if (n3 <= 4) {
                glideException.logRootCauses(GLIDE_TAG);
            }
        }
        this.loadStatus = null;
        this.status = Status.FAILED;
        this.isCallingCallbacks = true;
        try {
            if (!(this.requestListener != null && this.requestListener.onLoadFailed(glideException, this.model, this.target, this.isFirstReadyResource()) || this.targetListener != null && this.targetListener.onLoadFailed(glideException, this.model, this.target, this.isFirstReadyResource()))) {
                this.setErrorPlaceholder();
            }
            this.notifyLoadFailed();
            return;
        }
        finally {
            this.isCallingCallbacks = false;
        }
    }

    private void onResourceReady(Resource<R> transition, R r2, DataSource dataSource) {
        boolean bl = this.isFirstReadyResource();
        this.status = Status.COMPLETE;
        this.resource = transition;
        if (this.glideContext.getLogLevel() <= 3) {
            transition = new StringBuilder();
            ((StringBuilder)((Object)transition)).append("Finished loading ");
            ((StringBuilder)((Object)transition)).append(r2.getClass().getSimpleName());
            ((StringBuilder)((Object)transition)).append(" from ");
            ((StringBuilder)((Object)transition)).append((Object)dataSource);
            ((StringBuilder)((Object)transition)).append(" for ");
            ((StringBuilder)((Object)transition)).append(this.model);
            ((StringBuilder)((Object)transition)).append(" with size [");
            ((StringBuilder)((Object)transition)).append(this.width);
            ((StringBuilder)((Object)transition)).append("x");
            ((StringBuilder)((Object)transition)).append(this.height);
            ((StringBuilder)((Object)transition)).append("] in ");
            ((StringBuilder)((Object)transition)).append(LogTime.getElapsedMillis(this.startTime));
            ((StringBuilder)((Object)transition)).append(" ms");
            Log.d((String)GLIDE_TAG, (String)((StringBuilder)((Object)transition)).toString());
        }
        this.isCallingCallbacks = true;
        try {
            if (!(this.requestListener != null && this.requestListener.onResourceReady(r2, this.model, this.target, dataSource, bl) || this.targetListener != null && this.targetListener.onResourceReady(r2, this.model, this.target, dataSource, bl))) {
                transition = this.animationFactory.build(dataSource, bl);
                this.target.onResourceReady(r2, transition);
            }
            this.notifyLoadSuccess();
            return;
        }
        finally {
            this.isCallingCallbacks = false;
        }
    }

    private void releaseResource(Resource<?> resource) {
        this.engine.release(resource);
        this.resource = null;
    }

    private void setErrorPlaceholder() {
        if (!this.canNotifyStatusChanged()) {
            return;
        }
        Drawable drawable2 = null;
        if (this.model == null) {
            drawable2 = this.getFallbackDrawable();
        }
        Drawable drawable3 = drawable2;
        if (drawable2 == null) {
            drawable3 = this.getErrorDrawable();
        }
        drawable2 = drawable3;
        if (drawable3 == null) {
            drawable2 = this.getPlaceholderDrawable();
        }
        this.target.onLoadFailed(drawable2);
    }

    @Override
    public void begin() {
        this.assertNotCallingCallbacks();
        this.stateVerifier.throwIfRecycled();
        this.startTime = LogTime.getLogTime();
        if (this.model == null) {
            if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight)) {
                this.width = this.overrideWidth;
                this.height = this.overrideHeight;
            }
            int n2 = this.getFallbackDrawable() == null ? 5 : 3;
            this.onLoadFailed(new GlideException("Received null model"), n2);
            return;
        }
        if (this.status != Status.RUNNING) {
            if (this.status == Status.COMPLETE) {
                this.onResourceReady(this.resource, DataSource.MEMORY_CACHE);
                return;
            }
            this.status = Status.WAITING_FOR_SIZE;
            if (Util.isValidDimensions(this.overrideWidth, this.overrideHeight)) {
                this.onSizeReady(this.overrideWidth, this.overrideHeight);
            } else {
                this.target.getSize(this);
            }
            if ((this.status == Status.RUNNING || this.status == Status.WAITING_FOR_SIZE) && this.canNotifyStatusChanged()) {
                this.target.onLoadStarted(this.getPlaceholderDrawable());
            }
            if (IS_VERBOSE_LOGGABLE) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("finished run method in ");
                stringBuilder.append(LogTime.getElapsedMillis(this.startTime));
                this.logV(stringBuilder.toString());
            }
            return;
        }
        throw new IllegalArgumentException("Cannot restart a running request");
    }

    void cancel() {
        this.assertNotCallingCallbacks();
        this.stateVerifier.throwIfRecycled();
        this.target.removeCallback(this);
        this.status = Status.CANCELLED;
        Engine.LoadStatus loadStatus = this.loadStatus;
        if (loadStatus != null) {
            loadStatus.cancel();
            this.loadStatus = null;
        }
    }

    @Override
    public void clear() {
        Util.assertMainThread();
        this.assertNotCallingCallbacks();
        this.stateVerifier.throwIfRecycled();
        if (this.status == Status.CLEARED) {
            return;
        }
        this.cancel();
        Resource<R> resource = this.resource;
        if (resource != null) {
            this.releaseResource(resource);
        }
        if (this.canNotifyCleared()) {
            this.target.onLoadCleared(this.getPlaceholderDrawable());
        }
        this.status = Status.CLEARED;
    }

    @Override
    public StateVerifier getVerifier() {
        return this.stateVerifier;
    }

    @Override
    public boolean isCancelled() {
        boolean bl = this.status == Status.CANCELLED || this.status == Status.CLEARED;
        return bl;
    }

    @Override
    public boolean isComplete() {
        boolean bl = this.status == Status.COMPLETE;
        return bl;
    }

    @Override
    public boolean isEquivalentTo(Request object) {
        boolean bl;
        block2: {
            block4: {
                Object object2;
                boolean bl2;
                block3: {
                    boolean bl3 = object instanceof SingleRequest;
                    bl = bl2 = false;
                    if (!bl3) break block2;
                    object2 = (SingleRequest)object;
                    bl = bl2;
                    if (this.overrideWidth != ((SingleRequest)object2).overrideWidth) break block2;
                    bl = bl2;
                    if (this.overrideHeight != ((SingleRequest)object2).overrideHeight) break block2;
                    bl = bl2;
                    if (!Util.bothModelsNullEquivalentOrEquals(this.model, ((SingleRequest)object2).model)) break block2;
                    bl = bl2;
                    if (!this.transcodeClass.equals(((SingleRequest)object2).transcodeClass)) break block2;
                    bl = bl2;
                    if (!this.requestOptions.equals(((SingleRequest)object2).requestOptions)) break block2;
                    bl = bl2;
                    if (this.priority != ((SingleRequest)object2).priority) break block2;
                    object = this.requestListener;
                    object2 = ((SingleRequest)object2).requestListener;
                    if (object == null) break block3;
                    bl = bl2;
                    if (object2 == null) break block2;
                    break block4;
                }
                bl = bl2;
                if (object2 != null) break block2;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isFailed() {
        boolean bl = this.status == Status.FAILED;
        return bl;
    }

    @Override
    public boolean isPaused() {
        boolean bl = this.status == Status.PAUSED;
        return bl;
    }

    @Override
    public boolean isResourceSet() {
        return this.isComplete();
    }

    @Override
    public boolean isRunning() {
        boolean bl = this.status == Status.RUNNING || this.status == Status.WAITING_FOR_SIZE;
        return bl;
    }

    @Override
    public void onLoadFailed(GlideException glideException) {
        this.onLoadFailed(glideException, 5);
    }

    @Override
    public void onResourceReady(Resource<?> object, DataSource object2) {
        this.stateVerifier.throwIfRecycled();
        this.loadStatus = null;
        if (object == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Expected to receive a Resource<R> with an object of ");
            ((StringBuilder)object).append(this.transcodeClass);
            ((StringBuilder)object).append(" inside, but instead got null.");
            this.onLoadFailed(new GlideException(((StringBuilder)object).toString()));
            return;
        }
        Object obj = object.get();
        if (obj != null && this.transcodeClass.isAssignableFrom(obj.getClass())) {
            if (!this.canSetResource()) {
                this.releaseResource((Resource<?>)object);
                this.status = Status.COMPLETE;
                return;
            }
            this.onResourceReady((Resource<R>)object, (R)obj, (DataSource)((Object)object2));
            return;
        }
        this.releaseResource((Resource<?>)object);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Expected to receive an object of ");
        stringBuilder.append(this.transcodeClass);
        stringBuilder.append(" but instead got ");
        String string2 = "";
        object2 = obj != null ? obj.getClass() : "";
        stringBuilder.append(object2);
        stringBuilder.append("{");
        stringBuilder.append(obj);
        stringBuilder.append("} inside Resource{");
        stringBuilder.append(object);
        stringBuilder.append("}.");
        object = obj != null ? string2 : " To indicate failure return a null Resource object, rather than a Resource object containing null data.";
        stringBuilder.append((String)object);
        this.onLoadFailed(new GlideException(stringBuilder.toString()));
    }

    @Override
    public void onSizeReady(int n2, int n3) {
        StringBuilder stringBuilder;
        this.stateVerifier.throwIfRecycled();
        if (IS_VERBOSE_LOGGABLE) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("Got onSizeReady in ");
            stringBuilder.append(LogTime.getElapsedMillis(this.startTime));
            this.logV(stringBuilder.toString());
        }
        if (this.status != Status.WAITING_FOR_SIZE) {
            return;
        }
        this.status = Status.RUNNING;
        float f3 = this.requestOptions.getSizeMultiplier();
        this.width = SingleRequest.maybeApplySizeMultiplier(n2, f3);
        this.height = SingleRequest.maybeApplySizeMultiplier(n3, f3);
        if (IS_VERBOSE_LOGGABLE) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("finished setup for calling load in ");
            stringBuilder.append(LogTime.getElapsedMillis(this.startTime));
            this.logV(stringBuilder.toString());
        }
        this.loadStatus = this.engine.load(this.glideContext, this.model, this.requestOptions.getSignature(), this.width, this.height, this.requestOptions.getResourceClass(), this.transcodeClass, this.priority, this.requestOptions.getDiskCacheStrategy(), this.requestOptions.getTransformations(), this.requestOptions.isTransformationRequired(), this.requestOptions.isScaleOnlyOrNoTransform(), this.requestOptions.getOptions(), this.requestOptions.isMemoryCacheable(), this.requestOptions.getUseUnlimitedSourceGeneratorsPool(), this.requestOptions.getUseAnimationPool(), this.requestOptions.getOnlyRetrieveFromCache(), this);
        if (this.status != Status.RUNNING) {
            this.loadStatus = null;
        }
        if (IS_VERBOSE_LOGGABLE) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("finished onSizeReady in ");
            stringBuilder.append(LogTime.getElapsedMillis(this.startTime));
            this.logV(stringBuilder.toString());
        }
    }

    @Override
    public void pause() {
        this.clear();
        this.status = Status.PAUSED;
    }

    @Override
    public void recycle() {
        this.assertNotCallingCallbacks();
        this.context = null;
        this.glideContext = null;
        this.model = null;
        this.transcodeClass = null;
        this.requestOptions = null;
        this.overrideWidth = -1;
        this.overrideHeight = -1;
        this.target = null;
        this.requestListener = null;
        this.targetListener = null;
        this.requestCoordinator = null;
        this.animationFactory = null;
        this.loadStatus = null;
        this.errorDrawable = null;
        this.placeholderDrawable = null;
        this.fallbackDrawable = null;
        this.width = -1;
        this.height = -1;
        POOL.release((Object)this);
    }

    private static enum Status {
        PENDING,
        RUNNING,
        WAITING_FOR_SIZE,
        COMPLETE,
        FAILED,
        CANCELLED,
        CLEARED,
        PAUSED;

    }
}

