/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.model.stream.HttpGlideUrlLoader;
import com.bumptech.glide.load.resource.bitmap.BitmapEncoder;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.CenterInside;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.bitmap.Downsampler;
import com.bumptech.glide.load.resource.bitmap.DrawableTransformation;
import com.bumptech.glide.load.resource.bitmap.FitCenter;
import com.bumptech.glide.load.resource.bitmap.VideoDecoder;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.load.resource.gif.GifDrawableTransformation;
import com.bumptech.glide.load.resource.gif.GifOptions;
import com.bumptech.glide.signature.EmptySignature;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.util.HashMap;
import java.util.Map;

public class RequestOptions
implements Cloneable {
    private static final int DISK_CACHE_STRATEGY = 4;
    private static final int ERROR_ID = 32;
    private static final int ERROR_PLACEHOLDER = 16;
    private static final int FALLBACK = 8192;
    private static final int FALLBACK_ID = 16384;
    private static final int IS_CACHEABLE = 256;
    private static final int ONLY_RETRIEVE_FROM_CACHE = 524288;
    private static final int OVERRIDE = 512;
    private static final int PLACEHOLDER = 64;
    private static final int PLACEHOLDER_ID = 128;
    private static final int PRIORITY = 8;
    private static final int RESOURCE_CLASS = 4096;
    private static final int SIGNATURE = 1024;
    private static final int SIZE_MULTIPLIER = 2;
    private static final int THEME = 32768;
    private static final int TRANSFORMATION = 2048;
    private static final int TRANSFORMATION_ALLOWED = 65536;
    private static final int TRANSFORMATION_REQUIRED = 131072;
    private static final int UNSET = -1;
    private static final int USE_ANIMATION_POOL = 0x100000;
    private static final int USE_UNLIMITED_SOURCE_GENERATORS_POOL = 262144;
    private static RequestOptions centerCropOptions;
    private static RequestOptions centerInsideOptions;
    private static RequestOptions circleCropOptions;
    private static RequestOptions fitCenterOptions;
    private static RequestOptions noAnimationOptions;
    private static RequestOptions noTransformOptions;
    private static RequestOptions skipMemoryCacheFalseOptions;
    private static RequestOptions skipMemoryCacheTrueOptions;
    private DiskCacheStrategy diskCacheStrategy = DiskCacheStrategy.AUTOMATIC;
    private int errorId;
    private Drawable errorPlaceholder;
    private Drawable fallbackDrawable;
    private int fallbackId;
    private int fields;
    private boolean isAutoCloneEnabled;
    private boolean isCacheable = true;
    private boolean isLocked;
    private boolean isScaleOnlyOrNoTransform = true;
    private boolean isTransformationAllowed = true;
    private boolean isTransformationRequired;
    private boolean onlyRetrieveFromCache;
    private Options options;
    private int overrideHeight = -1;
    private int overrideWidth = -1;
    private Drawable placeholderDrawable;
    private int placeholderId;
    private Priority priority = Priority.NORMAL;
    private Class<?> resourceClass = Object.class;
    private Key signature = EmptySignature.obtain();
    private float sizeMultiplier = 1.0f;
    private Resources.Theme theme;
    private Map<Class<?>, Transformation<?>> transformations;
    private boolean useAnimationPool;
    private boolean useUnlimitedSourceGeneratorsPool;

    public RequestOptions() {
        this.options = new Options();
        this.transformations = new HashMap();
    }

    public static RequestOptions bitmapTransform(Transformation<Bitmap> transformation) {
        return new RequestOptions().transform(transformation);
    }

    public static RequestOptions centerCropTransform() {
        if (centerCropOptions == null) {
            centerCropOptions = new RequestOptions().centerCrop().autoClone();
        }
        return centerCropOptions;
    }

    public static RequestOptions centerInsideTransform() {
        if (centerInsideOptions == null) {
            centerInsideOptions = new RequestOptions().centerInside().autoClone();
        }
        return centerInsideOptions;
    }

    public static RequestOptions circleCropTransform() {
        if (circleCropOptions == null) {
            circleCropOptions = new RequestOptions().circleCrop().autoClone();
        }
        return circleCropOptions;
    }

    public static RequestOptions decodeTypeOf(Class<?> clazz) {
        return new RequestOptions().decode(clazz);
    }

    public static RequestOptions diskCacheStrategyOf(DiskCacheStrategy diskCacheStrategy) {
        return new RequestOptions().diskCacheStrategy(diskCacheStrategy);
    }

    public static RequestOptions downsampleOf(DownsampleStrategy downsampleStrategy) {
        return new RequestOptions().downsample(downsampleStrategy);
    }

    public static RequestOptions encodeFormatOf(Bitmap.CompressFormat compressFormat) {
        return new RequestOptions().encodeFormat(compressFormat);
    }

    public static RequestOptions encodeQualityOf(int n2) {
        return new RequestOptions().encodeQuality(n2);
    }

    public static RequestOptions errorOf(int n2) {
        return new RequestOptions().error(n2);
    }

    public static RequestOptions errorOf(Drawable drawable2) {
        return new RequestOptions().error(drawable2);
    }

    public static RequestOptions fitCenterTransform() {
        if (fitCenterOptions == null) {
            fitCenterOptions = new RequestOptions().fitCenter().autoClone();
        }
        return fitCenterOptions;
    }

    public static RequestOptions formatOf(DecodeFormat decodeFormat) {
        return new RequestOptions().format(decodeFormat);
    }

    public static RequestOptions frameOf(long l3) {
        return new RequestOptions().frame(l3);
    }

    private boolean isSet(int n2) {
        return RequestOptions.isSet(this.fields, n2);
    }

    private static boolean isSet(int n2, int n3) {
        boolean bl = (n2 & n3) != 0;
        return bl;
    }

    public static RequestOptions noAnimation() {
        if (noAnimationOptions == null) {
            noAnimationOptions = new RequestOptions().dontAnimate().autoClone();
        }
        return noAnimationOptions;
    }

    public static RequestOptions noTransformation() {
        if (noTransformOptions == null) {
            noTransformOptions = new RequestOptions().dontTransform().autoClone();
        }
        return noTransformOptions;
    }

    public static <T> RequestOptions option(Option<T> option, T t2) {
        return new RequestOptions().set(option, t2);
    }

    private RequestOptions optionalScaleOnlyTransform(DownsampleStrategy downsampleStrategy, Transformation<Bitmap> transformation) {
        return this.scaleOnlyTransform(downsampleStrategy, transformation, false);
    }

    public static RequestOptions overrideOf(int n2) {
        return RequestOptions.overrideOf(n2, n2);
    }

    public static RequestOptions overrideOf(int n2, int n3) {
        return new RequestOptions().override(n2, n3);
    }

    public static RequestOptions placeholderOf(int n2) {
        return new RequestOptions().placeholder(n2);
    }

    public static RequestOptions placeholderOf(Drawable drawable2) {
        return new RequestOptions().placeholder(drawable2);
    }

    public static RequestOptions priorityOf(Priority priority) {
        return new RequestOptions().priority(priority);
    }

    private RequestOptions scaleOnlyTransform(DownsampleStrategy downsampleStrategy, Transformation<Bitmap> transformation) {
        return this.scaleOnlyTransform(downsampleStrategy, transformation, true);
    }

    private RequestOptions scaleOnlyTransform(DownsampleStrategy object, Transformation<Bitmap> transformation, boolean bl) {
        object = bl ? this.transform((DownsampleStrategy)object, transformation) : this.optionalTransform((DownsampleStrategy)object, transformation);
        ((RequestOptions)object).isScaleOnlyOrNoTransform = true;
        return object;
    }

    private RequestOptions selfOrThrowIfLocked() {
        if (!this.isLocked) {
            return this;
        }
        throw new IllegalStateException("You cannot modify locked RequestOptions, consider clone()");
    }

    public static RequestOptions signatureOf(Key key) {
        return new RequestOptions().signature(key);
    }

    public static RequestOptions sizeMultiplierOf(float f3) {
        return new RequestOptions().sizeMultiplier(f3);
    }

    public static RequestOptions skipMemoryCacheOf(boolean bl) {
        if (bl) {
            if (skipMemoryCacheTrueOptions == null) {
                skipMemoryCacheTrueOptions = new RequestOptions().skipMemoryCache(true).autoClone();
            }
            return skipMemoryCacheTrueOptions;
        }
        if (skipMemoryCacheFalseOptions == null) {
            skipMemoryCacheFalseOptions = new RequestOptions().skipMemoryCache(false).autoClone();
        }
        return skipMemoryCacheFalseOptions;
    }

    public static RequestOptions timeoutOf(int n2) {
        return new RequestOptions().timeout(n2);
    }

    private RequestOptions transform(Transformation<Bitmap> transformation, boolean bl) {
        if (this.isAutoCloneEnabled) {
            return this.clone().transform(transformation, bl);
        }
        DrawableTransformation drawableTransformation = new DrawableTransformation(transformation, bl);
        this.transform(Bitmap.class, transformation, bl);
        this.transform(Drawable.class, drawableTransformation, bl);
        this.transform(BitmapDrawable.class, drawableTransformation.asBitmapDrawable(), bl);
        this.transform(GifDrawable.class, new GifDrawableTransformation(transformation), bl);
        return this.selfOrThrowIfLocked();
    }

    private <T> RequestOptions transform(Class<T> clazz, Transformation<T> transformation, boolean bl) {
        if (this.isAutoCloneEnabled) {
            return this.clone().transform(clazz, transformation, bl);
        }
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(transformation);
        this.transformations.put(clazz, transformation);
        this.fields |= 0x800;
        this.isTransformationAllowed = true;
        this.fields |= 0x10000;
        this.isScaleOnlyOrNoTransform = false;
        if (bl) {
            this.fields |= 0x20000;
            this.isTransformationRequired = true;
        }
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions apply(RequestOptions requestOptions) {
        if (this.isAutoCloneEnabled) {
            return this.clone().apply(requestOptions);
        }
        if (RequestOptions.isSet(requestOptions.fields, 2)) {
            this.sizeMultiplier = requestOptions.sizeMultiplier;
        }
        if (RequestOptions.isSet(requestOptions.fields, 262144)) {
            this.useUnlimitedSourceGeneratorsPool = requestOptions.useUnlimitedSourceGeneratorsPool;
        }
        if (RequestOptions.isSet(requestOptions.fields, 0x100000)) {
            this.useAnimationPool = requestOptions.useAnimationPool;
        }
        if (RequestOptions.isSet(requestOptions.fields, 4)) {
            this.diskCacheStrategy = requestOptions.diskCacheStrategy;
        }
        if (RequestOptions.isSet(requestOptions.fields, 8)) {
            this.priority = requestOptions.priority;
        }
        if (RequestOptions.isSet(requestOptions.fields, 16)) {
            this.errorPlaceholder = requestOptions.errorPlaceholder;
        }
        if (RequestOptions.isSet(requestOptions.fields, 32)) {
            this.errorId = requestOptions.errorId;
        }
        if (RequestOptions.isSet(requestOptions.fields, 64)) {
            this.placeholderDrawable = requestOptions.placeholderDrawable;
        }
        if (RequestOptions.isSet(requestOptions.fields, 128)) {
            this.placeholderId = requestOptions.placeholderId;
        }
        if (RequestOptions.isSet(requestOptions.fields, 256)) {
            this.isCacheable = requestOptions.isCacheable;
        }
        if (RequestOptions.isSet(requestOptions.fields, 512)) {
            this.overrideWidth = requestOptions.overrideWidth;
            this.overrideHeight = requestOptions.overrideHeight;
        }
        if (RequestOptions.isSet(requestOptions.fields, 1024)) {
            this.signature = requestOptions.signature;
        }
        if (RequestOptions.isSet(requestOptions.fields, 4096)) {
            this.resourceClass = requestOptions.resourceClass;
        }
        if (RequestOptions.isSet(requestOptions.fields, 8192)) {
            this.fallbackDrawable = requestOptions.fallbackDrawable;
        }
        if (RequestOptions.isSet(requestOptions.fields, 16384)) {
            this.fallbackId = requestOptions.fallbackId;
        }
        if (RequestOptions.isSet(requestOptions.fields, 32768)) {
            this.theme = requestOptions.theme;
        }
        if (RequestOptions.isSet(requestOptions.fields, 65536)) {
            this.isTransformationAllowed = requestOptions.isTransformationAllowed;
        }
        if (RequestOptions.isSet(requestOptions.fields, 131072)) {
            this.isTransformationRequired = requestOptions.isTransformationRequired;
        }
        if (RequestOptions.isSet(requestOptions.fields, 2048)) {
            this.transformations.putAll(requestOptions.transformations);
            this.isScaleOnlyOrNoTransform = requestOptions.isScaleOnlyOrNoTransform;
        }
        if (RequestOptions.isSet(requestOptions.fields, 524288)) {
            this.onlyRetrieveFromCache = requestOptions.onlyRetrieveFromCache;
        }
        if (!this.isTransformationAllowed) {
            this.transformations.clear();
            this.fields &= 0xFFFFF7FF;
            this.isTransformationRequired = false;
            this.fields &= 0xFFFDFFFF;
            this.isScaleOnlyOrNoTransform = true;
        }
        this.fields |= requestOptions.fields;
        this.options.putAll(requestOptions.options);
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions autoClone() {
        if (this.isLocked && !this.isAutoCloneEnabled) {
            throw new IllegalStateException("You cannot auto lock an already locked options object, try clone() first");
        }
        this.isAutoCloneEnabled = true;
        return this.lock();
    }

    public RequestOptions centerCrop() {
        return this.transform(DownsampleStrategy.CENTER_OUTSIDE, new CenterCrop());
    }

    public RequestOptions centerInside() {
        return this.scaleOnlyTransform(DownsampleStrategy.CENTER_INSIDE, new CenterInside());
    }

    public RequestOptions circleCrop() {
        return this.transform(DownsampleStrategy.CENTER_INSIDE, new CircleCrop());
    }

    public RequestOptions clone() {
        try {
            RequestOptions requestOptions = (RequestOptions)super.clone();
            HashMap hashMap = new HashMap();
            requestOptions.options = hashMap;
            requestOptions.options.putAll(this.options);
            hashMap = new HashMap();
            requestOptions.transformations = hashMap;
            requestOptions.transformations.putAll(this.transformations);
            requestOptions.isLocked = false;
            requestOptions.isAutoCloneEnabled = false;
            return requestOptions;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public RequestOptions decode(Class<?> clazz) {
        if (this.isAutoCloneEnabled) {
            return this.clone().decode(clazz);
        }
        this.resourceClass = Preconditions.checkNotNull(clazz);
        this.fields |= 0x1000;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions disallowHardwareConfig() {
        return this.set(Downsampler.ALLOW_HARDWARE_CONFIG, false);
    }

    public RequestOptions diskCacheStrategy(DiskCacheStrategy diskCacheStrategy) {
        if (this.isAutoCloneEnabled) {
            return this.clone().diskCacheStrategy(diskCacheStrategy);
        }
        this.diskCacheStrategy = Preconditions.checkNotNull(diskCacheStrategy);
        this.fields |= 4;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions dontAnimate() {
        return this.set(GifOptions.DISABLE_ANIMATION, true);
    }

    public RequestOptions dontTransform() {
        if (this.isAutoCloneEnabled) {
            return this.clone().dontTransform();
        }
        this.transformations.clear();
        this.fields &= 0xFFFFF7FF;
        this.isTransformationRequired = false;
        this.fields &= 0xFFFDFFFF;
        this.isTransformationAllowed = false;
        this.fields |= 0x10000;
        this.isScaleOnlyOrNoTransform = true;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions downsample(DownsampleStrategy downsampleStrategy) {
        return this.set(Downsampler.DOWNSAMPLE_STRATEGY, Preconditions.checkNotNull(downsampleStrategy));
    }

    public RequestOptions encodeFormat(Bitmap.CompressFormat compressFormat) {
        return this.set(BitmapEncoder.COMPRESSION_FORMAT, Preconditions.checkNotNull(compressFormat));
    }

    public RequestOptions encodeQuality(int n2) {
        return this.set(BitmapEncoder.COMPRESSION_QUALITY, n2);
    }

    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = object instanceof RequestOptions;
        boolean bl3 = bl = false;
        if (bl2) {
            object = (RequestOptions)object;
            bl3 = bl;
            if (Float.compare(((RequestOptions)object).sizeMultiplier, this.sizeMultiplier) == 0) {
                bl3 = bl;
                if (this.errorId == ((RequestOptions)object).errorId) {
                    bl3 = bl;
                    if (Util.bothNullOrEqual(this.errorPlaceholder, ((RequestOptions)object).errorPlaceholder)) {
                        bl3 = bl;
                        if (this.placeholderId == ((RequestOptions)object).placeholderId) {
                            bl3 = bl;
                            if (Util.bothNullOrEqual(this.placeholderDrawable, ((RequestOptions)object).placeholderDrawable)) {
                                bl3 = bl;
                                if (this.fallbackId == ((RequestOptions)object).fallbackId) {
                                    bl3 = bl;
                                    if (Util.bothNullOrEqual(this.fallbackDrawable, ((RequestOptions)object).fallbackDrawable)) {
                                        bl3 = bl;
                                        if (this.isCacheable == ((RequestOptions)object).isCacheable) {
                                            bl3 = bl;
                                            if (this.overrideHeight == ((RequestOptions)object).overrideHeight) {
                                                bl3 = bl;
                                                if (this.overrideWidth == ((RequestOptions)object).overrideWidth) {
                                                    bl3 = bl;
                                                    if (this.isTransformationRequired == ((RequestOptions)object).isTransformationRequired) {
                                                        bl3 = bl;
                                                        if (this.isTransformationAllowed == ((RequestOptions)object).isTransformationAllowed) {
                                                            bl3 = bl;
                                                            if (this.useUnlimitedSourceGeneratorsPool == ((RequestOptions)object).useUnlimitedSourceGeneratorsPool) {
                                                                bl3 = bl;
                                                                if (this.onlyRetrieveFromCache == ((RequestOptions)object).onlyRetrieveFromCache) {
                                                                    bl3 = bl;
                                                                    if (this.diskCacheStrategy.equals(((RequestOptions)object).diskCacheStrategy)) {
                                                                        bl3 = bl;
                                                                        if (this.priority == ((RequestOptions)object).priority) {
                                                                            bl3 = bl;
                                                                            if (this.options.equals(((RequestOptions)object).options)) {
                                                                                bl3 = bl;
                                                                                if (this.transformations.equals(((RequestOptions)object).transformations)) {
                                                                                    bl3 = bl;
                                                                                    if (this.resourceClass.equals(((RequestOptions)object).resourceClass)) {
                                                                                        bl3 = bl;
                                                                                        if (Util.bothNullOrEqual(this.signature, ((RequestOptions)object).signature)) {
                                                                                            bl3 = bl;
                                                                                            if (Util.bothNullOrEqual(this.theme, ((RequestOptions)object).theme)) {
                                                                                                bl3 = true;
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl3;
    }

    public RequestOptions error(int n2) {
        if (this.isAutoCloneEnabled) {
            return this.clone().error(n2);
        }
        this.errorId = n2;
        this.fields |= 0x20;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions error(Drawable drawable2) {
        if (this.isAutoCloneEnabled) {
            return this.clone().error(drawable2);
        }
        this.errorPlaceholder = drawable2;
        this.fields |= 0x10;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions fallback(int n2) {
        if (this.isAutoCloneEnabled) {
            return this.clone().fallback(n2);
        }
        this.fallbackId = n2;
        this.fields |= 0x4000;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions fallback(Drawable drawable2) {
        if (this.isAutoCloneEnabled) {
            return this.clone().fallback(drawable2);
        }
        this.fallbackDrawable = drawable2;
        this.fields |= 0x2000;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions fitCenter() {
        return this.scaleOnlyTransform(DownsampleStrategy.FIT_CENTER, new FitCenter());
    }

    public RequestOptions format(DecodeFormat decodeFormat) {
        Preconditions.checkNotNull(decodeFormat);
        return this.set(Downsampler.DECODE_FORMAT, decodeFormat).set(GifOptions.DECODE_FORMAT, decodeFormat);
    }

    public RequestOptions frame(long l3) {
        return this.set(VideoDecoder.TARGET_FRAME, l3);
    }

    public final DiskCacheStrategy getDiskCacheStrategy() {
        return this.diskCacheStrategy;
    }

    public final int getErrorId() {
        return this.errorId;
    }

    public final Drawable getErrorPlaceholder() {
        return this.errorPlaceholder;
    }

    public final Drawable getFallbackDrawable() {
        return this.fallbackDrawable;
    }

    public final int getFallbackId() {
        return this.fallbackId;
    }

    public final boolean getOnlyRetrieveFromCache() {
        return this.onlyRetrieveFromCache;
    }

    public final Options getOptions() {
        return this.options;
    }

    public final int getOverrideHeight() {
        return this.overrideHeight;
    }

    public final int getOverrideWidth() {
        return this.overrideWidth;
    }

    public final Drawable getPlaceholderDrawable() {
        return this.placeholderDrawable;
    }

    public final int getPlaceholderId() {
        return this.placeholderId;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public final Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public final Key getSignature() {
        return this.signature;
    }

    public final float getSizeMultiplier() {
        return this.sizeMultiplier;
    }

    public final Resources.Theme getTheme() {
        return this.theme;
    }

    public final Map<Class<?>, Transformation<?>> getTransformations() {
        return this.transformations;
    }

    public final boolean getUseAnimationPool() {
        return this.useAnimationPool;
    }

    public final boolean getUseUnlimitedSourceGeneratorsPool() {
        return this.useUnlimitedSourceGeneratorsPool;
    }

    public int hashCode() {
        int n2 = Util.hashCode(this.sizeMultiplier);
        n2 = Util.hashCode(this.errorId, n2);
        n2 = Util.hashCode(this.errorPlaceholder, n2);
        n2 = Util.hashCode(this.placeholderId, n2);
        n2 = Util.hashCode(this.placeholderDrawable, n2);
        n2 = Util.hashCode(this.fallbackId, n2);
        n2 = Util.hashCode(this.fallbackDrawable, n2);
        n2 = Util.hashCode(this.isCacheable, n2);
        n2 = Util.hashCode(this.overrideHeight, n2);
        n2 = Util.hashCode(this.overrideWidth, n2);
        n2 = Util.hashCode(this.isTransformationRequired, n2);
        n2 = Util.hashCode(this.isTransformationAllowed, n2);
        n2 = Util.hashCode(this.useUnlimitedSourceGeneratorsPool, n2);
        n2 = Util.hashCode(this.onlyRetrieveFromCache, n2);
        n2 = Util.hashCode(this.diskCacheStrategy, n2);
        n2 = Util.hashCode((Object)this.priority, n2);
        n2 = Util.hashCode(this.options, n2);
        n2 = Util.hashCode(this.transformations, n2);
        n2 = Util.hashCode(this.resourceClass, n2);
        n2 = Util.hashCode(this.signature, n2);
        return Util.hashCode(this.theme, n2);
    }

    protected boolean isAutoCloneEnabled() {
        return this.isAutoCloneEnabled;
    }

    public final boolean isDiskCacheStrategySet() {
        return this.isSet(4);
    }

    public final boolean isLocked() {
        return this.isLocked;
    }

    public final boolean isMemoryCacheable() {
        return this.isCacheable;
    }

    public final boolean isPrioritySet() {
        return this.isSet(8);
    }

    boolean isScaleOnlyOrNoTransform() {
        return this.isScaleOnlyOrNoTransform;
    }

    public final boolean isSkipMemoryCacheSet() {
        return this.isSet(256);
    }

    public final boolean isTransformationAllowed() {
        return this.isTransformationAllowed;
    }

    public final boolean isTransformationRequired() {
        return this.isTransformationRequired;
    }

    public final boolean isTransformationSet() {
        return this.isSet(2048);
    }

    public final boolean isValidOverride() {
        return Util.isValidDimensions(this.overrideWidth, this.overrideHeight);
    }

    public RequestOptions lock() {
        this.isLocked = true;
        return this;
    }

    public RequestOptions onlyRetrieveFromCache(boolean bl) {
        if (this.isAutoCloneEnabled) {
            return this.clone().onlyRetrieveFromCache(bl);
        }
        this.onlyRetrieveFromCache = bl;
        this.fields |= 0x80000;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions optionalCenterCrop() {
        return this.optionalTransform(DownsampleStrategy.CENTER_OUTSIDE, new CenterCrop());
    }

    public RequestOptions optionalCenterInside() {
        return this.optionalScaleOnlyTransform(DownsampleStrategy.CENTER_INSIDE, new CenterInside());
    }

    public RequestOptions optionalCircleCrop() {
        return this.optionalTransform(DownsampleStrategy.CENTER_OUTSIDE, new CircleCrop());
    }

    public RequestOptions optionalFitCenter() {
        return this.optionalScaleOnlyTransform(DownsampleStrategy.FIT_CENTER, new FitCenter());
    }

    public RequestOptions optionalTransform(Transformation<Bitmap> transformation) {
        return this.transform(transformation, false);
    }

    final RequestOptions optionalTransform(DownsampleStrategy downsampleStrategy, Transformation<Bitmap> transformation) {
        if (this.isAutoCloneEnabled) {
            return this.clone().optionalTransform(downsampleStrategy, transformation);
        }
        this.downsample(downsampleStrategy);
        return this.transform(transformation, false);
    }

    public <T> RequestOptions optionalTransform(Class<T> clazz, Transformation<T> transformation) {
        return this.transform(clazz, transformation, false);
    }

    public RequestOptions override(int n2) {
        return this.override(n2, n2);
    }

    public RequestOptions override(int n2, int n3) {
        if (this.isAutoCloneEnabled) {
            return this.clone().override(n2, n3);
        }
        this.overrideWidth = n2;
        this.overrideHeight = n3;
        this.fields |= 0x200;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions placeholder(int n2) {
        if (this.isAutoCloneEnabled) {
            return this.clone().placeholder(n2);
        }
        this.placeholderId = n2;
        this.fields |= 0x80;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions placeholder(Drawable drawable2) {
        if (this.isAutoCloneEnabled) {
            return this.clone().placeholder(drawable2);
        }
        this.placeholderDrawable = drawable2;
        this.fields |= 0x40;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions priority(Priority priority) {
        if (this.isAutoCloneEnabled) {
            return this.clone().priority(priority);
        }
        this.priority = Preconditions.checkNotNull(priority);
        this.fields |= 8;
        return this.selfOrThrowIfLocked();
    }

    public <T> RequestOptions set(Option<T> option, T t2) {
        if (this.isAutoCloneEnabled) {
            return this.clone().set(option, t2);
        }
        Preconditions.checkNotNull(option);
        Preconditions.checkNotNull(t2);
        this.options.set(option, t2);
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions signature(Key key) {
        if (this.isAutoCloneEnabled) {
            return this.clone().signature(key);
        }
        this.signature = Preconditions.checkNotNull(key);
        this.fields |= 0x400;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions sizeMultiplier(float f3) {
        if (this.isAutoCloneEnabled) {
            return this.clone().sizeMultiplier(f3);
        }
        if (!(f3 < 0.0f) && !(f3 > 1.0f)) {
            this.sizeMultiplier = f3;
            this.fields |= 2;
            return this.selfOrThrowIfLocked();
        }
        throw new IllegalArgumentException("sizeMultiplier must be between 0 and 1");
    }

    public RequestOptions skipMemoryCache(boolean bl) {
        if (this.isAutoCloneEnabled) {
            return this.clone().skipMemoryCache(true);
        }
        this.isCacheable = bl ^ true;
        this.fields |= 0x100;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions theme(Resources.Theme theme) {
        if (this.isAutoCloneEnabled) {
            return this.clone().theme(theme);
        }
        this.theme = theme;
        this.fields |= 0x8000;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions timeout(int n2) {
        return this.set(HttpGlideUrlLoader.TIMEOUT, n2);
    }

    public RequestOptions transform(Transformation<Bitmap> transformation) {
        return this.transform(transformation, true);
    }

    final RequestOptions transform(DownsampleStrategy downsampleStrategy, Transformation<Bitmap> transformation) {
        if (this.isAutoCloneEnabled) {
            return this.clone().transform(downsampleStrategy, transformation);
        }
        this.downsample(downsampleStrategy);
        return this.transform(transformation);
    }

    public <T> RequestOptions transform(Class<T> clazz, Transformation<T> transformation) {
        return this.transform(clazz, transformation, true);
    }

    public RequestOptions transforms(Transformation<Bitmap> ... transformationArray) {
        return this.transform(new MultiTransformation<Bitmap>(transformationArray), true);
    }

    public RequestOptions useAnimationPool(boolean bl) {
        if (this.isAutoCloneEnabled) {
            return this.clone().useAnimationPool(bl);
        }
        this.useAnimationPool = bl;
        this.fields |= 0x100000;
        return this.selfOrThrowIfLocked();
    }

    public RequestOptions useUnlimitedSourceGeneratorsPool(boolean bl) {
        if (this.isAutoCloneEnabled) {
            return this.clone().useUnlimitedSourceGeneratorsPool(bl);
        }
        this.useUnlimitedSourceGeneratorsPool = bl;
        this.fields |= 0x40000;
        return this.selfOrThrowIfLocked();
    }
}

