/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.SizeReadyCallback;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.util.Util;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFutureTarget<R>
implements FutureTarget<R>,
RequestListener<R>,
Runnable {
    private static final Waiter DEFAULT_WAITER = new Waiter();
    private final boolean assertBackgroundThread;
    private GlideException exception;
    private final int height;
    private boolean isCancelled;
    private boolean loadFailed;
    private final Handler mainHandler;
    private Request request;
    private R resource;
    private boolean resultReceived;
    private final Waiter waiter;
    private final int width;

    public RequestFutureTarget(Handler handler, int n2, int n3) {
        this(handler, n2, n3, true, DEFAULT_WAITER);
    }

    RequestFutureTarget(Handler handler, int n2, int n3, boolean bl, Waiter waiter) {
        this.mainHandler = handler;
        this.width = n2;
        this.height = n3;
        this.assertBackgroundThread = bl;
        this.waiter = waiter;
    }

    private void clearOnMainThread() {
        this.mainHandler.post((Runnable)this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R doGet(Long serializable) throws ExecutionException, InterruptedException, TimeoutException {
        synchronized (this) {
            if (this.assertBackgroundThread && !this.isDone()) {
                Util.assertBackgroundThread();
            }
            if (this.isCancelled) {
                serializable = new CancellationException();
                throw serializable;
            }
            if (this.loadFailed) {
                serializable = new ExecutionException(this.exception);
                throw serializable;
            }
            if (this.resultReceived) {
                serializable = this.resource;
                return (R)serializable;
            }
            if (serializable == null) {
                this.waiter.waitForTimeout(this, 0L);
            } else if (serializable > 0L) {
                long l3 = System.currentTimeMillis();
                long l4 = serializable + l3;
                while (!this.isDone() && l3 < l4) {
                    this.waiter.waitForTimeout(this, l4 - l3);
                    l3 = System.currentTimeMillis();
                }
            }
            if (Thread.interrupted()) {
                serializable = new InterruptedException();
                throw serializable;
            }
            if (this.loadFailed) {
                serializable = new ExecutionException(this.exception);
                throw serializable;
            }
            if (this.isCancelled) {
                serializable = new CancellationException();
                throw serializable;
            }
            if (this.resultReceived) {
                serializable = this.resource;
                return (R)serializable;
            }
            serializable = new TimeoutException();
            throw serializable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean cancel(boolean bl) {
        synchronized (this) {
            boolean bl2 = this.isDone();
            if (bl2) {
                return false;
            }
            this.isCancelled = true;
            this.waiter.notifyAll(this);
            if (bl) {
                this.clearOnMainThread();
            }
            return true;
        }
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        R r2;
        try {
            r2 = this.doGet(null);
        }
        catch (TimeoutException timeoutException) {
            throw new AssertionError((Object)timeoutException);
        }
        return r2;
    }

    @Override
    public R get(long l3, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doGet(timeUnit.toMillis(l3));
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void getSize(SizeReadyCallback sizeReadyCallback) {
        sizeReadyCallback.onSizeReady(this.width, this.height);
    }

    @Override
    public boolean isCancelled() {
        synchronized (this) {
            boolean bl = this.isCancelled;
            return bl;
        }
    }

    @Override
    public boolean isDone() {
        synchronized (this) {
            boolean bl;
            block4: {
                if (!(this.isCancelled || this.resultReceived || (bl = this.loadFailed))) {
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            return bl;
        }
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public void onLoadCleared(Drawable drawable2) {
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onLoadFailed(Drawable drawable2) {
        // MONITORENTER : this
        // MONITOREXIT : this
    }

    @Override
    public boolean onLoadFailed(GlideException glideException, Object object, Target<R> target, boolean bl) {
        synchronized (this) {
            this.loadFailed = true;
            this.exception = glideException;
            this.waiter.notifyAll(this);
            return false;
        }
    }

    @Override
    public void onLoadStarted(Drawable drawable2) {
    }

    /*
     * Enabled aggressive block sorting
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onResourceReady(R r2, Transition<? super R> transition) {
        // MONITORENTER : this
        // MONITOREXIT : this
    }

    @Override
    public boolean onResourceReady(R r2, Object object, Target<R> target, DataSource dataSource, boolean bl) {
        synchronized (this) {
            this.resultReceived = true;
            this.resource = r2;
            this.waiter.notifyAll(this);
            return false;
        }
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void removeCallback(SizeReadyCallback sizeReadyCallback) {
    }

    @Override
    public void run() {
        Request request = this.request;
        if (request != null) {
            request.clear();
            this.request = null;
        }
    }

    @Override
    public void setRequest(Request request) {
        this.request = request;
    }

    static class Waiter {
        Waiter() {
        }

        void notifyAll(Object object) {
            object.notifyAll();
        }

        void waitForTimeout(Object object, long l3) throws InterruptedException {
            object.wait(l3);
        }
    }
}

