/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import com.bumptech.glide.request.Request;
import com.bumptech.glide.request.RequestCoordinator;

public final class ErrorRequestCoordinator
implements RequestCoordinator,
Request {
    private Request error;
    private final RequestCoordinator parent;
    private Request primary;

    public ErrorRequestCoordinator(RequestCoordinator requestCoordinator) {
        this.parent = requestCoordinator;
    }

    private boolean isValidRequest(Request request) {
        boolean bl = request.equals(this.primary) || this.primary.isFailed() && request.equals(this.error);
        return bl;
    }

    private boolean parentCanNotifyCleared() {
        RequestCoordinator requestCoordinator = this.parent;
        boolean bl = requestCoordinator == null || requestCoordinator.canNotifyCleared(this);
        return bl;
    }

    private boolean parentCanNotifyStatusChanged() {
        RequestCoordinator requestCoordinator = this.parent;
        boolean bl = requestCoordinator == null || requestCoordinator.canNotifyStatusChanged(this);
        return bl;
    }

    private boolean parentCanSetImage() {
        RequestCoordinator requestCoordinator = this.parent;
        boolean bl = requestCoordinator == null || requestCoordinator.canSetImage(this);
        return bl;
    }

    private boolean parentIsAnyResourceSet() {
        RequestCoordinator requestCoordinator = this.parent;
        boolean bl = requestCoordinator != null && requestCoordinator.isAnyResourceSet();
        return bl;
    }

    @Override
    public void begin() {
        if (!this.primary.isRunning()) {
            this.primary.begin();
        }
    }

    @Override
    public boolean canNotifyCleared(Request request) {
        boolean bl = this.parentCanNotifyCleared() && this.isValidRequest(request);
        return bl;
    }

    @Override
    public boolean canNotifyStatusChanged(Request request) {
        boolean bl = this.parentCanNotifyStatusChanged() && this.isValidRequest(request);
        return bl;
    }

    @Override
    public boolean canSetImage(Request request) {
        boolean bl = this.parentCanSetImage() && this.isValidRequest(request);
        return bl;
    }

    @Override
    public void clear() {
        this.primary.clear();
        if (this.error.isRunning()) {
            this.error.clear();
        }
    }

    @Override
    public boolean isAnyResourceSet() {
        boolean bl = this.parentIsAnyResourceSet() || this.isResourceSet();
        return bl;
    }

    @Override
    public boolean isCancelled() {
        Request request = this.primary.isFailed() ? this.error : this.primary;
        return request.isCancelled();
    }

    @Override
    public boolean isComplete() {
        Request request = this.primary.isFailed() ? this.error : this.primary;
        return request.isComplete();
    }

    @Override
    public boolean isEquivalentTo(Request request) {
        boolean bl;
        boolean bl2 = request instanceof ErrorRequestCoordinator;
        boolean bl3 = bl = false;
        if (bl2) {
            request = (ErrorRequestCoordinator)request;
            bl3 = bl;
            if (this.primary.isEquivalentTo(((ErrorRequestCoordinator)request).primary)) {
                bl3 = bl;
                if (this.error.isEquivalentTo(((ErrorRequestCoordinator)request).error)) {
                    bl3 = true;
                }
            }
        }
        return bl3;
    }

    @Override
    public boolean isFailed() {
        boolean bl = this.primary.isFailed() && this.error.isFailed();
        return bl;
    }

    @Override
    public boolean isPaused() {
        Request request = this.primary.isFailed() ? this.error : this.primary;
        return request.isPaused();
    }

    @Override
    public boolean isResourceSet() {
        Request request = this.primary.isFailed() ? this.error : this.primary;
        return request.isResourceSet();
    }

    @Override
    public boolean isRunning() {
        Request request = this.primary.isFailed() ? this.error : this.primary;
        return request.isRunning();
    }

    @Override
    public void onRequestFailed(Request object) {
        if (!object.equals(this.error)) {
            if (!this.error.isRunning()) {
                this.error.begin();
            }
            return;
        }
        object = this.parent;
        if (object != null) {
            object.onRequestFailed(this);
        }
    }

    @Override
    public void onRequestSuccess(Request object) {
        object = this.parent;
        if (object != null) {
            object.onRequestSuccess(this);
        }
    }

    @Override
    public void pause() {
        if (!this.primary.isFailed()) {
            this.primary.pause();
        }
        if (this.error.isRunning()) {
            this.error.pause();
        }
    }

    @Override
    public void recycle() {
        this.primary.recycle();
        this.error.recycle();
    }

    public void setRequests(Request request, Request request2) {
        this.primary = request;
        this.error = request2;
    }
}

