/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.provider;

import androidx.collection.ArrayMap;
import com.bumptech.glide.util.MultiClassKey;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ModelToResourceClassCache {
    private final ArrayMap<MultiClassKey, List<Class<?>>> registeredResourceClassCache;
    private final AtomicReference<MultiClassKey> resourceClassKeyRef = new AtomicReference();

    public ModelToResourceClassCache() {
        this.registeredResourceClassCache = new ArrayMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        ArrayMap<MultiClassKey, List<Class<?>>> arrayMap = this.registeredResourceClassCache;
        synchronized (arrayMap) {
            this.registeredResourceClassCache.clear();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Class<?>> get(Class<?> object, Class<?> clazz) {
        Object object2 = this.resourceClassKeyRef.getAndSet(null);
        if (object2 == null) {
            object = new MultiClassKey((Class<?>)object, clazz);
        } else {
            ((MultiClassKey)object2).set((Class<?>)object, clazz);
            object = object2;
        }
        clazz = this.registeredResourceClassCache;
        synchronized (clazz) {
            object2 = (List)this.registeredResourceClassCache.get(object);
        }
        this.resourceClassKeyRef.set((MultiClassKey)object);
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        ArrayMap<MultiClassKey, List<Class<?>>> arrayMap = this.registeredResourceClassCache;
        synchronized (arrayMap) {
            ArrayMap<MultiClassKey, List<Class<?>>> arrayMap2 = this.registeredResourceClassCache;
            MultiClassKey multiClassKey = new MultiClassKey(clazz, clazz2);
            arrayMap2.put((Object)multiClassKey, list);
            return;
        }
    }
}

