/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.gif;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.signature.ObjectKey;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

class GifFrameLoader {
    private final BitmapPool bitmapPool;
    private final List<FrameCallback> callbacks = new ArrayList<FrameCallback>();
    private DelayTarget current;
    private Bitmap firstFrame;
    private final GifDecoder gifDecoder;
    private final Handler handler;
    private boolean isCleared;
    private boolean isLoadPending;
    private boolean isRunning;
    private DelayTarget next;
    private OnEveryFrameListener onEveryFrameListener;
    private DelayTarget pendingTarget;
    private RequestBuilder<Bitmap> requestBuilder;
    final RequestManager requestManager;
    private boolean startFromFirstFrame;
    private Transformation<Bitmap> transformation;

    GifFrameLoader(Glide glide, GifDecoder gifDecoder, int n2, int n3, Transformation<Bitmap> transformation, Bitmap bitmap2) {
        this(glide.getBitmapPool(), Glide.with(glide.getContext()), gifDecoder, null, GifFrameLoader.getRequestBuilder(Glide.with(glide.getContext()), n2, n3), transformation, bitmap2);
    }

    GifFrameLoader(BitmapPool bitmapPool, RequestManager requestManager, GifDecoder gifDecoder, Handler handler, RequestBuilder<Bitmap> requestBuilder, Transformation<Bitmap> transformation, Bitmap bitmap2) {
        this.requestManager = requestManager;
        requestManager = handler;
        if (handler == null) {
            requestManager = new Handler(Looper.getMainLooper(), (Handler.Callback)new FrameLoaderCallback());
        }
        this.bitmapPool = bitmapPool;
        this.handler = requestManager;
        this.requestBuilder = requestBuilder;
        this.gifDecoder = gifDecoder;
        this.setFrameTransformation(transformation, bitmap2);
    }

    private static Key getFrameSignature() {
        return new ObjectKey(Math.random());
    }

    private int getFrameSize() {
        return Util.getBitmapByteSize(this.getCurrentFrame().getWidth(), this.getCurrentFrame().getHeight(), this.getCurrentFrame().getConfig());
    }

    private static RequestBuilder<Bitmap> getRequestBuilder(RequestManager requestManager, int n2, int n3) {
        return requestManager.asBitmap().apply(RequestOptions.diskCacheStrategyOf(DiskCacheStrategy.NONE).useAnimationPool(true).skipMemoryCache(true).override(n2, n3));
    }

    private void loadNextFrame() {
        if (this.isRunning && !this.isLoadPending) {
            DelayTarget delayTarget;
            if (this.startFromFirstFrame) {
                boolean bl = this.pendingTarget == null;
                Preconditions.checkArgument(bl, "Pending target must be null when starting from the first frame");
                this.gifDecoder.resetFrameIndex();
                this.startFromFirstFrame = false;
            }
            if ((delayTarget = this.pendingTarget) != null) {
                this.pendingTarget = null;
                this.onFrameReady(delayTarget);
                return;
            }
            this.isLoadPending = true;
            int n2 = this.gifDecoder.getNextDelay();
            long l3 = SystemClock.uptimeMillis();
            long l4 = n2;
            this.gifDecoder.advance();
            this.next = new DelayTarget(this.handler, this.gifDecoder.getCurrentFrameIndex(), l3 + l4);
            ((RequestBuilder)this.requestBuilder.apply(RequestOptions.signatureOf(GifFrameLoader.getFrameSignature())).load(this.gifDecoder)).into(this.next);
        }
    }

    private void recycleFirstFrame() {
        Bitmap bitmap2 = this.firstFrame;
        if (bitmap2 != null) {
            this.bitmapPool.put(bitmap2);
            this.firstFrame = null;
        }
    }

    private void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.isCleared = false;
        this.loadNextFrame();
    }

    private void stop() {
        this.isRunning = false;
    }

    void clear() {
        this.callbacks.clear();
        this.recycleFirstFrame();
        this.stop();
        DelayTarget delayTarget = this.current;
        if (delayTarget != null) {
            this.requestManager.clear(delayTarget);
            this.current = null;
        }
        if ((delayTarget = this.next) != null) {
            this.requestManager.clear(delayTarget);
            this.next = null;
        }
        if ((delayTarget = this.pendingTarget) != null) {
            this.requestManager.clear(delayTarget);
            this.pendingTarget = null;
        }
        this.gifDecoder.clear();
        this.isCleared = true;
    }

    ByteBuffer getBuffer() {
        return this.gifDecoder.getData().asReadOnlyBuffer();
    }

    Bitmap getCurrentFrame() {
        DelayTarget delayTarget = this.current;
        delayTarget = delayTarget != null ? delayTarget.getResource() : this.firstFrame;
        return delayTarget;
    }

    int getCurrentIndex() {
        DelayTarget delayTarget = this.current;
        int n2 = delayTarget != null ? delayTarget.index : -1;
        return n2;
    }

    Bitmap getFirstFrame() {
        return this.firstFrame;
    }

    int getFrameCount() {
        return this.gifDecoder.getFrameCount();
    }

    Transformation<Bitmap> getFrameTransformation() {
        return this.transformation;
    }

    int getHeight() {
        return this.getCurrentFrame().getHeight();
    }

    int getLoopCount() {
        return this.gifDecoder.getTotalIterationCount();
    }

    int getSize() {
        return this.gifDecoder.getByteSize() + this.getFrameSize();
    }

    int getWidth() {
        return this.getCurrentFrame().getWidth();
    }

    void onFrameReady(DelayTarget delayTarget) {
        Object object = this.onEveryFrameListener;
        if (object != null) {
            object.onFrameReady();
        }
        this.isLoadPending = false;
        if (this.isCleared) {
            this.handler.obtainMessage(2, (Object)delayTarget).sendToTarget();
            return;
        }
        if (!this.isRunning) {
            this.pendingTarget = delayTarget;
            return;
        }
        if (delayTarget.getResource() != null) {
            this.recycleFirstFrame();
            object = this.current;
            this.current = delayTarget;
            for (int i3 = this.callbacks.size() - 1; i3 >= 0; --i3) {
                this.callbacks.get(i3).onFrameReady();
            }
            if (object != null) {
                this.handler.obtainMessage(2, object).sendToTarget();
            }
        }
        this.loadNextFrame();
    }

    void setFrameTransformation(Transformation<Bitmap> transformation, Bitmap bitmap2) {
        this.transformation = Preconditions.checkNotNull(transformation);
        this.firstFrame = Preconditions.checkNotNull(bitmap2);
        this.requestBuilder = this.requestBuilder.apply(new RequestOptions().transform(transformation));
    }

    void setNextStartFromFirstFrame() {
        Preconditions.checkArgument(this.isRunning ^ true, "Can't restart a running animation");
        this.startFromFirstFrame = true;
        DelayTarget delayTarget = this.pendingTarget;
        if (delayTarget != null) {
            this.requestManager.clear(delayTarget);
            this.pendingTarget = null;
        }
    }

    void setOnEveryFrameReadyListener(OnEveryFrameListener onEveryFrameListener) {
        this.onEveryFrameListener = onEveryFrameListener;
    }

    void subscribe(FrameCallback frameCallback) {
        if (!this.isCleared) {
            if (!this.callbacks.contains(frameCallback)) {
                boolean bl = this.callbacks.isEmpty();
                this.callbacks.add(frameCallback);
                if (bl) {
                    this.start();
                }
                return;
            }
            throw new IllegalStateException("Cannot subscribe twice in a row");
        }
        throw new IllegalStateException("Cannot subscribe to a cleared frame loader");
    }

    void unsubscribe(FrameCallback frameCallback) {
        this.callbacks.remove(frameCallback);
        if (this.callbacks.isEmpty()) {
            this.stop();
        }
    }

    static class DelayTarget
    extends SimpleTarget<Bitmap> {
        private final Handler handler;
        final int index;
        private Bitmap resource;
        private final long targetTime;

        DelayTarget(Handler handler, int n2, long l3) {
            this.handler = handler;
            this.index = n2;
            this.targetTime = l3;
        }

        Bitmap getResource() {
            return this.resource;
        }

        @Override
        public void onResourceReady(Bitmap bitmap2, Transition<? super Bitmap> transition) {
            this.resource = bitmap2;
            bitmap2 = this.handler.obtainMessage(1, (Object)this);
            this.handler.sendMessageAtTime((Message)bitmap2, this.targetTime);
        }
    }

    public static interface FrameCallback {
        public void onFrameReady();
    }

    private class FrameLoaderCallback
    implements Handler.Callback {
        static final int MSG_CLEAR = 2;
        static final int MSG_DELAY = 1;

        FrameLoaderCallback() {
        }

        public boolean handleMessage(Message object) {
            if (object.what == 1) {
                object = (DelayTarget)object.obj;
                GifFrameLoader.this.onFrameReady((DelayTarget)object);
                return true;
            }
            if (object.what == 2) {
                object = (DelayTarget)object.obj;
                GifFrameLoader.this.requestManager.clear((Target<?>)object);
            }
            return false;
        }
    }

    static interface OnEveryFrameListener {
        public void onFrameReady();
    }
}

