/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.gif;

import android.graphics.Bitmap;
import com.bumptech.glide.gifdecoder.GifDecoder;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;

public final class GifBitmapProvider
implements GifDecoder.BitmapProvider {
    private final ArrayPool arrayPool;
    private final BitmapPool bitmapPool;

    public GifBitmapProvider(BitmapPool bitmapPool) {
        this(bitmapPool, null);
    }

    public GifBitmapProvider(BitmapPool bitmapPool, ArrayPool arrayPool) {
        this.bitmapPool = bitmapPool;
        this.arrayPool = arrayPool;
    }

    @Override
    public Bitmap obtain(int n2, int n3, Bitmap.Config config) {
        return this.bitmapPool.getDirty(n2, n3, config);
    }

    @Override
    public byte[] obtainByteArray(int n2) {
        ArrayPool arrayPool = this.arrayPool;
        if (arrayPool == null) {
            return new byte[n2];
        }
        return arrayPool.get(n2, byte[].class);
    }

    @Override
    public int[] obtainIntArray(int n2) {
        ArrayPool arrayPool = this.arrayPool;
        if (arrayPool == null) {
            return new int[n2];
        }
        return arrayPool.get(n2, int[].class);
    }

    @Override
    public void release(Bitmap bitmap2) {
        this.bitmapPool.put(bitmap2);
    }

    @Override
    public void release(byte[] byArray) {
        ArrayPool arrayPool = this.arrayPool;
        if (arrayPool == null) {
            return;
        }
        arrayPool.put(byArray);
    }

    @Override
    public void release(int[] nArray) {
        ArrayPool arrayPool = this.arrayPool;
        if (arrayPool == null) {
            return;
        }
        arrayPool.put(nArray);
    }
}

