/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.drawable;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.res.ResourcesCompat;

public final class DrawableDecoderCompat {
    private static volatile boolean shouldCallAppCompatResources = true;

    private DrawableDecoderCompat() {
    }

    public static Drawable getDrawable(Context context, int n2) {
        return DrawableDecoderCompat.getDrawable(context, n2, null);
    }

    public static Drawable getDrawable(Context context, int n2, Resources.Theme theme) {
        try {
            if (shouldCallAppCompatResources) {
                Drawable drawable2 = DrawableDecoderCompat.loadDrawableV7(context, n2);
                return drawable2;
            }
        }
        catch (Resources.NotFoundException notFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            shouldCallAppCompatResources = false;
        }
        if (theme == null) {
            theme = context.getTheme();
        }
        return DrawableDecoderCompat.loadDrawableV4(context, n2, theme);
    }

    private static Drawable loadDrawableV4(Context context, int n2, Resources.Theme theme) {
        return ResourcesCompat.getDrawable((Resources)context.getResources(), (int)n2, (Resources.Theme)theme);
    }

    private static Drawable loadDrawableV7(Context context, int n2) {
        return AppCompatResources.getDrawable((Context)context, (int)n2);
    }
}

