/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class VideoDecoder<T>
implements ResourceDecoder<T, Bitmap> {
    private static final MediaMetadataRetrieverFactory DEFAULT_FACTORY;
    public static final long DEFAULT_FRAME = -1L;
    static final int DEFAULT_FRAME_OPTION = 2;
    public static final Option<Integer> FRAME_OPTION;
    public static final Option<Long> TARGET_FRAME;
    private final BitmapPool bitmapPool;
    private final MediaMetadataRetrieverFactory factory;
    private final MediaMetadataRetrieverInitializer<T> initializer;

    static {
        TARGET_FRAME = Option.disk("com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.TargetFrame", -1L, new Option.CacheKeyUpdater<Long>(){
            private final ByteBuffer buffer = ByteBuffer.allocate(8);

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void update(byte[] object, Long l3, MessageDigest messageDigest) {
                messageDigest.update((byte[])object);
                object = this.buffer;
                synchronized (object) {
                    this.buffer.position(0);
                    messageDigest.update(this.buffer.putLong(l3).array());
                    return;
                }
            }
        });
        FRAME_OPTION = Option.disk("com.bumptech.glide.load.resource.bitmap.VideoBitmapDecode.FrameOption", 2, new Option.CacheKeyUpdater<Integer>(){
            private final ByteBuffer buffer = ByteBuffer.allocate(4);

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void update(byte[] object, Integer n2, MessageDigest messageDigest) {
                if (n2 == null) {
                    return;
                }
                messageDigest.update((byte[])object);
                object = this.buffer;
                synchronized (object) {
                    this.buffer.position(0);
                    messageDigest.update(this.buffer.putInt(n2).array());
                    return;
                }
            }
        });
        DEFAULT_FACTORY = new MediaMetadataRetrieverFactory();
    }

    VideoDecoder(BitmapPool bitmapPool, MediaMetadataRetrieverInitializer<T> mediaMetadataRetrieverInitializer) {
        this(bitmapPool, mediaMetadataRetrieverInitializer, DEFAULT_FACTORY);
    }

    VideoDecoder(BitmapPool bitmapPool, MediaMetadataRetrieverInitializer<T> mediaMetadataRetrieverInitializer, MediaMetadataRetrieverFactory mediaMetadataRetrieverFactory) {
        this.bitmapPool = bitmapPool;
        this.initializer = mediaMetadataRetrieverInitializer;
        this.factory = mediaMetadataRetrieverFactory;
    }

    public static ResourceDecoder<AssetFileDescriptor, Bitmap> asset(BitmapPool bitmapPool) {
        return new VideoDecoder<AssetFileDescriptor>(bitmapPool, new AssetFileDescriptorInitializer());
    }

    private static Bitmap decodeFrame(MediaMetadataRetriever mediaMetadataRetriever, long l3, int n2, int n3, int n4) {
        if (Build.VERSION.SDK_INT >= 27 && n3 != Integer.MIN_VALUE && n4 != Integer.MIN_VALUE) {
            return mediaMetadataRetriever.getScaledFrameAtTime(l3, n2, n3, n4);
        }
        return mediaMetadataRetriever.getFrameAtTime(l3, n2);
    }

    public static ResourceDecoder<ParcelFileDescriptor, Bitmap> parcel(BitmapPool bitmapPool) {
        return new VideoDecoder<ParcelFileDescriptor>(bitmapPool, new ParcelFileDescriptorInitializer());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Resource<Bitmap> decode(T object, int n2, int n3, Options object2) throws IOException {
        Throwable throwable2222222;
        Integer n4;
        block6: {
            long l3 = ((Options)object2).get(TARGET_FRAME);
            if (l3 < 0L && l3 != -1L) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Requested frame must be non-negative, or DEFAULT_FRAME, given: ");
                ((StringBuilder)object).append(l3);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            n4 = ((Options)object2).get(FRAME_OPTION);
            object2 = n4;
            if (n4 == null) {
                object2 = 2;
            }
            n4 = this.factory.build();
            this.initializer.initialize((MediaMetadataRetriever)n4, object);
            object = VideoDecoder.decodeFrame((MediaMetadataRetriever)n4, l3, (Integer)object2, n2, n3);
            {
                catch (Throwable throwable2222222) {
                    break block6;
                }
                catch (RuntimeException runtimeException) {}
                {
                    object = new IOException(runtimeException);
                    throw object;
                }
            }
            n4.release();
            return BitmapResource.obtain((Bitmap)object, this.bitmapPool);
        }
        n4.release();
        throw throwable2222222;
    }

    @Override
    public boolean handles(T t2, Options options) {
        return true;
    }

    private static final class AssetFileDescriptorInitializer
    implements MediaMetadataRetrieverInitializer<AssetFileDescriptor> {
        private AssetFileDescriptorInitializer() {
        }

        @Override
        public void initialize(MediaMetadataRetriever mediaMetadataRetriever, AssetFileDescriptor assetFileDescriptor) {
            mediaMetadataRetriever.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
        }
    }

    static class MediaMetadataRetrieverFactory {
        MediaMetadataRetrieverFactory() {
        }

        public MediaMetadataRetriever build() {
            return new MediaMetadataRetriever();
        }
    }

    static interface MediaMetadataRetrieverInitializer<T> {
        public void initialize(MediaMetadataRetriever var1, T var2);
    }

    static final class ParcelFileDescriptorInitializer
    implements MediaMetadataRetrieverInitializer<ParcelFileDescriptor> {
        ParcelFileDescriptorInitializer() {
        }

        @Override
        public void initialize(MediaMetadataRetriever mediaMetadataRetriever, ParcelFileDescriptor parcelFileDescriptor) {
            mediaMetadataRetriever.setDataSource(parcelFileDescriptor.getFileDescriptor());
        }
    }
}

