/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.util.Util;

public final class UnitBitmapDecoder
implements ResourceDecoder<Bitmap, Bitmap> {
    @Override
    public Resource<Bitmap> decode(Bitmap bitmap2, int n2, int n3, Options options) {
        return new NonOwnedBitmapResource(bitmap2);
    }

    @Override
    public boolean handles(Bitmap bitmap2, Options options) {
        return true;
    }

    private static final class NonOwnedBitmapResource
    implements Resource<Bitmap> {
        private final Bitmap bitmap;

        NonOwnedBitmapResource(Bitmap bitmap2) {
            this.bitmap = bitmap2;
        }

        @Override
        public Bitmap get() {
            return this.bitmap;
        }

        @Override
        public Class<Bitmap> getResourceClass() {
            return Bitmap.class;
        }

        @Override
        public int getSize() {
            return Util.getBitmapByteSize(this.bitmap);
        }

        @Override
        public void recycle() {
        }
    }
}

