/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.util.Preconditions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class TransformationUtils {
    private static final Lock BITMAP_DRAWABLE_LOCK;
    private static final Paint CIRCLE_CROP_BITMAP_PAINT;
    private static final int CIRCLE_CROP_PAINT_FLAGS = 7;
    private static final Paint CIRCLE_CROP_SHAPE_PAINT;
    private static final Paint DEFAULT_PAINT;
    private static final Set<String> MODELS_REQUIRING_BITMAP_LOCK;
    public static final int PAINT_FLAGS = 6;
    private static final String TAG = "TransformationUtils";

    static {
        DEFAULT_PAINT = new Paint(6);
        CIRCLE_CROP_SHAPE_PAINT = new Paint(7);
        MODELS_REQUIRING_BITMAP_LOCK = new HashSet<String>(Arrays.asList("XT1085", "XT1092", "XT1093", "XT1094", "XT1095", "XT1096", "XT1097", "XT1098", "XT1031", "XT1028", "XT937C", "XT1032", "XT1008", "XT1033", "XT1035", "XT1034", "XT939G", "XT1039", "XT1040", "XT1042", "XT1045", "XT1063", "XT1064", "XT1068", "XT1069", "XT1072", "XT1077", "XT1078", "XT1079"));
        Lock lock = MODELS_REQUIRING_BITMAP_LOCK.contains(Build.MODEL) ? new ReentrantLock() : new NoLock();
        BITMAP_DRAWABLE_LOCK = lock;
        CIRCLE_CROP_BITMAP_PAINT = new Paint(7);
        CIRCLE_CROP_BITMAP_PAINT.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
    }

    private TransformationUtils() {
    }

    private static void applyMatrix(Bitmap bitmap2, Bitmap bitmap3, Matrix matrix) {
        BITMAP_DRAWABLE_LOCK.lock();
        try {
            Canvas canvas = new Canvas(bitmap3);
            canvas.drawBitmap(bitmap2, matrix, DEFAULT_PAINT);
            TransformationUtils.clear(canvas);
            return;
        }
        finally {
            BITMAP_DRAWABLE_LOCK.unlock();
        }
    }

    public static Bitmap centerCrop(BitmapPool bitmapPool, Bitmap bitmap2, int n2, int n3) {
        float f3;
        float f4;
        if (bitmap2.getWidth() == n2 && bitmap2.getHeight() == n3) {
            return bitmap2;
        }
        Matrix matrix = new Matrix();
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        float f5 = 0.0f;
        if (n4 * n3 > n5 * n2) {
            f4 = (float)n3 / (float)bitmap2.getHeight();
            f3 = ((float)n2 - (float)bitmap2.getWidth() * f4) * 0.5f;
        } else {
            f4 = (float)n2 / (float)bitmap2.getWidth();
            f5 = ((float)n3 - (float)bitmap2.getHeight() * f4) * 0.5f;
            f3 = 0.0f;
        }
        matrix.setScale(f4, f4);
        matrix.postTranslate((float)((int)(f3 + 0.5f)), (float)((int)(f5 + 0.5f)));
        bitmapPool = bitmapPool.get(n2, n3, TransformationUtils.getSafeConfig(bitmap2));
        TransformationUtils.setAlpha(bitmap2, (Bitmap)bitmapPool);
        TransformationUtils.applyMatrix(bitmap2, (Bitmap)bitmapPool, matrix);
        return bitmapPool;
    }

    public static Bitmap centerInside(BitmapPool bitmapPool, Bitmap bitmap2, int n2, int n3) {
        if (bitmap2.getWidth() <= n2 && bitmap2.getHeight() <= n3) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"requested target size larger or equal to input, returning input");
            }
            return bitmap2;
        }
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)"requested target size too big for input, fit centering instead");
        }
        return TransformationUtils.fitCenter(bitmapPool, bitmap2, n2, n3);
    }

    public static Bitmap circleCrop(BitmapPool bitmapPool, Bitmap bitmap2, int n2, int n3) {
        n3 = Math.min(n2, n3);
        float f3 = n3;
        float f4 = f3 / 2.0f;
        n2 = bitmap2.getWidth();
        int n4 = bitmap2.getHeight();
        float f5 = n2;
        float f6 = f3 / f5;
        float f7 = n4;
        f6 = Math.max(f6, f3 / f7);
        f5 *= f6;
        f7 = f6 * f7;
        f6 = (f3 - f5) / 2.0f;
        f3 = (f3 - f7) / 2.0f;
        RectF rectF = new RectF(f6, f3, f5 + f6, f7 + f3);
        Bitmap bitmap3 = TransformationUtils.getAlphaSafeBitmap(bitmapPool, bitmap2);
        Bitmap bitmap4 = bitmapPool.get(n3, n3, Bitmap.Config.ARGB_8888);
        bitmap4.setHasAlpha(true);
        BITMAP_DRAWABLE_LOCK.lock();
        try {
            Canvas canvas = new Canvas(bitmap4);
            canvas.drawCircle(f4, f4, f4, CIRCLE_CROP_SHAPE_PAINT);
            canvas.drawBitmap(bitmap3, null, rectF, CIRCLE_CROP_BITMAP_PAINT);
            TransformationUtils.clear(canvas);
            if (!bitmap3.equals(bitmap2)) {
                bitmapPool.put(bitmap3);
            }
            return bitmap4;
        }
        finally {
            BITMAP_DRAWABLE_LOCK.unlock();
        }
    }

    private static void clear(Canvas canvas) {
        canvas.setBitmap(null);
    }

    public static Bitmap fitCenter(BitmapPool bitmapPool, Bitmap bitmap2, int n2, int n3) {
        StringBuilder stringBuilder;
        if (bitmap2.getWidth() == n2 && bitmap2.getHeight() == n3) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"requested target size matches input, returning input");
            }
            return bitmap2;
        }
        float f3 = Math.min((float)n2 / (float)bitmap2.getWidth(), (float)n3 / (float)bitmap2.getHeight());
        int n4 = Math.round((float)bitmap2.getWidth() * f3);
        int n5 = Math.round((float)bitmap2.getHeight() * f3);
        if (bitmap2.getWidth() == n4 && bitmap2.getHeight() == n5) {
            if (Log.isLoggable((String)TAG, (int)2)) {
                Log.v((String)TAG, (String)"adjusted target size matches input, returning input");
            }
            return bitmap2;
        }
        bitmapPool = bitmapPool.get((int)((float)bitmap2.getWidth() * f3), (int)((float)bitmap2.getHeight() * f3), TransformationUtils.getSafeConfig(bitmap2));
        TransformationUtils.setAlpha(bitmap2, (Bitmap)bitmapPool);
        if (Log.isLoggable((String)TAG, (int)2)) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("request: ");
            stringBuilder.append(n2);
            stringBuilder.append("x");
            stringBuilder.append(n3);
            Log.v((String)TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("toFit:   ");
            stringBuilder.append(bitmap2.getWidth());
            stringBuilder.append("x");
            stringBuilder.append(bitmap2.getHeight());
            Log.v((String)TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("toReuse: ");
            stringBuilder.append(bitmapPool.getWidth());
            stringBuilder.append("x");
            stringBuilder.append(bitmapPool.getHeight());
            Log.v((String)TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append("minPct:   ");
            stringBuilder.append(f3);
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
        stringBuilder = new Matrix();
        stringBuilder.setScale(f3, f3);
        TransformationUtils.applyMatrix(bitmap2, (Bitmap)bitmapPool, (Matrix)stringBuilder);
        return bitmapPool;
    }

    private static Bitmap getAlphaSafeBitmap(BitmapPool bitmapPool, Bitmap bitmap2) {
        if (Bitmap.Config.ARGB_8888.equals((Object)bitmap2.getConfig())) {
            return bitmap2;
        }
        bitmapPool = bitmapPool.get(bitmap2.getWidth(), bitmap2.getHeight(), Bitmap.Config.ARGB_8888);
        new Canvas((Bitmap)bitmapPool).drawBitmap(bitmap2, 0.0f, 0.0f, null);
        return bitmapPool;
    }

    public static Lock getBitmapDrawableLock() {
        return BITMAP_DRAWABLE_LOCK;
    }

    public static int getExifOrientationDegrees(int n2) {
        switch (n2) {
            default: {
                n2 = 0;
                break;
            }
            case 7: 
            case 8: {
                n2 = 270;
                break;
            }
            case 5: 
            case 6: {
                n2 = 90;
                break;
            }
            case 3: 
            case 4: {
                n2 = 180;
            }
        }
        return n2;
    }

    private static Bitmap.Config getSafeConfig(Bitmap bitmap2) {
        bitmap2 = bitmap2.getConfig() != null ? bitmap2.getConfig() : Bitmap.Config.ARGB_8888;
        return bitmap2;
    }

    static void initializeMatrixForRotation(int n2, Matrix matrix) {
        switch (n2) {
            default: {
                break;
            }
            case 8: {
                matrix.setRotate(-90.0f);
                break;
            }
            case 7: {
                matrix.setRotate(-90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                matrix.setRotate(90.0f);
                break;
            }
            case 5: {
                matrix.setRotate(90.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix.setRotate(180.0f);
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.setRotate(180.0f);
                break;
            }
            case 2: {
                matrix.setScale(-1.0f, 1.0f);
            }
        }
    }

    public static boolean isExifOrientationRequired(int n2) {
        switch (n2) {
            default: {
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
        }
        return true;
    }

    public static Bitmap rotateImage(Bitmap bitmap2, int n2) {
        Bitmap bitmap3;
        block3: {
            bitmap3 = bitmap2;
            if (n2 != 0) {
                try {
                    bitmap3 = new Matrix();
                    bitmap3.setRotate((float)n2);
                    bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)bitmap3, (boolean)true);
                }
                catch (Exception exception) {
                    bitmap3 = bitmap2;
                    if (!Log.isLoggable((String)TAG, (int)6)) break block3;
                    Log.e((String)TAG, (String)"Exception when trying to orient image", (Throwable)exception);
                    bitmap3 = bitmap2;
                }
            }
        }
        return bitmap3;
    }

    public static Bitmap rotateImageExif(BitmapPool bitmapPool, Bitmap bitmap2, int n2) {
        if (!TransformationUtils.isExifOrientationRequired(n2)) {
            return bitmap2;
        }
        Matrix matrix = new Matrix();
        TransformationUtils.initializeMatrixForRotation(n2, matrix);
        RectF rectF = new RectF(0.0f, 0.0f, (float)bitmap2.getWidth(), (float)bitmap2.getHeight());
        matrix.mapRect(rectF);
        bitmapPool = bitmapPool.get(Math.round(rectF.width()), Math.round(rectF.height()), TransformationUtils.getSafeConfig(bitmap2));
        matrix.postTranslate(-rectF.left, -rectF.top);
        TransformationUtils.applyMatrix(bitmap2, (Bitmap)bitmapPool, matrix);
        return bitmapPool;
    }

    public static Bitmap roundedCorners(BitmapPool bitmapPool, Bitmap bitmap2, int n2) {
        boolean bl = n2 > 0;
        Preconditions.checkArgument(bl, "roundingRadius must be greater than 0.");
        Bitmap bitmap3 = TransformationUtils.getAlphaSafeBitmap(bitmapPool, bitmap2);
        Bitmap bitmap4 = bitmapPool.get(bitmap3.getWidth(), bitmap3.getHeight(), Bitmap.Config.ARGB_8888);
        bitmap4.setHasAlpha(true);
        BitmapShader bitmapShader = new BitmapShader(bitmap3, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setShader((Shader)bitmapShader);
        bitmapShader = new RectF(0.0f, 0.0f, (float)bitmap4.getWidth(), (float)bitmap4.getHeight());
        BITMAP_DRAWABLE_LOCK.lock();
        Canvas canvas = new Canvas(bitmap4);
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        float f3 = n2;
        try {
            canvas.drawRoundRect((RectF)bitmapShader, f3, f3, paint);
            TransformationUtils.clear(canvas);
            if (!bitmap3.equals(bitmap2)) {
                bitmapPool.put(bitmap3);
            }
            return bitmap4;
        }
        finally {
            BITMAP_DRAWABLE_LOCK.unlock();
        }
    }

    @Deprecated
    public static Bitmap roundedCorners(BitmapPool bitmapPool, Bitmap bitmap2, int n2, int n3, int n4) {
        return TransformationUtils.roundedCorners(bitmapPool, bitmap2, n4);
    }

    public static void setAlpha(Bitmap bitmap2, Bitmap bitmap3) {
        bitmap3.setHasAlpha(bitmap2.hasAlpha());
    }

    private static final class NoLock
    implements Lock {
        NoLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Should not be called");
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long l3, TimeUnit timeUnit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }
    }
}

