/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RecyclableBufferedInputStream
extends FilterInputStream {
    private volatile byte[] buf;
    private final ArrayPool byteArrayPool;
    private int count;
    private int marklimit;
    private int markpos = -1;
    private int pos;

    public RecyclableBufferedInputStream(InputStream inputStream, ArrayPool arrayPool) {
        this(inputStream, arrayPool, 65536);
    }

    RecyclableBufferedInputStream(InputStream inputStream, ArrayPool arrayPool, int n2) {
        super(inputStream);
        this.byteArrayPool = arrayPool;
        this.buf = arrayPool.get(n2, byte[].class);
    }

    private int fillbuf(InputStream inputStream, byte[] byArray) throws IOException {
        int n2;
        int n3;
        int n4 = this.markpos;
        if (n4 != -1 && (n3 = this.pos) - n4 < (n2 = this.marklimit)) {
            byte[] byArray2;
            if (n4 == 0 && n2 > byArray.length && this.count == byArray.length) {
                n4 = n3 = byArray.length * 2;
                if (n3 > n2) {
                    n4 = n2;
                }
                byArray2 = this.byteArrayPool.get(n4, byte[].class);
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                this.buf = byArray2;
                this.byteArrayPool.put(byArray);
            } else {
                n4 = this.markpos;
                byArray2 = byArray;
                if (n4 > 0) {
                    System.arraycopy(byArray, n4, byArray, 0, byArray.length - n4);
                    byArray2 = byArray;
                }
            }
            this.pos -= this.markpos;
            this.markpos = 0;
            this.count = 0;
            n4 = this.pos;
            n2 = inputStream.read(byArray2, n4, byArray2.length - n4);
            n4 = this.pos;
            if (n2 > 0) {
                n4 += n2;
            }
            this.count = n4;
            return n2;
        }
        n4 = inputStream.read(byArray);
        if (n4 > 0) {
            this.markpos = -1;
            this.pos = 0;
            this.count = n4;
        }
        return n4;
    }

    private static IOException streamClosed() throws IOException {
        throw new IOException("BufferedInputStream is closed");
    }

    @Override
    public int available() throws IOException {
        synchronized (this) {
            block5: {
                InputStream inputStream = this.in;
                if (this.buf == null || inputStream == null) break block5;
                int n2 = this.count;
                int n3 = this.pos;
                int n4 = inputStream.available();
                return n2 - n3 + n4;
            }
            throw RecyclableBufferedInputStream.streamClosed();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buf != null) {
            this.byteArrayPool.put(this.buf);
            this.buf = null;
        }
        InputStream inputStream = this.in;
        this.in = null;
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public void fixMarkLimit() {
        synchronized (this) {
            this.marklimit = this.buf.length;
            return;
        }
    }

    @Override
    public void mark(int n2) {
        synchronized (this) {
            this.marklimit = Math.max(this.marklimit, n2);
            this.markpos = this.pos;
            return;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        synchronized (this) {
            byte[] byArray = this.buf;
            Object object = this.in;
            if (byArray != null && object != null) {
                int n2;
                if (this.pos >= this.count && (n2 = this.fillbuf((InputStream)object, byArray)) == -1) {
                    return -1;
                }
                object = byArray;
                if (byArray != this.buf && (object = (Object)this.buf) == null) {
                    throw RecyclableBufferedInputStream.streamClosed();
                }
                if (this.count - this.pos > 0) {
                    int n3 = this.pos;
                    this.pos = n3 + 1;
                    Object object2 = object[n3];
                    return object2 & 0xFF;
                }
                return -1;
            }
            throw RecyclableBufferedInputStream.streamClosed();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        synchronized (this) {
            int n4;
            int n5;
            int n6;
            InputStream inputStream;
            int n7;
            byte[] byArray2;
            block22: {
                byArray2 = this.buf;
                if (byArray2 == null) {
                    throw RecyclableBufferedInputStream.streamClosed();
                }
                if (n7 == 0) {
                    return 0;
                }
                inputStream = this.in;
                if (inputStream == null) {
                    throw RecyclableBufferedInputStream.streamClosed();
                }
                if (this.pos < this.count) {
                    n6 = this.count - this.pos >= n7 ? n7 : this.count - this.pos;
                    System.arraycopy(byArray2, this.pos, byArray, n5, n6);
                    this.pos += n6;
                    if (n6 == n7) return n6;
                    n4 = inputStream.available();
                    if (n4 != 0) {
                        n4 = n5 + n6;
                        n5 = n7 - n6;
                        n6 = n4;
                        break block22;
                    } else {
                        return n6;
                    }
                }
                n4 = n7;
                n6 = n5;
                n5 = n4;
            }
            while (true) {
                byte[] byArray3;
                n4 = this.markpos;
                int n8 = -1;
                if (n4 == -1 && n5 >= byArray2.length) {
                    int n9 = inputStream.read(byArray, n6, n5);
                    byArray3 = byArray2;
                    n4 = n9;
                    if (n9 == -1) {
                        if (n5 != n7) return (int)(n7 - n5);
                        return n8;
                    }
                } else {
                    n4 = this.fillbuf(inputStream, byArray2);
                    if (n4 == -1) {
                        if (n5 != n7) return (int)(n7 - n5);
                        return n8;
                    }
                    byArray3 = byArray2;
                    if (byArray2 != this.buf && (byArray3 = this.buf) == null) {
                        throw RecyclableBufferedInputStream.streamClosed();
                    }
                    n4 = this.count - this.pos >= n5 ? n5 : this.count - this.pos;
                    System.arraycopy(byArray3, this.pos, byArray, n6, n4);
                    this.pos += n4;
                }
                if ((n5 -= n4) == 0) {
                    return n7;
                }
                n8 = inputStream.available();
                if (n8 == 0) {
                    return (int)(n7 - n5);
                }
                n6 += n4;
                byArray2 = byArray3;
            }
        }
    }

    public void release() {
        synchronized (this) {
            if (this.buf != null) {
                this.byteArrayPool.put(this.buf);
                this.buf = null;
            }
            return;
        }
    }

    @Override
    public void reset() throws IOException {
        synchronized (this) {
            if (this.buf != null) {
                if (-1 != this.markpos) {
                    this.pos = this.markpos;
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Mark has been invalidated, pos: ");
                stringBuilder.append(this.pos);
                stringBuilder.append(" markLimit: ");
                stringBuilder.append(this.marklimit);
                InvalidMarkException invalidMarkException = new InvalidMarkException(stringBuilder.toString());
                throw invalidMarkException;
            }
            IOException iOException = new IOException("Stream is closed");
            throw iOException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long skip(long l3) throws IOException {
        synchronized (this) {
            block11: {
                long l4;
                InputStream inputStream;
                block13: {
                    block15: {
                        block14: {
                            byte[] byArray;
                            block12: {
                                if (l3 < 1L) {
                                    return 0L;
                                }
                                byArray = this.buf;
                                if (byArray == null) throw RecyclableBufferedInputStream.streamClosed();
                                inputStream = this.in;
                                if (inputStream == null) break block11;
                                if ((long)(this.count - this.pos) < l3) break block12;
                                this.pos = (int)((long)this.pos + l3);
                                return l3;
                            }
                            l4 = (long)this.count - (long)this.pos;
                            this.pos = this.count;
                            if (this.markpos == -1 || l3 > (long)this.marklimit) break block13;
                            int n2 = this.fillbuf(inputStream, byArray);
                            if (n2 != -1) break block14;
                            return l4;
                        }
                        if ((long)(this.count - this.pos) < l3 - l4) break block15;
                        this.pos = (int)((long)this.pos + l3 - l4);
                        return l3;
                    }
                    long l5 = this.count;
                    l3 = this.pos;
                    this.pos = this.count;
                    return l4 + l5 - l3;
                }
                l3 = inputStream.skip(l3 - l4);
                return l4 + l3;
            }
            throw RecyclableBufferedInputStream.streamClosed();
        }
    }

    static class InvalidMarkException
    extends IOException {
        private static final long serialVersionUID = -4338378848813561757L;

        InvalidMarkException(String string2) {
            super(string2);
        }
    }
}

