/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Log;
import com.bumptech.glide.load.DecodeFormat;
import java.io.File;

final class HardwareConfigState {
    private static final File FD_SIZE_LIST = new File("/proc/self/fd");
    private static final int MAXIMUM_FDS_FOR_HARDWARE_CONFIGS = 700;
    private static final int MINIMUM_DECODES_BETWEEN_FD_CHECKS = 50;
    private static final int MIN_HARDWARE_DIMENSION = 128;
    private static volatile HardwareConfigState instance;
    private volatile int decodesSinceLastFdCheck;
    private volatile boolean isHardwareConfigAllowed = true;

    private HardwareConfigState() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static HardwareConfigState getInstance() {
        if (instance != null) return instance;
        synchronized (HardwareConfigState.class) {
            HardwareConfigState hardwareConfigState;
            if (instance != null) return instance;
            instance = hardwareConfigState = new HardwareConfigState();
            return instance;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFdSizeBelowHardwareLimit() {
        synchronized (this) {
            boolean bl;
            int n2;
            block5: {
                this.decodesSinceLastFdCheck = n2 = this.decodesSinceLastFdCheck + 1;
                if (n2 < 50) return this.isHardwareConfigAllowed;
                bl = false;
                this.decodesSinceLastFdCheck = 0;
                n2 = FD_SIZE_LIST.list().length;
                if (n2 >= 700) break block5;
                bl = true;
            }
            this.isHardwareConfigAllowed = bl;
            if (this.isHardwareConfigAllowed) return this.isHardwareConfigAllowed;
            if (!Log.isLoggable((String)"Downsampler", (int)5)) return this.isHardwareConfigAllowed;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Excluding HARDWARE bitmap config because we're over the file descriptor limit, file descriptors ");
            stringBuilder.append(n2);
            stringBuilder.append(", limit ");
            stringBuilder.append(700);
            Log.w((String)"Downsampler", (String)stringBuilder.toString());
            return this.isHardwareConfigAllowed;
        }
    }

    boolean setHardwareConfigIfAllowed(int n2, int n3, BitmapFactory.Options options, DecodeFormat decodeFormat, boolean bl, boolean bl2) {
        if (bl && Build.VERSION.SDK_INT >= 26 && decodeFormat != DecodeFormat.PREFER_ARGB_8888_DISALLOW_HARDWARE && !bl2) {
            bl = n2 >= 128 && n3 >= 128 && this.isFdSizeBelowHardwareLimit();
            if (bl) {
                options.inPreferredConfig = Bitmap.Config.HARDWARE;
                options.inMutable = false;
            }
            return bl;
        }
        return false;
    }
}

