/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPoolAdapter;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import java.util.concurrent.locks.Lock;

final class DrawableToBitmapConverter {
    private static final BitmapPool NO_RECYCLE_BITMAP_POOL = new BitmapPoolAdapter(){

        @Override
        public void put(Bitmap bitmap2) {
        }
    };
    private static final String TAG = "DrawableToBitmap";

    private DrawableToBitmapConverter() {
    }

    static Resource<Bitmap> convert(BitmapPool bitmapPool, Drawable drawable2, int n2, int n3) {
        drawable2 = drawable2.getCurrent();
        boolean bl = drawable2 instanceof BitmapDrawable;
        int n4 = 0;
        if (bl) {
            drawable2 = ((BitmapDrawable)drawable2).getBitmap();
            n2 = n4;
        } else if (!(drawable2 instanceof Animatable)) {
            drawable2 = DrawableToBitmapConverter.drawToBitmap(bitmapPool, drawable2, n2, n3);
            n2 = 1;
        } else {
            drawable2 = null;
            n2 = n4;
        }
        if (n2 == 0) {
            bitmapPool = NO_RECYCLE_BITMAP_POOL;
        }
        return BitmapResource.obtain((Bitmap)drawable2, bitmapPool);
    }

    private static Bitmap drawToBitmap(BitmapPool object, Drawable drawable2, int n2, int n3) {
        if (n2 == Integer.MIN_VALUE && drawable2.getIntrinsicWidth() <= 0) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Unable to draw ");
                ((StringBuilder)object).append(drawable2);
                ((StringBuilder)object).append(" to Bitmap with Target.SIZE_ORIGINAL because the Drawable has no intrinsic width");
                Log.w((String)TAG, (String)((StringBuilder)object).toString());
            }
            return null;
        }
        if (n3 == Integer.MIN_VALUE && drawable2.getIntrinsicHeight() <= 0) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Unable to draw ");
                ((StringBuilder)object).append(drawable2);
                ((StringBuilder)object).append(" to Bitmap with Target.SIZE_ORIGINAL because the Drawable has no intrinsic height");
                Log.w((String)TAG, (String)((StringBuilder)object).toString());
            }
            return null;
        }
        if (drawable2.getIntrinsicWidth() > 0) {
            n2 = drawable2.getIntrinsicWidth();
        }
        if (drawable2.getIntrinsicHeight() > 0) {
            n3 = drawable2.getIntrinsicHeight();
        }
        Lock lock = TransformationUtils.getBitmapDrawableLock();
        lock.lock();
        object = object.get(n2, n3, Bitmap.Config.ARGB_8888);
        try {
            Canvas canvas = new Canvas((Bitmap)object);
            drawable2.setBounds(0, 0, n2, n3);
            drawable2.draw(canvas);
            canvas.setBitmap(null);
            return object;
        }
        finally {
            lock.unlock();
        }
    }
}

