/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.ImageHeaderParserUtils;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.bitmap.HardwareConfigState;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import com.bumptech.glide.util.LogTime;
import com.bumptech.glide.util.Preconditions;
import com.bumptech.glide.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public final class Downsampler {
    public static final Option<Boolean> ALLOW_HARDWARE_CONFIG;
    public static final Option<DecodeFormat> DECODE_FORMAT;
    public static final Option<DownsampleStrategy> DOWNSAMPLE_STRATEGY;
    private static final DecodeCallbacks EMPTY_CALLBACKS;
    public static final Option<Boolean> FIX_BITMAP_SIZE_TO_REQUESTED_DIMENSIONS;
    private static final String ICO_MIME_TYPE = "image/x-ico";
    private static final int MARK_POSITION = 0xA00000;
    private static final Set<String> NO_DOWNSAMPLE_PRE_N_MIME_TYPES;
    private static final Queue<BitmapFactory.Options> OPTIONS_QUEUE;
    static final String TAG = "Downsampler";
    private static final Set<ImageHeaderParser.ImageType> TYPES_THAT_USE_POOL_PRE_KITKAT;
    private static final String WBMP_MIME_TYPE = "image/vnd.wap.wbmp";
    private final BitmapPool bitmapPool;
    private final ArrayPool byteArrayPool;
    private final DisplayMetrics displayMetrics;
    private final HardwareConfigState hardwareConfigState = HardwareConfigState.getInstance();
    private final List<ImageHeaderParser> parsers;

    static {
        DECODE_FORMAT = Option.memory("com.bumptech.glide.load.resource.bitmap.Downsampler.DecodeFormat", DecodeFormat.DEFAULT);
        DOWNSAMPLE_STRATEGY = Option.memory("com.bumptech.glide.load.resource.bitmap.Downsampler.DownsampleStrategy", DownsampleStrategy.DEFAULT);
        FIX_BITMAP_SIZE_TO_REQUESTED_DIMENSIONS = Option.memory("com.bumptech.glide.load.resource.bitmap.Downsampler.FixBitmapSize", false);
        ALLOW_HARDWARE_CONFIG = Option.memory("com.bumtpech.glide.load.resource.bitmap.Downsampler.AllowHardwareDecode", null);
        NO_DOWNSAMPLE_PRE_N_MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(WBMP_MIME_TYPE, ICO_MIME_TYPE)));
        EMPTY_CALLBACKS = new DecodeCallbacks(){

            @Override
            public void onDecodeComplete(BitmapPool bitmapPool, Bitmap bitmap2) {
            }

            @Override
            public void onObtainBounds() {
            }
        };
        TYPES_THAT_USE_POOL_PRE_KITKAT = Collections.unmodifiableSet(EnumSet.of(ImageHeaderParser.ImageType.JPEG, ImageHeaderParser.ImageType.PNG_A, ImageHeaderParser.ImageType.PNG));
        OPTIONS_QUEUE = Util.createQueue(0);
    }

    public Downsampler(List<ImageHeaderParser> list, DisplayMetrics displayMetrics, BitmapPool bitmapPool, ArrayPool arrayPool) {
        this.parsers = list;
        this.displayMetrics = Preconditions.checkNotNull(displayMetrics);
        this.bitmapPool = Preconditions.checkNotNull(bitmapPool);
        this.byteArrayPool = Preconditions.checkNotNull(arrayPool);
    }

    private static int adjustTargetDensityForError(double d3) {
        int n2 = Downsampler.getDensityMultiplier(d3);
        int n3 = Downsampler.round((double)n2 * d3);
        return Downsampler.round(d3 / (double)((float)n3 / (float)n2) * (double)n3);
    }

    private void calculateConfig(InputStream object, DecodeFormat decodeFormat, boolean bl, boolean bl2, BitmapFactory.Options options, int n2, int n3) {
        if (this.hardwareConfigState.setHardwareConfigIfAllowed(n2, n3, options, decodeFormat, bl, bl2)) {
            return;
        }
        if (decodeFormat != DecodeFormat.PREFER_ARGB_8888 && decodeFormat != DecodeFormat.PREFER_ARGB_8888_DISALLOW_HARDWARE && Build.VERSION.SDK_INT != 16) {
            block5: {
                bl2 = false;
                try {
                    bl = ImageHeaderParserUtils.getType(this.parsers, (InputStream)object, this.byteArrayPool).hasAlpha();
                }
                catch (IOException iOException) {
                    bl = bl2;
                    if (!Log.isLoggable((String)TAG, (int)3)) break block5;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Cannot determine whether the image has alpha or not from header, format ");
                    ((StringBuilder)object).append((Object)decodeFormat);
                    Log.d((String)TAG, (String)((StringBuilder)object).toString(), (Throwable)iOException);
                    bl = bl2;
                }
            }
            object = bl ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
            options.inPreferredConfig = object;
            if (options.inPreferredConfig == Bitmap.Config.RGB_565) {
                options.inDither = true;
            }
            return;
        }
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
    }

    private static void calculateScaling(ImageHeaderParser.ImageType object, InputStream object2, DecodeCallbacks decodeCallbacks, BitmapPool bitmapPool, DownsampleStrategy downsampleStrategy, int object3, int n2, int n3, int n4, int n5, BitmapFactory.Options options) throws IOException {
        block11: {
            float f3;
            block12: {
                block13: {
                    double d3;
                    int n6;
                    Object object4;
                    block15: {
                        block19: {
                            float f4;
                            float f5;
                            block16: {
                                block18: {
                                    block17: {
                                        block14: {
                                            if (n2 <= 0 || n3 <= 0) break block11;
                                            f3 = object3 != 90 && object3 != 270 ? downsampleStrategy.getScaleFactor(n2, n3, n4, n5) : downsampleStrategy.getScaleFactor(n3, n2, n4, n5);
                                            if (f3 <= 0.0f) break block12;
                                            DownsampleStrategy.SampleSizeRounding sampleSizeRounding = downsampleStrategy.getSampleSizeRounding(n2, n3, n4, n5);
                                            if (sampleSizeRounding == null) break block13;
                                            f5 = n2;
                                            object3 = Downsampler.round(f3 * f5);
                                            f4 = n3;
                                            object4 = Downsampler.round(f3 * f4);
                                            object3 = n2 / object3;
                                            object4 = n3 / object4;
                                            object3 = sampleSizeRounding == DownsampleStrategy.SampleSizeRounding.MEMORY ? Math.max(object3, object4) : Math.min(object3, object4);
                                            if (Build.VERSION.SDK_INT <= 23 && NO_DOWNSAMPLE_PRE_N_MIME_TYPES.contains(options.outMimeType)) {
                                                n6 = 1;
                                            } else {
                                                n6 = Math.max(1, Integer.highestOneBit(object3));
                                                if (sampleSizeRounding == DownsampleStrategy.SampleSizeRounding.MEMORY && (float)n6 < 1.0f / f3) {
                                                    n6 <<= 1;
                                                }
                                            }
                                            options.inSampleSize = n6;
                                            if (object != ImageHeaderParser.ImageType.JPEG) break block14;
                                            float f6 = Math.min(n6, 8);
                                            Object object5 = Math.ceil(f5 / f6);
                                            int n7 = (int)Math.ceil(f4 / f6);
                                            int n8 = n6 / 8;
                                            object3 = n7;
                                            object4 = object5;
                                            if (n8 > 0) {
                                                object4 = object5 / n8;
                                                object3 = n7 / n8;
                                            }
                                            break block15;
                                        }
                                        if (object == ImageHeaderParser.ImageType.PNG || object == ImageHeaderParser.ImageType.PNG_A) break block16;
                                        if (object == ImageHeaderParser.ImageType.WEBP || object == ImageHeaderParser.ImageType.WEBP_A) break block17;
                                        if (n2 % n6 == 0 && n3 % n6 == 0) {
                                            object4 = n2 / n6;
                                            object3 = n3 / n6;
                                        } else {
                                            object = Downsampler.getDimensions((InputStream)object2, options, decodeCallbacks, bitmapPool);
                                            object4 = (Object)object[0];
                                            object3 = (Object)object[1];
                                        }
                                        break block15;
                                    }
                                    if (Build.VERSION.SDK_INT < 24) break block18;
                                    float f7 = n6;
                                    object4 = Math.round(f5 / f7);
                                    object3 = Math.round(f4 / f7);
                                    break block15;
                                }
                                float f8 = n6;
                                object4 = (int)Math.floor(f5 / f8);
                                d3 = Math.floor(f4 / f8);
                                break block19;
                            }
                            float f9 = n6;
                            object4 = (int)Math.floor(f5 / f9);
                            d3 = Math.floor(f4 / f9);
                        }
                        object3 = (int)d3;
                    }
                    d3 = downsampleStrategy.getScaleFactor((int)object4, (int)object3, n4, n5);
                    if (Build.VERSION.SDK_INT >= 19) {
                        options.inTargetDensity = Downsampler.adjustTargetDensityForError(d3);
                        options.inDensity = Downsampler.getDensityMultiplier(d3);
                    }
                    if (Downsampler.isScaling(options)) {
                        options.inScaled = true;
                    } else {
                        options.inTargetDensity = 0;
                        options.inDensity = 0;
                    }
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Calculate scaling, source: [");
                        ((StringBuilder)object).append(n2);
                        ((StringBuilder)object).append("x");
                        ((StringBuilder)object).append(n3);
                        ((StringBuilder)object).append("], target: [");
                        ((StringBuilder)object).append(n4);
                        ((StringBuilder)object).append("x");
                        ((StringBuilder)object).append(n5);
                        ((StringBuilder)object).append("], power of two scaled: [");
                        ((StringBuilder)object).append((int)object4);
                        ((StringBuilder)object).append("x");
                        ((StringBuilder)object).append((int)object3);
                        ((StringBuilder)object).append("], exact scale factor: ");
                        ((StringBuilder)object).append(f3);
                        ((StringBuilder)object).append(", power of 2 sample size: ");
                        ((StringBuilder)object).append(n6);
                        ((StringBuilder)object).append(", adjusted scale factor: ");
                        ((StringBuilder)object).append(d3);
                        ((StringBuilder)object).append(", target density: ");
                        ((StringBuilder)object).append(options.inTargetDensity);
                        ((StringBuilder)object).append(", density: ");
                        ((StringBuilder)object).append(options.inDensity);
                        Log.v((String)TAG, (String)((StringBuilder)object).toString());
                    }
                    return;
                }
                throw new IllegalArgumentException("Cannot round with null rounding");
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Cannot scale with factor: ");
            ((StringBuilder)object).append(f3);
            ((StringBuilder)object).append(" from: ");
            ((StringBuilder)object).append(downsampleStrategy);
            ((StringBuilder)object).append(", source: [");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append("x");
            ((StringBuilder)object).append(n3);
            ((StringBuilder)object).append("], target: [");
            ((StringBuilder)object).append(n4);
            ((StringBuilder)object).append("x");
            ((StringBuilder)object).append(n5);
            ((StringBuilder)object).append("]");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Unable to determine dimensions for: ");
            ((StringBuilder)object2).append(object);
            ((StringBuilder)object2).append(" with target [");
            ((StringBuilder)object2).append(n4);
            ((StringBuilder)object2).append("x");
            ((StringBuilder)object2).append(n5);
            ((StringBuilder)object2).append("]");
            Log.d((String)TAG, (String)((StringBuilder)object2).toString());
        }
    }

    private Bitmap decodeFromWrappedStreams(InputStream inputStream, BitmapFactory.Options options, DownsampleStrategy object, DecodeFormat object2, boolean bl, int n2, int n3, boolean bl2, DecodeCallbacks decodeCallbacks) throws IOException {
        long l3 = LogTime.getLogTime();
        Object object3 = Downsampler.getDimensions(inputStream, options, decodeCallbacks, this.bitmapPool);
        int n4 = 0;
        int n5 = object3[0];
        int n6 = object3[1];
        object3 = options.outMimeType;
        if (n5 == -1 || n6 == -1) {
            bl = false;
        }
        int n7 = ImageHeaderParserUtils.getOrientation(this.parsers, inputStream, this.byteArrayPool);
        int n8 = TransformationUtils.getExifOrientationDegrees(n7);
        boolean bl3 = TransformationUtils.isExifOrientationRequired(n7);
        int n9 = n2 == Integer.MIN_VALUE ? n5 : n2;
        int n10 = n3 == Integer.MIN_VALUE ? n6 : n3;
        ImageHeaderParser.ImageType imageType = ImageHeaderParserUtils.getType(this.parsers, inputStream, this.byteArrayPool);
        Downsampler.calculateScaling(imageType, inputStream, decodeCallbacks, this.bitmapPool, (DownsampleStrategy)object, n8, n5, n6, n9, n10, options);
        this.calculateConfig(inputStream, (DecodeFormat)((Object)object2), bl, bl3, options, n9, n10);
        if (Build.VERSION.SDK_INT >= 19) {
            n4 = 1;
        }
        if (options.inSampleSize == 1 || n4 != 0) {
            object = this;
            if (super.shouldUsePool(imageType)) {
                if (n5 < 0 || n6 < 0 || !bl2 || n4 == 0) {
                    float f3 = Downsampler.isScaling(options) ? (float)options.inTargetDensity / (float)options.inDensity : 1.0f;
                    int n11 = options.inSampleSize;
                    float f4 = n5;
                    float f5 = n11;
                    n10 = (int)Math.ceil(f4 / f5);
                    n9 = (int)Math.ceil((float)n6 / f5);
                    n4 = Math.round((float)n10 * f3);
                    n8 = Math.round((float)n9 * f3);
                    n9 = n4;
                    n10 = n8;
                    if (Log.isLoggable((String)TAG, (int)2)) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Calculated target [");
                        ((StringBuilder)object2).append(n4);
                        ((StringBuilder)object2).append("x");
                        ((StringBuilder)object2).append(n8);
                        ((StringBuilder)object2).append("] for source [");
                        ((StringBuilder)object2).append(n5);
                        ((StringBuilder)object2).append("x");
                        ((StringBuilder)object2).append(n6);
                        ((StringBuilder)object2).append("], sampleSize: ");
                        ((StringBuilder)object2).append(n11);
                        ((StringBuilder)object2).append(", targetDensity: ");
                        ((StringBuilder)object2).append(options.inTargetDensity);
                        ((StringBuilder)object2).append(", density: ");
                        ((StringBuilder)object2).append(options.inDensity);
                        ((StringBuilder)object2).append(", density multiplier: ");
                        ((StringBuilder)object2).append(f3);
                        Log.v((String)TAG, (String)((StringBuilder)object2).toString());
                        n10 = n8;
                        n9 = n4;
                    }
                }
                if (n9 > 0 && n10 > 0) {
                    Downsampler.setInBitmap(options, ((Downsampler)object).bitmapPool, n9, n10);
                }
            }
        }
        object = this;
        object2 = Downsampler.decodeStream(inputStream, options, decodeCallbacks, ((Downsampler)object).bitmapPool);
        decodeCallbacks.onDecodeComplete(((Downsampler)object).bitmapPool, (Bitmap)object2);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Downsampler.logDecode(n5, n6, (String)object3, options, (Bitmap)object2, n2, n3, l3);
        }
        inputStream = null;
        if (object2 != null) {
            object2.setDensity(((Downsampler)object).displayMetrics.densityDpi);
            options = TransformationUtils.rotateImageExif(((Downsampler)object).bitmapPool, (Bitmap)object2, n7);
            inputStream = options;
            if (!object2.equals(options)) {
                ((Downsampler)object).bitmapPool.put((Bitmap)object2);
                inputStream = options;
            }
        }
        return inputStream;
    }

    /*
     * Exception decompiling
     */
    private static Bitmap decodeStream(InputStream var0, BitmapFactory.Options var1_3, DecodeCallbacks var2_4, BitmapPool var3_5) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [2 : 84->124)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getBitmapString(Bitmap bitmap2) {
        CharSequence charSequence;
        if (bitmap2 == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(" (");
            ((StringBuilder)charSequence).append(bitmap2.getAllocationByteCount());
            ((StringBuilder)charSequence).append(")");
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(bitmap2.getWidth());
        stringBuilder.append("x");
        stringBuilder.append(bitmap2.getHeight());
        stringBuilder.append("] ");
        stringBuilder.append(bitmap2.getConfig());
        stringBuilder.append((String)charSequence);
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BitmapFactory.Options getDefaultOptions() {
        synchronized (Downsampler.class) {
            BitmapFactory.Options options;
            BitmapFactory.Options options2 = OPTIONS_QUEUE;
            synchronized (options2) {
                options = OPTIONS_QUEUE.poll();
            }
            options2 = options;
            if (options == null) {
                options2 = new BitmapFactory.Options();
                Downsampler.resetOptions(options2);
            }
            return options2;
        }
    }

    private static int getDensityMultiplier(double d3) {
        if (!(d3 <= 1.0)) {
            d3 = 1.0 / d3;
        }
        return (int)Math.round(d3 * 2.147483647E9);
    }

    private static int[] getDimensions(InputStream inputStream, BitmapFactory.Options options, DecodeCallbacks decodeCallbacks, BitmapPool bitmapPool) throws IOException {
        options.inJustDecodeBounds = true;
        Downsampler.decodeStream(inputStream, options, decodeCallbacks, bitmapPool);
        options.inJustDecodeBounds = false;
        return new int[]{options.outWidth, options.outHeight};
    }

    private static String getInBitmapString(BitmapFactory.Options options) {
        return Downsampler.getBitmapString(options.inBitmap);
    }

    private static boolean isScaling(BitmapFactory.Options options) {
        boolean bl = options.inTargetDensity > 0 && options.inDensity > 0 && options.inTargetDensity != options.inDensity;
        return bl;
    }

    private static void logDecode(int n2, int n3, String string2, BitmapFactory.Options options, Bitmap bitmap2, int n4, int n5, long l3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Decoded ");
        stringBuilder.append(Downsampler.getBitmapString(bitmap2));
        stringBuilder.append(" from [");
        stringBuilder.append(n2);
        stringBuilder.append("x");
        stringBuilder.append(n3);
        stringBuilder.append("] ");
        stringBuilder.append(string2);
        stringBuilder.append(" with inBitmap ");
        stringBuilder.append(Downsampler.getInBitmapString(options));
        stringBuilder.append(" for [");
        stringBuilder.append(n4);
        stringBuilder.append("x");
        stringBuilder.append(n5);
        stringBuilder.append("], sample size: ");
        stringBuilder.append(options.inSampleSize);
        stringBuilder.append(", density: ");
        stringBuilder.append(options.inDensity);
        stringBuilder.append(", target density: ");
        stringBuilder.append(options.inTargetDensity);
        stringBuilder.append(", thread: ");
        stringBuilder.append(Thread.currentThread().getName());
        stringBuilder.append(", duration: ");
        stringBuilder.append(LogTime.getElapsedMillis(l3));
        Log.v((String)TAG, (String)stringBuilder.toString());
    }

    private static IOException newIoExceptionForInBitmapAssertion(IllegalArgumentException illegalArgumentException, int n2, int n3, String string2, BitmapFactory.Options options) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Exception decoding bitmap, outWidth: ");
        stringBuilder.append(n2);
        stringBuilder.append(", outHeight: ");
        stringBuilder.append(n3);
        stringBuilder.append(", outMimeType: ");
        stringBuilder.append(string2);
        stringBuilder.append(", inBitmap: ");
        stringBuilder.append(Downsampler.getInBitmapString(options));
        return new IOException(stringBuilder.toString(), illegalArgumentException);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void releaseOptions(BitmapFactory.Options options) {
        Downsampler.resetOptions(options);
        Queue<BitmapFactory.Options> queue = OPTIONS_QUEUE;
        synchronized (queue) {
            OPTIONS_QUEUE.offer(options);
            return;
        }
    }

    private static void resetOptions(BitmapFactory.Options options) {
        options.inTempStorage = null;
        options.inDither = false;
        options.inScaled = false;
        options.inSampleSize = 1;
        options.inPreferredConfig = null;
        options.inJustDecodeBounds = false;
        options.inDensity = 0;
        options.inTargetDensity = 0;
        options.outWidth = 0;
        options.outHeight = 0;
        options.outMimeType = null;
        options.inBitmap = null;
        options.inMutable = true;
    }

    private static int round(double d3) {
        return (int)(d3 + 0.5);
    }

    private static void setInBitmap(BitmapFactory.Options options, BitmapPool bitmapPool, int n2, int n3) {
        Bitmap.Config config;
        if (Build.VERSION.SDK_INT >= 26) {
            if (options.inPreferredConfig == Bitmap.Config.HARDWARE) {
                return;
            }
            config = options.outConfig;
        } else {
            config = null;
        }
        Bitmap.Config config2 = config;
        if (config == null) {
            config2 = options.inPreferredConfig;
        }
        options.inBitmap = bitmapPool.getDirty(n2, n3, config2);
    }

    private boolean shouldUsePool(ImageHeaderParser.ImageType imageType) {
        if (Build.VERSION.SDK_INT >= 19) {
            return true;
        }
        return TYPES_THAT_USE_POOL_PRE_KITKAT.contains((Object)imageType);
    }

    public Resource<Bitmap> decode(InputStream inputStream, int n2, int n3, Options options) throws IOException {
        return this.decode(inputStream, n2, n3, options, EMPTY_CALLBACKS);
    }

    public Resource<Bitmap> decode(InputStream object, int n2, int n3, Options options, DecodeCallbacks decodeCallbacks) throws IOException {
        Preconditions.checkArgument(((InputStream)object).markSupported(), "You must provide an InputStream that supports mark()");
        byte[] byArray = this.byteArrayPool.get(65536, byte[].class);
        BitmapFactory.Options options2 = Downsampler.getDefaultOptions();
        options2.inTempStorage = byArray;
        DecodeFormat decodeFormat = options.get(DECODE_FORMAT);
        DownsampleStrategy downsampleStrategy = options.get(DOWNSAMPLE_STRATEGY);
        boolean bl = options.get(FIX_BITMAP_SIZE_TO_REQUESTED_DIMENSIONS);
        boolean bl2 = options.get(ALLOW_HARDWARE_CONFIG) != null && options.get(ALLOW_HARDWARE_CONFIG) != false;
        if (decodeFormat == DecodeFormat.PREFER_ARGB_8888_DISALLOW_HARDWARE) {
            bl2 = false;
        }
        try {
            object = BitmapResource.obtain(this.decodeFromWrappedStreams((InputStream)object, options2, downsampleStrategy, decodeFormat, bl2, n2, n3, bl, decodeCallbacks), this.bitmapPool);
            return object;
        }
        finally {
            Downsampler.releaseOptions(options2);
            this.byteArrayPool.put(byArray);
        }
    }

    public boolean handles(InputStream inputStream) {
        return true;
    }

    public boolean handles(ByteBuffer byteBuffer) {
        return true;
    }

    public static interface DecodeCallbacks {
        public void onDecodeComplete(BitmapPool var1, Bitmap var2) throws IOException;

        public void onObtainBounds();
    }
}

