/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

public abstract class DownsampleStrategy {
    public static final DownsampleStrategy AT_LEAST;
    public static final DownsampleStrategy AT_MOST;
    public static final DownsampleStrategy CENTER_INSIDE;
    public static final DownsampleStrategy CENTER_OUTSIDE;
    public static final DownsampleStrategy DEFAULT;
    public static final DownsampleStrategy FIT_CENTER;
    public static final DownsampleStrategy NONE;

    static {
        FIT_CENTER = new FitCenter();
        CENTER_OUTSIDE = new CenterOutside();
        AT_LEAST = new AtLeast();
        AT_MOST = new AtMost();
        CENTER_INSIDE = new CenterInside();
        NONE = new None();
        DEFAULT = CENTER_OUTSIDE;
    }

    public abstract SampleSizeRounding getSampleSizeRounding(int var1, int var2, int var3, int var4);

    public abstract float getScaleFactor(int var1, int var2, int var3, int var4);

    private static class AtLeast
    extends DownsampleStrategy {
        AtLeast() {
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int n2, int n3, int n4, int n5) {
            return SampleSizeRounding.QUALITY;
        }

        @Override
        public float getScaleFactor(int n2, int n3, int n4, int n5) {
            n2 = Math.min(n3 / n5, n2 / n4);
            float f3 = 1.0f;
            if (n2 != 0) {
                f3 = 1.0f / (float)Integer.highestOneBit(n2);
            }
            return f3;
        }
    }

    private static class AtMost
    extends DownsampleStrategy {
        AtMost() {
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int n2, int n3, int n4, int n5) {
            return SampleSizeRounding.MEMORY;
        }

        @Override
        public float getScaleFactor(int n2, int n3, int n4, int n5) {
            n4 = (int)Math.ceil(Math.max((float)n3 / (float)n5, (float)n2 / (float)n4));
            n3 = Integer.highestOneBit(n4);
            n2 = 1;
            if ((n3 = Math.max(1, n3)) >= n4) {
                n2 = 0;
            }
            return 1.0f / (float)(n3 << n2);
        }
    }

    private static class CenterInside
    extends DownsampleStrategy {
        CenterInside() {
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int n2, int n3, int n4, int n5) {
            return SampleSizeRounding.QUALITY;
        }

        @Override
        public float getScaleFactor(int n2, int n3, int n4, int n5) {
            return Math.min(1.0f, FIT_CENTER.getScaleFactor(n2, n3, n4, n5));
        }
    }

    private static class CenterOutside
    extends DownsampleStrategy {
        CenterOutside() {
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int n2, int n3, int n4, int n5) {
            return SampleSizeRounding.QUALITY;
        }

        @Override
        public float getScaleFactor(int n2, int n3, int n4, int n5) {
            return Math.max((float)n4 / (float)n2, (float)n5 / (float)n3);
        }
    }

    private static class FitCenter
    extends DownsampleStrategy {
        FitCenter() {
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int n2, int n3, int n4, int n5) {
            return SampleSizeRounding.QUALITY;
        }

        @Override
        public float getScaleFactor(int n2, int n3, int n4, int n5) {
            return Math.min((float)n4 / (float)n2, (float)n5 / (float)n3);
        }
    }

    private static class None
    extends DownsampleStrategy {
        None() {
        }

        @Override
        public SampleSizeRounding getSampleSizeRounding(int n2, int n3, int n4, int n5) {
            return SampleSizeRounding.QUALITY;
        }

        @Override
        public float getScaleFactor(int n2, int n3, int n4, int n5) {
            return 1.0f;
        }
    }

    public static enum SampleSizeRounding {
        MEMORY,
        QUALITY;

    }
}

