/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.util.Log;
import com.bumptech.glide.load.ImageHeaderParser;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.util.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;

public final class DefaultImageHeaderParser
implements ImageHeaderParser {
    private static final int[] BYTES_PER_FORMAT;
    static final int EXIF_MAGIC_NUMBER = 65496;
    static final int EXIF_SEGMENT_TYPE = 225;
    private static final int GIF_HEADER = 4671814;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final String JPEG_EXIF_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    static final byte[] JPEG_EXIF_SEGMENT_PREAMBLE_BYTES;
    private static final int MARKER_EOI = 217;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int ORIENTATION_TAG_TYPE = 274;
    private static final int PNG_HEADER = -1991225785;
    private static final int RIFF_HEADER = 1380533830;
    private static final int SEGMENT_SOS = 218;
    static final int SEGMENT_START_ID = 255;
    private static final String TAG = "DfltImageHeaderParser";
    private static final int VP8_HEADER = 1448097792;
    private static final int VP8_HEADER_MASK = -256;
    private static final int VP8_HEADER_TYPE_EXTENDED = 88;
    private static final int VP8_HEADER_TYPE_LOSSLESS = 76;
    private static final int VP8_HEADER_TYPE_MASK = 255;
    private static final int WEBP_EXTENDED_ALPHA_FLAG = 16;
    private static final int WEBP_HEADER = 1464156752;
    private static final int WEBP_LOSSLESS_ALPHA_FLAG = 8;

    static {
        JPEG_EXIF_SEGMENT_PREAMBLE_BYTES = JPEG_EXIF_SEGMENT_PREAMBLE.getBytes(Charset.forName("UTF-8"));
        BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};
    }

    private static int calcTagOffset(int n2, int n3) {
        return n2 + 2 + n3 * 12;
    }

    private int getOrientation(Reader object, ArrayPool arrayPool) throws IOException {
        int n2 = object.getUInt16();
        if (!DefaultImageHeaderParser.handles(n2)) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Parser doesn't handle magic number: ");
                ((StringBuilder)object).append(n2);
                Log.d((String)TAG, (String)((StringBuilder)object).toString());
            }
            return -1;
        }
        n2 = this.moveToExifSegmentAndGetLength((Reader)object);
        if (n2 == -1) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to parse exif segment length, or exif segment not found");
            }
            return -1;
        }
        byte[] byArray = arrayPool.get(n2, byte[].class);
        try {
            n2 = this.parseExifSegment((Reader)object, byArray, n2);
            return n2;
        }
        finally {
            arrayPool.put(byArray);
        }
    }

    private ImageHeaderParser.ImageType getType(Reader object) throws IOException {
        int n2 = object.getUInt16();
        if (n2 == 65496) {
            return ImageHeaderParser.ImageType.JPEG;
        }
        if ((n2 = n2 << 16 & 0xFFFF0000 | object.getUInt16() & 0xFFFF) == -1991225785) {
            object.skip(21L);
            object = object.getByte() >= 3 ? ImageHeaderParser.ImageType.PNG_A : ImageHeaderParser.ImageType.PNG;
            return object;
        }
        if (n2 >> 8 == 4671814) {
            return ImageHeaderParser.ImageType.GIF;
        }
        if (n2 != 1380533830) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        object.skip(4L);
        if ((object.getUInt16() << 16 & 0xFFFF0000 | object.getUInt16() & 0xFFFF) != 1464156752) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        n2 = object.getUInt16() << 16 & 0xFFFF0000 | object.getUInt16() & 0xFFFF;
        if ((n2 & 0xFFFFFF00) != 1448097792) {
            return ImageHeaderParser.ImageType.UNKNOWN;
        }
        if ((n2 &= 0xFF) == 88) {
            object.skip(4L);
            object = (object.getByte() & 0x10) != 0 ? ImageHeaderParser.ImageType.WEBP_A : ImageHeaderParser.ImageType.WEBP;
            return object;
        }
        if (n2 == 76) {
            object.skip(4L);
            object = (object.getByte() & 8) != 0 ? ImageHeaderParser.ImageType.WEBP_A : ImageHeaderParser.ImageType.WEBP;
            return object;
        }
        return ImageHeaderParser.ImageType.WEBP;
    }

    private static boolean handles(int n2) {
        boolean bl = (n2 & 0xFFD8) == 65496 || n2 == 19789 || n2 == 18761;
        return bl;
    }

    private boolean hasJpegExifPreamble(byte[] byArray, int n2) {
        boolean bl = byArray != null && n2 > JPEG_EXIF_SEGMENT_PREAMBLE_BYTES.length;
        boolean bl2 = bl;
        if (bl) {
            n2 = 0;
            while (true) {
                byte[] byArray2 = JPEG_EXIF_SEGMENT_PREAMBLE_BYTES;
                bl2 = bl;
                if (n2 >= byArray2.length) break;
                if (byArray[n2] != byArray2[n2]) {
                    bl2 = false;
                    break;
                }
                ++n2;
            }
        }
        return bl2;
    }

    private int moveToExifSegmentAndGetLength(Reader object) throws IOException {
        int n2;
        block7: {
            short s2;
            long l3;
            long l4;
            do {
                if ((s2 = object.getUInt8()) != 255) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("Unknown segmentId=");
                        ((StringBuilder)object).append(s2);
                        Log.d((String)TAG, (String)((StringBuilder)object).toString());
                    }
                    return -1;
                }
                s2 = object.getUInt8();
                if (s2 == 218) {
                    return -1;
                }
                if (s2 == 217) {
                    if (Log.isLoggable((String)TAG, (int)3)) {
                        Log.d((String)TAG, (String)"Found MARKER_EOI in exif segment");
                    }
                    return -1;
                }
                n2 = object.getUInt16() - 2;
                if (s2 == 225) break block7;
            } while ((l4 = object.skip(l3 = (long)n2)) == l3);
            if (Log.isLoggable((String)TAG, (int)3)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Unable to skip enough data, type: ");
                ((StringBuilder)object).append(s2);
                ((StringBuilder)object).append(", wanted to skip: ");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append(", but actually skipped: ");
                ((StringBuilder)object).append(l4);
                Log.d((String)TAG, (String)((StringBuilder)object).toString());
            }
            return -1;
        }
        return n2;
    }

    private static int parseExifSegment(RandomAccessReader randomAccessReader) {
        Object object;
        int n2 = randomAccessReader.getInt16(6);
        if (n2 != 18761) {
            if (n2 != 19789) {
                if (Log.isLoggable((String)TAG, (int)3)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unknown endianness = ");
                    ((StringBuilder)object).append(n2);
                    Log.d((String)TAG, (String)((StringBuilder)object).toString());
                }
                object = ByteOrder.BIG_ENDIAN;
            } else {
                object = ByteOrder.BIG_ENDIAN;
            }
        } else {
            object = ByteOrder.LITTLE_ENDIAN;
        }
        randomAccessReader.order((ByteOrder)object);
        int n3 = randomAccessReader.getInt32(10) + 6;
        int n4 = randomAccessReader.getInt16(n3);
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = DefaultImageHeaderParser.calcTagOffset(n3, n2);
            short s2 = randomAccessReader.getInt16(n5);
            if (s2 != 274) continue;
            int n6 = randomAccessReader.getInt16(n5 + 2);
            if (n6 >= 1 && n6 <= 12) {
                int n7 = randomAccessReader.getInt32(n5 + 4);
                if (n7 < 0) {
                    if (!Log.isLoggable((String)TAG, (int)3)) continue;
                    Log.d((String)TAG, (String)"Negative tiff component count");
                    continue;
                }
                if (Log.isLoggable((String)TAG, (int)3)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Got tagIndex=");
                    ((StringBuilder)object).append(n2);
                    ((StringBuilder)object).append(" tagType=");
                    ((StringBuilder)object).append(s2);
                    ((StringBuilder)object).append(" formatCode=");
                    ((StringBuilder)object).append(n6);
                    ((StringBuilder)object).append(" componentCount=");
                    ((StringBuilder)object).append(n7);
                    Log.d((String)TAG, (String)((StringBuilder)object).toString());
                }
                if ((n7 += BYTES_PER_FORMAT[n6]) > 4) {
                    if (!Log.isLoggable((String)TAG, (int)3)) continue;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Got byte count > 4, not orientation, continuing, formatCode=");
                    ((StringBuilder)object).append(n6);
                    Log.d((String)TAG, (String)((StringBuilder)object).toString());
                    continue;
                }
                n6 = n5 + 8;
                if (n6 >= 0 && n6 <= randomAccessReader.length()) {
                    if (n7 >= 0 && n7 + n6 <= randomAccessReader.length()) {
                        return randomAccessReader.getInt16(n6);
                    }
                    if (!Log.isLoggable((String)TAG, (int)3)) continue;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Illegal number of bytes for TI tag data tagType=");
                    ((StringBuilder)object).append(s2);
                    Log.d((String)TAG, (String)((StringBuilder)object).toString());
                    continue;
                }
                if (!Log.isLoggable((String)TAG, (int)3)) continue;
                object = new StringBuilder();
                ((StringBuilder)object).append("Illegal tagValueOffset=");
                ((StringBuilder)object).append(n6);
                ((StringBuilder)object).append(" tagType=");
                ((StringBuilder)object).append(s2);
                Log.d((String)TAG, (String)((StringBuilder)object).toString());
                continue;
            }
            if (!Log.isLoggable((String)TAG, (int)3)) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append("Got invalid format code = ");
            ((StringBuilder)object).append(n6);
            Log.d((String)TAG, (String)((StringBuilder)object).toString());
        }
        return -1;
    }

    private int parseExifSegment(Reader object, byte[] byArray, int n2) throws IOException {
        int n3 = object.read(byArray, n2);
        if (n3 != n2) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("Unable to read exif segment data, length: ");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append(", actually read: ");
                ((StringBuilder)object).append(n3);
                Log.d((String)TAG, (String)((StringBuilder)object).toString());
            }
            return -1;
        }
        if (this.hasJpegExifPreamble(byArray, n2)) {
            return DefaultImageHeaderParser.parseExifSegment(new RandomAccessReader(byArray, n2));
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)"Missing jpeg exif preamble");
        }
        return -1;
    }

    @Override
    public int getOrientation(InputStream inputStream, ArrayPool arrayPool) throws IOException {
        return this.getOrientation(new StreamReader(Preconditions.checkNotNull(inputStream)), Preconditions.checkNotNull(arrayPool));
    }

    @Override
    public int getOrientation(ByteBuffer byteBuffer, ArrayPool arrayPool) throws IOException {
        return this.getOrientation(new ByteBufferReader(Preconditions.checkNotNull(byteBuffer)), Preconditions.checkNotNull(arrayPool));
    }

    @Override
    public ImageHeaderParser.ImageType getType(InputStream inputStream) throws IOException {
        return this.getType(new StreamReader(Preconditions.checkNotNull(inputStream)));
    }

    @Override
    public ImageHeaderParser.ImageType getType(ByteBuffer byteBuffer) throws IOException {
        return this.getType(new ByteBufferReader(Preconditions.checkNotNull(byteBuffer)));
    }

    private static final class ByteBufferReader
    implements Reader {
        private final ByteBuffer byteBuffer;

        ByteBufferReader(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }

        @Override
        public int getByte() throws IOException {
            if (this.byteBuffer.remaining() < 1) {
                return -1;
            }
            return this.byteBuffer.get();
        }

        @Override
        public int getUInt16() throws IOException {
            return this.getByte() << 8 & 0xFF00 | this.getByte() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.getByte() & 0xFF);
        }

        @Override
        public int read(byte[] byArray, int n2) throws IOException {
            if ((n2 = Math.min(n2, this.byteBuffer.remaining())) == 0) {
                return -1;
            }
            this.byteBuffer.get(byArray, 0, n2);
            return n2;
        }

        @Override
        public long skip(long l3) throws IOException {
            int n2 = (int)Math.min((long)this.byteBuffer.remaining(), l3);
            ByteBuffer byteBuffer = this.byteBuffer;
            byteBuffer.position(byteBuffer.position() + n2);
            return n2;
        }
    }

    private static final class RandomAccessReader {
        private final ByteBuffer data;

        RandomAccessReader(byte[] byArray, int n2) {
            this.data = (ByteBuffer)ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).limit(n2);
        }

        private boolean isAvailable(int n2, int n3) {
            boolean bl = this.data.remaining() - n2 >= n3;
            return bl;
        }

        short getInt16(int n2) {
            int n3 = this.isAvailable(n2, 2) ? (n2 = (int)this.data.getShort(n2)) : (n2 = -1);
            return (short)n3;
        }

        int getInt32(int n2) {
            n2 = this.isAvailable(n2, 4) ? this.data.getInt(n2) : -1;
            return n2;
        }

        int length() {
            return this.data.remaining();
        }

        void order(ByteOrder byteOrder) {
            this.data.order(byteOrder);
        }
    }

    private static interface Reader {
        public int getByte() throws IOException;

        public int getUInt16() throws IOException;

        public short getUInt8() throws IOException;

        public int read(byte[] var1, int var2) throws IOException;

        public long skip(long var1) throws IOException;
    }

    private static final class StreamReader
    implements Reader {
        private final InputStream is;

        StreamReader(InputStream inputStream) {
            this.is = inputStream;
        }

        @Override
        public int getByte() throws IOException {
            return this.is.read();
        }

        @Override
        public int getUInt16() throws IOException {
            return this.is.read() << 8 & 0xFF00 | this.is.read() & 0xFF;
        }

        @Override
        public short getUInt8() throws IOException {
            return (short)(this.is.read() & 0xFF);
        }

        @Override
        public int read(byte[] byArray, int n2) throws IOException {
            int n3;
            int n4;
            for (n3 = n2; n3 > 0 && (n4 = this.is.read(byArray, n2 - n3, n3)) != -1; n3 -= n4) {
            }
            return n2 - n3;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public long skip(long l3) throws IOException {
            if (l3 < 0L) {
                return 0L;
            }
            long l4 = l3;
            while (l4 > 0L) {
                long l5 = this.is.skip(l4);
                if (l5 <= 0L) {
                    if (this.is.read() == -1) {
                        return l3 - l4;
                    }
                    l5 = 1L;
                }
                l4 -= l5;
            }
            return l3 - l4;
        }
    }
}

